# Luanti mod: manage_entities

This mod allows users to limit the number configured entities in an area to prevent performance problems caused by too many entities.

It simply adds a check to configured entities (only `__builtin:item` as defaiult) which removes entity if there are too many entities in area.

## Settings

Check `settingtypes.txt` for settings details or/and Luanti settings menu.

You can set:
- **Default check radius and entities limit** - Used as default values for all entities
- **Entity list** - Comma-separated list of entities to apply limits to (default: `__builtin:item`)
- **Per-entity check radius** - Custom radius for specific entities
- **Per-entity entities limit** - Custom limit for specific entities

## Commands

### Entity Check Command

Check all active entities on the server and report positions where entity count exceeds the limit.

**Privilege required:** `server`

```
/manage_entities_check [<check_radius>] [<entities_limit>]
```

**Parameters (optional):**
- `check_radius` - Radius to check around each entity (default: from settings)
- `entities_limit` - Maximum entities allowed in the radius (default: from settings)

**Example:**
```
/manage_entities_check 2.0 100
```

This command will:
- Scan all active entities on the server
- Check how many entities are within the specified radius of each entity
- Report positions where the count exceeds the limit
- Provide a summary of entity types found and total counts

## Debug Command

When `manage_entities.debug_command` is enabled, you can use:

```
/manage_entities_test <item_name> <stacks_per_interval> <interval_time> <intervals>
```

**Parameters:**
- `item_name` - The technical name of the item (e.g., `default:dirt`)
- `stacks_per_interval` - Number of full stacks to drop in each interval
- `interval_time` - Time in seconds between each drop interval
- `intervals` - Number of intervals to run the test

**Example:**
```
/manage_entities_test default:dirt 1000 5 50
```
This will drop 1000 full stacks of dirt every 5 seconds, for 50 intervals total. The command reports server performance statistics during the test.

## Source code

Copyright (c) 2026 SFENCE
MIT - check LICENSE file
