
local S = manage_entities.translator

local set_item_name = ""
local set_stacks_per_interval = 0
local set_interval_time = 0
local set_intervals = 0
local set_player_name = ""
local interval_time = 0
local intervals = 0
local dtime_min = 0
local dtime_max = 0
local dtime_sum = 0
local dtime_sums = 0
local stacks_dropped = 0
local drop_pos = nil

core.register_chatcommand("manage_entities_test", {
	params = "item_name items_per_interval interval_time intervals",
	description = S("Test dropping items to check limit functionality"),
	privs = {debug=true},
	func = function(player_name, params)
		local args = params:split(" ")
		
		if #args < 4 then
			return false, S("Usage: /manage_entities_test <item_name> <items_per_interval> <interval_time> <intervals>")
		end
		
		set_player_name = player_name
		set_item_name = args[1]
		set_stacks_per_interval = tonumber(args[2]) or 0
		set_interval_time = tonumber(args[3]) or 0
		set_intervals = tonumber(args[4]) or 0
		
		if set_stacks_per_interval <= 0 or set_interval_time <= 0 or set_intervals <= 0 then
			return false, S("All numeric parameters must be greater than 0")
		end
		
		-- Reset counters
		interval_time = set_interval_time
		intervals = set_intervals
		dtime_min = math.huge
		dtime_max = 0
		dtime_sum = 0
		dtime_sums = 0
		stacks_dropped = 0
		local player = core.get_player_by_name(player_name)
		drop_pos = player:get_pos()

		return true, S("Test started: dropping @1 x @2 every @3 for @4 intervals", 
			set_stacks_per_interval, set_item_name, set_interval_time, set_intervals)
	end,
})

core.register_globalstep(function(dtime)
	if intervals==0 then
		return
	end

	dtime_min = math.min(dtime_min, dtime)
	dtime_max = math.max(dtime_max, dtime)
	dtime_sum = dtime_sum + dtime
	dtime_sums = dtime_sums + 1
	interval_time = interval_time - dtime
	if interval_time <= 0 then
		-- send msg to player, about last interval
		core.chat_send_player(set_player_name, S("Dropped stacks: @1", stacks_dropped))
		core.chat_send_player(set_player_name, S("Server step avarage: @1 min: @2 max: @3", dtime_sum / dtime_sums, dtime_min, dtime_max))

		intervals = intervals - 1
		if intervals > 0 then
			-- Drop items
			local stack = ItemStack(set_item_name)
			stack:set_count(stack:get_stack_max())
			for i = 1, set_stacks_per_interval do
				core.add_item(drop_pos, stack)
			end
			interval_time = set_interval_time
			dtime_min = math.huge
			dtime_max = 0
			dtime_sum = 0
			dtime_sums = 0
			stacks_dropped = stacks_dropped + set_stacks_per_interval
		else
			core.chat_send_player(set_player_name, S("Dropping finished"))
		end
	end
end)
