
local settings = manage_entities.settings

core.register_on_mods_loaded(function()
	-- Apply limits to all entities in the entity list
	for entity_name, config in pairs(settings.entity_configs) do
		local def = core.registered_entities[entity_name]
		if def then
			local orig_activate = def.on_activate
			
			def.on_activate = function(self, staticdata, dtime_s)
				local objects = core.get_objects_inside_radius(self.object:get_pos(), config.check_radius)
				if #objects >= config.entities_limit then
					self.object:remove()
					return
				end
				if orig_activate then
					orig_activate(self, staticdata, dtime_s)
				end
			end
		else
			minetest.log("warning", "[manage_entities] Entity '" .. entity_name .. "' not found in registered entities")
		end
	end
end)

