
manage_entities.settings = {}

local settings = manage_entities.settings

settings.debug_command = minetest.settings:get_bool("manage_entities.debug_command", false)
settings.config_command = minetest.settings:get_bool("manage_entities.config_command", false)
settings.check_radius = tonumber(minetest.settings:get("manage_entities.check_radius")) or 1.0
settings.entities_limit = tonumber(minetest.settings:get("manage_entities.entities_limit")) or 64

-- Parse entity list
local entity_list_str = minetest.settings:get("manage_entities.entity_list") or "__builtin:item"
settings.entity_list = {}
for entity_name in entity_list_str:gmatch("[^,]+") do
	local trimmed = entity_name:match("^%s*(.-)%s*$")  -- trim whitespace
	if trimmed ~= "" then
		table.insert(settings.entity_list, trimmed)
	end
end

-- Parse per-entity settings
settings.entity_configs = {}

-- Parse per-entity check radius
local per_entity_radius_str = minetest.settings:get("manage_entities.per_entity_check_radius") or ""
if per_entity_radius_str ~= "" then
	for entity_config in per_entity_radius_str:gmatch("[^;]+") do
		local entity_name, radius_str = entity_config:match("^%s*([^=]+)=(.+)%s*$")
		if entity_name and radius_str then
			entity_name = entity_name:match("^%s*(.-)%s*$")  -- trim
			local radius = tonumber(radius_str)
			
			if not settings.entity_configs[entity_name] then
				settings.entity_configs[entity_name] = {}
			end
			settings.entity_configs[entity_name].check_radius = radius or settings.check_radius
		end
	end
end

-- Parse per-entity entities limit
local per_entity_limit_str = minetest.settings:get("manage_entities.per_entity_entities_limit") or ""
if per_entity_limit_str ~= "" then
	for entity_config in per_entity_limit_str:gmatch("[^;]+") do
		local entity_name, limit_str = entity_config:match("^%s*([^=]+)=(.+)%s*$")
		if entity_name and limit_str then
			entity_name = entity_name:match("^%s*(.-)%s*$")  -- trim
			local limit = tonumber(limit_str)
			
			if not settings.entity_configs[entity_name] then
				settings.entity_configs[entity_name] = {}
			end
			settings.entity_configs[entity_name].entities_limit = limit or settings.entities_limit
		end
	end
end

-- For entities in entity_list that don't have specific config, use defaults
for _, entity_name in ipairs(settings.entity_list) do
	if not settings.entity_configs[entity_name] then
		settings.entity_configs[entity_name] = {}
	end
	
	-- Fill in missing values with defaults
	if not settings.entity_configs[entity_name].check_radius then
		settings.entity_configs[entity_name].check_radius = settings.check_radius
	end
	if not settings.entity_configs[entity_name].entities_limit then
		settings.entity_configs[entity_name].entities_limit = settings.entities_limit
	end
end
