
local S = trapworks_strings.translator

local node_box_ground = {
	type = "fixed",
	fixed = {
		{-0.375,-0.5,-0.4375,-0.25,-0.4375,-0.375},
		{0.25,-0.5,-0.4375,0.3125,-0.4375,-0.1875},
		{-0.4375,-0.5,-0.375,-0.375,-0.4375,-0.25},
		{-0.3125,-0.5,-0.375,-0.125,-0.4375,-0.3125},
		{0.125,-0.5,-0.375,0.25,-0.4375,-0.3125},
		{0.3125,-0.5,-0.375,0.375,-0.4375,-0.125},
		{-0.3125,-0.4375,-0.375,-0.25,-0.375,-0.1875},
		{0.25,-0.4375,-0.375,0.3125,-0.375,-0.1875},
		{-0.375,-0.5,-0.3125,-0.1875,-0.4375,-0.1875},
		{-0.125,-0.5,-0.3125,0.125,-0.4375,-0.25},
		{0.1875,-0.5,-0.3125,0.25,-0.375,-0.25},
		{0.375,-0.5,-0.3125,0.4375,-0.4375,-0.25},
		{-0.375,-0.4375,-0.3125,-0.3125,-0.375,-0.25},
		{-0.25,-0.4375,-0.3125,-0.1875,-0.375,-0.25},
		{0.3125,-0.4375,-0.3125,0.375,-0.375,-0.25},
		{0.1875,-0.5,-0.25,0.25,-0.4375,-0.1875},
		{-0.375,-0.5,-0.1875,-0.3125,-0.4375,0.0},
		{-0.1875,-0.5,-0.1875,-0.125,-0.4375,-0.125},
		{0.125,-0.5,-0.1875,0.1875,-0.4375,-0.125},
		{-0.125,-0.5,-0.125,-0.0625,-0.4375,-0.0625},
		{0.0,-0.5,-0.125,0.125,-0.4375,-0.0625},
		{0.375,-0.5,-0.125,0.4375,-0.4375,0.125},
		{-0.0625,-0.5,-0.0625,0.0,-0.4375,0.0},
		{-0.3125,-0.5,0.0,-0.25,-0.4375,0.125},
		{-0.125,-0.5,0.0,-0.0625,-0.4375,0.125},
		{0.0,-0.5,0.0,0.125,-0.4375,0.0625},
		{0.125,-0.5,0.0625,0.1875,-0.4375,0.125},
		{-0.375,-0.5,0.125,-0.3125,-0.4375,0.3125},
		{-0.1875,-0.5,0.125,-0.125,-0.4375,0.1875},
		{0.1875,-0.5,0.125,0.25,-0.4375,0.375},
		{0.3125,-0.5,0.125,0.375,-0.4375,0.375},
		{-0.3125,-0.5,0.1875,-0.1875,-0.4375,0.375},
		{0.25,-0.5,0.1875,0.3125,-0.375,0.375},
		{-0.3125,-0.4375,0.1875,-0.25,-0.375,0.375},
		{-0.4375,-0.5,0.25,-0.375,-0.4375,0.375},
		{0.375,-0.5,0.25,0.4375,-0.4375,0.3125},
		{-0.375,-0.4375,0.25,-0.3125,-0.375,0.3125},
		{-0.25,-0.4375,0.25,-0.1875,-0.375,0.3125},
		{0.1875,-0.4375,0.25,0.25,-0.375,0.3125},
		{0.3125,-0.4375,0.25,0.375,-0.375,0.3125},
		{0.125,-0.5,0.3125,0.1875,-0.4375,0.375},
		{-0.375,-0.5,0.375,-0.25,-0.4375,0.4375},
		{-0.1875,-0.5,0.375,0.125,-0.4375,0.4375},
		{0.25,-0.5,0.375,0.3125,-0.4375,0.4375},
	},
}
local node_box_l1 = {
	type = "fixed",
	fixed = {
		{-0.125,-0.375,-0.4375,0.125,-0.3125,-0.375},
		{-0.3125,-0.3125,-0.4375,-0.125,-0.25,-0.375},
		{0.125,-0.3125,-0.4375,0.3125,-0.25,-0.375},
		{-0.3125,-0.5,-0.375,-0.25,-0.1875,-0.1875},
		{0.25,-0.5,-0.375,0.3125,-0.1875,-0.1875},
		{-0.375,-0.3125,-0.375,-0.3125,-0.25,-0.1875},
		{-0.25,-0.3125,-0.375,-0.1875,-0.25,-0.1875},
		{0.1875,-0.3125,-0.375,0.25,-0.25,-0.1875},
		{0.3125,-0.3125,-0.375,0.375,-0.25,-0.1875},
		{-0.375,-0.5,-0.3125,-0.3125,-0.3125,-0.25},
		{-0.25,-0.5,-0.3125,-0.1875,-0.3125,-0.25},
		{0.1875,-0.5,-0.3125,0.25,-0.3125,-0.25},
		{0.3125,-0.5,-0.3125,0.375,-0.3125,-0.25},
		{-0.4375,-0.3125,-0.3125,-0.375,-0.25,-0.125},
		{-0.1875,-0.3125,-0.3125,-0.125,-0.25,-0.25},
		{0.125,-0.3125,-0.3125,0.1875,-0.25,-0.25},
		{0.375,-0.3125,-0.3125,0.4375,-0.25,-0.125},
		{-0.375,-0.25,-0.3125,-0.3125,-0.1875,-0.25},
		{-0.25,-0.25,-0.3125,-0.1875,-0.1875,-0.25},
		{0.1875,-0.25,-0.3125,0.25,-0.1875,-0.25},
		{0.3125,-0.25,-0.3125,0.375,-0.1875,-0.25},
		{-0.3125,-0.3125,-0.1875,-0.25,-0.25,-0.125},
		{-0.1875,-0.3125,-0.1875,-0.125,-0.25,-0.125},
		{0.125,-0.3125,-0.1875,0.1875,-0.25,-0.125},
		{0.25,-0.3125,-0.1875,0.3125,-0.25,-0.125},
		{-0.4375,-0.375,-0.125,-0.375,-0.3125,0.125},
		{-0.125,-0.375,-0.125,-0.0625,-0.3125,-0.0625},
		{0.0625,-0.375,-0.125,0.125,-0.3125,-0.0625},
		{0.375,-0.375,-0.125,0.4375,-0.3125,0.125},
		{-0.0625,-0.375,-0.0625,0.0625,-0.3125,0.0625},
		{-0.125,-0.375,0.0625,-0.0625,-0.3125,0.125},
		{0.0625,-0.375,0.0625,0.125,-0.3125,0.125},
		{-0.4375,-0.3125,0.125,-0.375,-0.25,0.3125},
		{-0.3125,-0.3125,0.125,-0.25,-0.25,0.4375},
		{-0.1875,-0.3125,0.125,-0.125,-0.25,0.1875},
		{0.125,-0.3125,0.125,0.1875,-0.25,0.1875},
		{0.25,-0.3125,0.125,0.3125,-0.25,0.4375},
		{0.375,-0.3125,0.125,0.4375,-0.25,0.3125},
		{-0.3125,-0.5,0.1875,-0.25,-0.3125,0.375},
		{0.25,-0.5,0.1875,0.3125,-0.3125,0.375},
		{-0.375,-0.3125,0.1875,-0.3125,-0.25,0.375},
		{-0.25,-0.3125,0.1875,-0.1875,-0.25,0.4375},
		{0.1875,-0.3125,0.1875,0.25,-0.25,0.4375},
		{0.3125,-0.3125,0.1875,0.375,-0.25,0.375},
		{-0.3125,-0.25,0.1875,-0.25,-0.1875,0.375},
		{0.25,-0.25,0.1875,0.3125,-0.1875,0.375},
		{-0.375,-0.5,0.25,-0.3125,-0.3125,0.3125},
		{-0.25,-0.5,0.25,-0.1875,-0.3125,0.3125},
		{0.1875,-0.5,0.25,0.25,-0.3125,0.3125},
		{0.3125,-0.5,0.25,0.375,-0.3125,0.3125},
		{-0.1875,-0.3125,0.25,-0.125,-0.25,0.3125},
		{0.125,-0.3125,0.25,0.1875,-0.25,0.3125},
		{-0.375,-0.25,0.25,-0.3125,-0.1875,0.3125},
		{-0.25,-0.25,0.25,-0.1875,-0.1875,0.3125},
		{0.1875,-0.25,0.25,0.25,-0.1875,0.3125},
		{0.3125,-0.25,0.25,0.375,-0.1875,0.3125},
		{-0.125,-0.375,0.375,0.125,-0.3125,0.4375},
		{-0.1875,-0.3125,0.375,-0.125,-0.25,0.4375},
		{0.125,-0.3125,0.375,0.1875,-0.25,0.4375},
	},
}
local node_box_l2 = {
	type = "fixed",
	fixed = {
		{-0.125,-0.1875,-0.4375,0.125,-0.125,-0.375},
		{-0.3125,-0.125,-0.4375,-0.125,-0.0625,-0.375},
		{0.125,-0.125,-0.4375,0.3125,-0.0625,-0.375},
		{-0.3125,-0.5,-0.375,-0.25,0.0,-0.1875},
		{0.25,-0.5,-0.375,0.3125,0.0,-0.1875},
		{-0.375,-0.125,-0.375,-0.3125,-0.0625,-0.1875},
		{-0.25,-0.125,-0.375,-0.1875,-0.0625,-0.1875},
		{0.1875,-0.125,-0.375,0.25,-0.0625,-0.1875},
		{0.3125,-0.125,-0.375,0.375,-0.0625,-0.1875},
		{-0.375,-0.5,-0.3125,-0.3125,-0.125,-0.25},
		{-0.25,-0.5,-0.3125,-0.1875,-0.125,-0.25},
		{0.1875,-0.5,-0.3125,0.25,-0.125,-0.25},
		{0.3125,-0.5,-0.3125,0.375,-0.125,-0.25},
		{-0.4375,-0.125,-0.3125,-0.375,-0.0625,-0.125},
		{-0.1875,-0.125,-0.3125,-0.125,-0.0625,-0.25},
		{0.125,-0.125,-0.3125,0.1875,-0.0625,-0.25},
		{0.375,-0.125,-0.3125,0.4375,-0.0625,-0.125},
		{-0.375,-0.0625,-0.3125,-0.3125,0.0,-0.25},
		{-0.25,-0.0625,-0.3125,-0.1875,0.0,-0.25},
		{0.1875,-0.0625,-0.3125,0.25,0.0,-0.25},
		{0.3125,-0.0625,-0.3125,0.375,0.0,-0.25},
		{-0.3125,-0.125,-0.1875,-0.25,-0.0625,-0.125},
		{-0.1875,-0.125,-0.1875,-0.125,-0.0625,-0.125},
		{0.125,-0.125,-0.1875,0.1875,-0.0625,-0.125},
		{0.25,-0.125,-0.1875,0.3125,-0.0625,-0.125},
		{-0.4375,-0.1875,-0.125,-0.375,-0.125,0.125},
		{-0.125,-0.1875,-0.125,-0.0625,-0.125,-0.0625},
		{0.0625,-0.1875,-0.125,0.125,-0.125,-0.0625},
		{0.375,-0.1875,-0.125,0.4375,-0.125,0.125},
		{-0.0625,-0.1875,-0.0625,0.0625,-0.125,0.0625},
		{-0.125,-0.1875,0.0625,-0.0625,-0.125,0.125},
		{0.0625,-0.1875,0.0625,0.125,-0.125,0.125},
		{-0.4375,-0.125,0.125,-0.375,-0.0625,0.3125},
		{-0.3125,-0.125,0.125,-0.25,-0.0625,0.4375},
		{-0.1875,-0.125,0.125,-0.125,-0.0625,0.1875},
		{0.125,-0.125,0.125,0.1875,-0.0625,0.1875},
		{0.25,-0.125,0.125,0.3125,-0.0625,0.4375},
		{0.375,-0.125,0.125,0.4375,-0.0625,0.3125},
		{-0.3125,-0.5,0.1875,-0.25,-0.125,0.375},
		{0.25,-0.5,0.1875,0.3125,-0.125,0.375},
		{-0.375,-0.125,0.1875,-0.3125,-0.0625,0.375},
		{-0.25,-0.125,0.1875,-0.1875,-0.0625,0.4375},
		{0.1875,-0.125,0.1875,0.25,-0.0625,0.4375},
		{0.3125,-0.125,0.1875,0.375,-0.0625,0.375},
		{-0.3125,-0.0625,0.1875,-0.25,0.0,0.375},
		{0.25,-0.0625,0.1875,0.3125,0.0,0.375},
		{-0.375,-0.5,0.25,-0.3125,-0.125,0.3125},
		{-0.25,-0.5,0.25,-0.1875,-0.125,0.3125},
		{0.1875,-0.5,0.25,0.25,-0.125,0.3125},
		{0.3125,-0.5,0.25,0.375,-0.125,0.3125},
		{-0.1875,-0.125,0.25,-0.125,-0.0625,0.3125},
		{0.125,-0.125,0.25,0.1875,-0.0625,0.3125},
		{-0.375,-0.0625,0.25,-0.3125,0.0,0.3125},
		{-0.25,-0.0625,0.25,-0.1875,0.0,0.3125},
		{0.1875,-0.0625,0.25,0.25,0.0,0.3125},
		{0.3125,-0.0625,0.25,0.375,0.0,0.3125},
		{-0.125,-0.1875,0.375,0.125,-0.125,0.4375},
		{-0.1875,-0.125,0.375,-0.125,-0.0625,0.4375},
		{0.125,-0.125,0.375,0.1875,-0.0625,0.4375},
	},
}

local node_box_poles_ground = {
	type = "fixed",
	fixed = {
		{-0.3125,-0.5,-0.375,-0.25,-0.375,-0.1875},
		{0.25,-0.5,-0.375,0.3125,-0.375,-0.1875},
		{-0.375,-0.5,-0.3125,-0.3125,-0.375,-0.25},
		{-0.25,-0.5,-0.3125,-0.1875,-0.375,-0.25},
		{0.1875,-0.5,-0.3125,0.25,-0.375,-0.25},
		{0.3125,-0.5,-0.3125,0.375,-0.375,-0.25},
		{-0.3125,-0.5,0.1875,-0.25,-0.375,0.375},
		{0.25,-0.5,0.1875,0.3125,-0.375,0.375},
		{-0.375,-0.5,0.25,-0.3125,-0.375,0.3125},
		{-0.25,-0.5,0.25,-0.1875,-0.375,0.3125},
		{0.1875,-0.5,0.25,0.25,-0.375,0.3125},
		{0.3125,-0.5,0.25,0.375,-0.375,0.3125},
	},
}
-- node box {x=0, y=1, z=0}
local node_box_poles_l1 = {
	type = "fixed",
	fixed = {
		{-0.3125,-0.5,-0.375,-0.25,-0.1875,-0.1875},
		{0.25,-0.5,-0.375,0.3125,-0.1875,-0.1875},
		{-0.375,-0.5,-0.3125,-0.3125,-0.1875,-0.25},
		{-0.25,-0.5,-0.3125,-0.1875,-0.1875,-0.25},
		{0.1875,-0.5,-0.3125,0.25,-0.1875,-0.25},
		{0.3125,-0.5,-0.3125,0.375,-0.1875,-0.25},
		{-0.3125,-0.5,0.1875,-0.25,-0.1875,0.375},
		{0.25,-0.5,0.1875,0.3125,-0.1875,0.375},
		{-0.375,-0.5,0.25,-0.3125,-0.1875,0.3125},
		{-0.25,-0.5,0.25,-0.1875,-0.1875,0.3125},
		{0.1875,-0.5,0.25,0.25,-0.1875,0.3125},
		{0.3125,-0.5,0.25,0.375,-0.1875,0.3125},
	},
}
-- node box {x=0, y=2, z=0}
local node_box_poles_l2 = {
	type = "fixed",
	fixed = {
		{-0.3125,-0.5,-0.375,-0.25,0.0,-0.1875},
		{0.25,-0.5,-0.375,0.3125,0.0,-0.1875},
		{-0.375,-0.5,-0.3125,-0.3125,0.0,-0.25},
		{-0.25,-0.5,-0.3125,-0.1875,0.0,-0.25},
		{0.1875,-0.5,-0.3125,0.25,0.0,-0.25},
		{0.3125,-0.5,-0.3125,0.375,0.0,-0.25},
		{-0.3125,-0.5,0.1875,-0.25,0.0,0.375},
		{0.25,-0.5,0.1875,0.3125,0.0,0.375},
		{-0.375,-0.5,0.25,-0.3125,0.0,0.3125},
		{-0.25,-0.5,0.25,-0.1875,0.0,0.3125},
		{0.1875,-0.5,0.25,0.25,0.0,0.3125},
		{0.3125,-0.5,0.25,0.375,0.0,0.3125},
	},
}
		
 -- fall_damage_add = 400, -- lovest value when some damage is dan to player if only go and fall one node to spikes without jumping

local levels = {
	ground = {
		desc = S("Ground String Trap"),
		mesh = "trapworks_strings_string_ground.obj",
		node_box = node_box_ground,
		move_resistance = 3,
		poles = node_box_poles_ground,
	},
	l1 = {
		desc = S("Angle String Trap"),
		mesh = "trapworks_strings_string_l1.obj",
		node_box = node_box_l1,
		move_resistance = 5,
		poles = node_box_poles_l1,
	},
	l2 = {
		desc = S("Knee String Trap"),
		mesh = "trapworks_strings_string_l2.obj",
		node_box = node_box_l2,
		move_resistance = 7,
		poles = node_box_poles_l2,
	},
}

for key, data in pairs(levels) do
	core.register_node("trapworks_strings:string_"..key, {
		description = S("@1 String Trap", data.desc),
		drawtype = "mesh",
		mesh = data.mesh,
		selection_box = data.node_box,
		collision_box = data.node_box,
		tiles = {"default_tree.png", "trapworks_strings_poles_top.png", "wool_white.png"},
		use_texture_alpha = "opaque",
		groups = {choppy = 3},
		paramtype = "light",
		--move_resistance = data.move_resistance,
		liquid_viscosity = data.move_resistance,
		walkable = false,

		drop = {
			max_items = 1,
			items = {
				{
					items = {"farming:string 3"},
					rarity = 2,
				},
				{
					items = {"farming:string 2"},
					rarity = 1,
				},
			}
		},

		node_dig_prediction = "trapworks_strings:poles_"..key,
		after_dig_node = function(pos)
			core.set_node(pos, {name="trapworks_strings:poles_"..key})
		end,
	})
	core.register_node("trapworks_strings:poles_"..key, {
		description = S("@1 Trap Poles", data.desc),
		drawtype = "nodebox",
		node_box = data.poles,
		selection_box = data.poles,
		collision_box = data.poles,
		tiles = {"trapworks_strings_poles_top.png", "default_tree.png"},
		use_texture_alpha = "opaque",
		groups = {choppy = 3},
		paramtype = "light",
		move_resistance = 2,

		drop = {
			max_items = 1,
			items = {
				{
					items = {"trapworks_parts:pole_wood 4"},
					rarity = 1,
				},
			}
		},

		on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
			local item = clicker:get_wielded_item()
			local item_name = item:get_name()
			local item_count = item:get_count()
			print("Item name: "..item_name)
			if (item_name == "farming:string") and (item_count >= 3) then
				if core.is_creative_enabled(clicker:get_player_name()) then
					-- do nothing
				else
					item:take_item(3)
					clicker:set_wielded_item(item)
				end
				core.set_node(pos, {name="trapworks_strings:string_"..key})
			end
		end,
	})
end
