local S = moretools.translator

local adaptation = moretools.adaptation

local N = adaptation_lib.get_item_name

local inv_next_line_offset = adaptation.player_mod.next_line_offset_inv

moretools.knife_actions = {
	--[[
	{
		action_on_use = function(action, user, pointed_thing)
			-- return wear factor (0..1) or nil if no action was performed
			return 0.5
		end,
		new_node = {name = "mod:new_node", param1 = 2, param2 = 17},
	},
	]]
}

local function knife_on_use(itemstack, user, pointed_thing)
	return moretools.tool_on_use(itemstack, user, pointed_thing, moretools.knife_actions, "_knife_wear")
end

local knifes = {}

if adaptation.stick and adaptation.stone then
	knifes["stone"] = {
		desc = "Stone",
		handle_mat = adaptation.stick,
		body_mat = adaptation.stone,
		_knife_wear = 3000,
	}

end
if adaptation.stick and adaptation.bronze_ingot then
	knifes["bronze"] = {
		desc = "Bronze",
		tex_suffix = adaptation.is_hades and "_hades" or "",
		handle_mat = adaptation.stick,
		body_mat = N(adaptation.bronze_ingot),
		_knife_wear = 1500,
	}
end
if adaptation.stick and adaptation.steel_ingot then
	knifes["steel"] = {
		desc = "Iron",
		handle_mat = adaptation.stick,
		body_mat = N(adaptation.steel_ingot),
		_knife_wear = 2000,
	}
end
if adaptation.steel_rod and adaptation.mese_crystal then
	knifes["mese"] = {
		desc = "Mese",
		tex_suffix = adaptation.is_hades and "_hades" or "",
		handle_mat = N(adaptation.steel_rod),
		body_mat = N(adaptation.mese_crystal),
		_knife_wear = 600,
	}
end
if adaptation.steel_rod and adaptation.prism then
	knifes["prism"] = {
		desc = "Prism",
		handle_mat = N(adaptation.steel_rod),
		body_mat = N(adaptation.prism),
		_knife_wear = 200,
	}
elseif adaptation.steel_rod and adaptation.diamond then
	knifes["diamond"] = {
		desc = "Diamond",
		handle_mat = N(adaptation.steel_rod),
		body_mat = N(adaptation.diamond),
		_knife_wear = 200,
	}
end

for material, data in pairs(knifes) do
	tex_suffix = data.tex_suffix or ""
	core.register_tool("moretools:knife_"..material, {
			description = S(data.desc.." Knife"),
			inventory_image = "moretools_knife_"..material..tex_suffix..".png",
			--wield_image = "moretools_knife_"..material..tex_suffix..".png^[transformR270",
			sound = {breaks = "default_tool_breaks"},
			groups = {knife = 1},
			_knife_wear = data._knife_wear,

			on_use = knife_on_use,
		})
	core.register_craft({
			output = "moretools:knife_"..material,
			recipe = {
				{data.body_mat, ""},
				{"", data.handle_mat},
			},
		})
end