local S = moretools.translator

local adaptation = moretools.adaptation

local N = adaptation_lib.get_item_name

local inv_next_line_offset = adaptation.player_mod.next_line_offset_inv

moretools.hammer_actions = {
	--[[
	{
		action_on_use = function(action, user, pointed_thing)
			-- return wear factor (0..1) or nil if no action was performed
			return 0.5
		end,
		new_node = {name = "mod:new_node", param1 = 2, param2 = 17},
	},
	]]
}

local function hammer_on_use(itemstack, user, pointed_thing)
	return moretools.tool_on_use(itemstack, user, pointed_thing, moretools.hammer_actions, "_hammer_wear")
end

local hammers = {}

if adaptation.stick and adaptation.stone then
	hammers["stone"] = {
		desc = "Stone",
		handle_mat = adaptation.stick,
		body_mat = adaptation.stone,
		_hammer_wear = 3000,
	}
end
if adaptation.stick and adaptation.bronze_ingot then
	hammers["bronze"] = {
		desc = "Bronze",
		tex_suffix = adaptation.is_hades and "_hades" or "",
		handle_mat = adaptation.stick,
		body_mat = N(adaptation.bronze_ingot),
		_hammer_wear = 1500,
	}
end
if adaptation.stick and adaptation.steel_ingot then
	hammers["steel"] = {
		desc = "Iron",
		handle_mat = adaptation.stick,
		body_mat = N(adaptation.steel_ingot),
		_hammer_wear = 2000,
	}
end
if adaptation.steel_rod and adaptation.mese_crystal then
	hammers["mese"] = {
		desc = "Mese",
		tex_suffix = adaptation.is_hades and "_hades" or "",
		handle_mat = N(adaptation.steel_rod),
		body_mat = N(adaptation.mese_crystal),
		_hammer_wear = 600,
	}
end
if adaptation.steel_rod and adaptation.prism then
	hammers["prism"] = {
		desc = "Prism",
		handle_mat = N(adaptation.steel_rod),
		body_mat = N(adaptation.prism),
		_hammer_wear = 200,
	}
elseif adaptation.steel_rod and adaptation.diamond then
	hammers["diamond"] = {
		desc = "Diamond",
		handle_mat = N(adaptation.steel_rod),
		body_mat = N(adaptation.diamond),
		_hammer_wear = 200,
	}
end

for material, data in pairs(hammers) do
	tex_suffix = data.tex_suffix or ""
	core.register_tool("moretools:hammer_"..material, {
			description = S(data.desc.." hammer"),
			inventory_image = "moretools_hammer_"..material..tex_suffix..".png",
			--wield_image = "moretools_hammer_"..material..tex_suffix..".png^[transformR270",
			sound = {breaks = "default_tool_breaks"},
			groups = {hammer = 1},
			_hammer_wear = data._hammer_wear,

			on_use = hammer_on_use,
		})
	core.register_craft({
			output = "moretools:hammer_"..material,
			recipe = {
				{data.body_mat, data.handle_mat, data.body_mat},
				{"", data.handle_mat, ""},
			},
		})
end