
local S = palisade.translator

-- node box {x=0, y=0, z=0}
local palisade_wall_box = {
  type = "fixed",
  fixed = {
    {0.125,-0.5,0.0,0.3125,0.0,0.4375},
    {0.1875,0.0,0.0,0.375,0.5,0.4375},
    {-0.375,-0.5,0.0625,-0.1875,0.0,0.5},
    {0.0625,-0.5,0.0625,0.125,0.0,0.375},
    {0.3125,-0.5,0.0625,0.375,0.0,0.375},
    {-0.3125,0.0,0.0625,-0.125,0.5,0.5},
    {0.125,0.0,0.0625,0.1875,0.5,0.375},
    {0.375,0.0,0.0625,0.4375,0.5,0.375},
    {-0.4375,-0.5,0.125,-0.375,0.0,0.4375},
    {-0.1875,-0.5,0.125,-0.125,0.0,0.4375},
    {0.0,-0.5,0.125,0.0625,0.0,0.3125},
    {0.375,-0.5,0.125,0.4375,0.0,0.3125},
    {-0.375,0.0,0.125,-0.3125,0.5,0.4375},
    {-0.125,0.0,0.125,-0.0625,0.5,0.4375},
    {0.0625,0.0,0.125,0.125,0.5,0.3125},
    {0.4375,0.0,0.125,0.5,0.5,0.3125},
    {-0.5,-0.5,0.1875,-0.4375,0.0,0.375},
    {-0.125,-0.5,0.1875,-0.0625,0.0,0.375},
    {-0.4375,0.0,0.1875,-0.375,0.5,0.375},
    {-0.0625,0.0,0.1875,0.0,0.5,0.375},
  },
}
-- node box {x=0, y=1, z=0}
local palisade_wall_point_box = {
  type = "fixed",
  fixed = {
      {-0.3125,-0.5,0.0,-0.125,0.0625,0.4375},
      {-0.375,-0.5,0.0625,-0.3125,0.0625,0.375},
      {-0.125,-0.5,0.0625,-0.0625,0.0625,0.375},
      {0.125,-0.5,0.0625,0.3125,0.0625,0.5},
      {-0.3125,0.0625,0.0625,-0.125,0.1875,0.375},
      {-0.4375,-0.5,0.125,-0.375,0.0625,0.3125},
      {-0.0625,-0.5,0.125,0.0,0.0625,0.3125},
      {0.0625,-0.5,0.125,0.125,0.0625,0.4375},
      {0.3125,-0.5,0.125,0.375,0.0625,0.4375},
      {-0.375,0.0625,0.125,-0.3125,0.1875,0.3125},
      {-0.125,0.0625,0.125,-0.0625,0.1875,0.3125},
      {0.125,0.0625,0.125,0.3125,0.1875,0.4375},
      {-0.25,0.1875,0.125,-0.1875,0.3125,0.3125},
      {0.0,-0.5,0.1875,0.0625,0.0625,0.375},
      {0.375,-0.5,0.1875,0.4375,0.0625,0.375},
      {0.0625,0.0625,0.1875,0.125,0.1875,0.375},
      {0.3125,0.0625,0.1875,0.375,0.1875,0.375},
      {-0.3125,0.1875,0.1875,-0.25,0.3125,0.25},
      {-0.1875,0.1875,0.1875,-0.125,0.3125,0.25},
      {0.1875,0.1875,0.1875,0.25,0.3125,0.375},
      {-0.25,0.3125,0.1875,-0.1875,0.4375,0.25},
      {0.125,0.1875,0.25,0.1875,0.3125,0.3125},
      {0.25,0.1875,0.25,0.3125,0.3125,0.3125},
      {0.1875,0.3125,0.25,0.25,0.4375,0.3125},
    }
  }
-- node box {x=0, y=0, z=0}
local palisade_corner_inner_box = {
    type = "fixed",
    fixed = {
      {-0.375,-0.5,0.0625,-0.1875,0.0,0.5},
      {-0.3125,0.0,0.0625,-0.125,0.5,0.5},
      {-0.4375,-0.5,0.125,-0.375,0.0,0.4375},
      {-0.1875,-0.5,0.125,-0.125,0.0,0.4375},
      {-0.375,0.0,0.125,-0.3125,0.5,0.4375},
      {-0.125,0.0,0.125,-0.0625,0.5,0.4375},
      {-0.5,-0.5,0.1875,-0.4375,0.0,0.375},
      {-0.125,-0.5,0.1875,-0.0625,0.0,0.375},
      {-0.4375,0.0,0.1875,-0.375,0.5,0.375},
      {-0.0625,0.0,0.1875,0.0,0.5,0.375},
    },
  }
-- node box {x=0, y=1, z=0}
local palisade_corner_inner_point_box = {
    type = "fixed",
    fixed = {
      {-0.3125,-0.5,0.0,-0.125,0.0625,0.4375},
      {-0.375,-0.5,0.0625,-0.3125,0.0625,0.375},
      {-0.125,-0.5,0.0625,-0.0625,0.0625,0.375},
      {-0.3125,0.0625,0.0625,-0.125,0.1875,0.375},
      {-0.4375,-0.5,0.125,-0.375,0.0625,0.3125},
      {-0.0625,-0.5,0.125,0.0,0.0625,0.3125},
      {-0.375,0.0625,0.125,-0.3125,0.1875,0.3125},
      {-0.125,0.0625,0.125,-0.0625,0.1875,0.3125},
      {-0.25,0.1875,0.125,-0.1875,0.3125,0.3125},
      {-0.3125,0.1875,0.1875,-0.25,0.3125,0.25},
      {-0.1875,0.1875,0.1875,-0.125,0.3125,0.25},
      {-0.25,0.3125,0.1875,-0.1875,0.4375,0.25},
    },
  }
-- node box {x=0, y=0, z=0}
local palisade_corner_outer_box = {
    type = "fixed",
    fixed = {
      {-0.375,0.0,-0.5,-0.1875,0.5,-0.0625},
      {-0.3125,-0.5,-0.4375,-0.125,0.0,0.0},
      {-0.4375,0.0,-0.4375,-0.375,0.5,-0.125},
      {-0.1875,0.0,-0.4375,-0.125,0.5,-0.125},
      {-0.375,-0.5,-0.375,-0.3125,0.0,-0.0625},
      {-0.125,-0.5,-0.375,-0.0625,0.5,-0.1875},
      {-0.5,0.0,-0.375,-0.4375,0.5,-0.1875},
      {-0.4375,-0.5,-0.3125,-0.375,0.0,-0.125},
      {-0.0625,-0.5,-0.3125,0.0,0.0,-0.125},
      {-0.125,-0.5,-0.1875,-0.0625,0.0,-0.0625},
      {0.125,-0.5,0.0,0.3125,0.0,0.4375},
      {0.1875,0.0,0.0,0.375,0.5,0.4375},
      {-0.375,-0.5,0.0625,-0.1875,0.0,0.5},
      {0.0625,-0.5,0.0625,0.125,0.0,0.375},
      {0.3125,-0.5,0.0625,0.375,0.0,0.375},
      {-0.3125,0.0,0.0625,-0.125,0.5,0.5},
      {0.125,0.0,0.0625,0.1875,0.5,0.375},
      {0.375,0.0,0.0625,0.4375,0.5,0.375},
      {-0.4375,-0.5,0.125,-0.375,0.0,0.4375},
      {-0.1875,-0.5,0.125,-0.125,0.0,0.4375},
      {0.0,-0.5,0.125,0.0625,0.0,0.3125},
      {0.375,-0.5,0.125,0.4375,0.0,0.3125},
      {-0.375,0.0,0.125,-0.3125,0.5,0.4375},
      {-0.125,0.0,0.125,-0.0625,0.5,0.4375},
      {0.0625,0.0,0.125,0.125,0.5,0.3125},
      {0.4375,0.0,0.125,0.5,0.5,0.3125},
      {-0.5,-0.5,0.1875,-0.4375,0.0,0.375},
      {-0.125,-0.5,0.1875,-0.0625,0.0,0.375},
      {-0.4375,0.0,0.1875,-0.375,0.5,0.375},
      {-0.0625,0.0,0.1875,0.0,0.5,0.375},
    },
  }
-- node box {x=0, y=1, z=0}
local palisade_corner_outer_point_box = {
    type = "fixed",
    fixed = {
      {-0.375,-0.5,-0.4375,-0.1875,0.0625,0.0},
      {-0.4375,-0.5,-0.375,-0.375,0.0625,-0.0625},
      {-0.1875,-0.5,-0.375,-0.125,0.0625,-0.0625},
      {-0.375,0.0625,-0.375,-0.1875,0.1875,-0.0625},
      {-0.5,-0.5,-0.3125,-0.4375,0.0625,-0.125},
      {-0.125,-0.5,-0.3125,-0.0625,0.0625,-0.125},
      {-0.4375,0.0625,-0.3125,-0.375,0.1875,-0.125},
      {-0.1875,0.0625,-0.3125,-0.125,0.1875,-0.125},
      {-0.3125,0.1875,-0.3125,-0.25,0.3125,-0.125},
      {-0.375,0.1875,-0.25,-0.3125,0.3125,-0.1875},
      {-0.25,0.1875,-0.25,-0.1875,0.3125,-0.1875},
      {-0.3125,0.3125,-0.25,-0.25,0.4375,-0.1875},
      {-0.3125,-0.5,0.0,-0.125,0.0625,0.4375},
      {-0.375,-0.5,0.0625,-0.3125,0.0625,0.375},
      {-0.125,-0.5,0.0625,-0.0625,0.0625,0.375},
      {0.125,-0.5,0.0625,0.3125,0.0625,0.5},
      {-0.3125,0.0625,0.0625,-0.125,0.1875,0.375},
      {-0.4375,-0.5,0.125,-0.375,0.0625,0.3125},
      {-0.0625,-0.5,0.125,0.0,0.0625,0.3125},
      {0.0625,-0.5,0.125,0.125,0.0625,0.4375},
      {0.3125,-0.5,0.125,0.375,0.0625,0.4375},
      {-0.375,0.0625,0.125,-0.3125,0.1875,0.3125},
      {-0.125,0.0625,0.125,-0.0625,0.1875,0.3125},
      {0.125,0.0625,0.125,0.3125,0.1875,0.4375},
      {-0.25,0.1875,0.125,-0.1875,0.3125,0.3125},
      {0.0,-0.5,0.1875,0.0625,0.0625,0.375},
      {0.375,-0.5,0.1875,0.4375,0.0625,0.375},
      {0.0625,0.0625,0.1875,0.125,0.1875,0.375},
      {0.3125,0.0625,0.1875,0.375,0.1875,0.375},
      {-0.3125,0.1875,0.1875,-0.25,0.3125,0.25},
      {-0.1875,0.1875,0.1875,-0.125,0.3125,0.25},
      {0.1875,0.1875,0.1875,0.25,0.3125,0.375},
      {-0.25,0.3125,0.1875,-0.1875,0.4375,0.25},
      {0.125,0.1875,0.25,0.1875,0.3125,0.3125},
      {0.25,0.1875,0.25,0.3125,0.3125,0.3125},
      {0.1875,0.3125,0.25,0.25,0.4375,0.3125},
    },
  }
-- node box {x=0, y=0, z=0}
local palisade_crossing_box = {
    type = "fixed",
    fixed = {
      {0.1875,-0.5,-0.5,0.375,0.0,-0.0625},
      {-0.375,0.0,-0.5,-0.1875,0.5,-0.0625},
      {0.125,0.0,-0.5,0.3125,0.5,-0.0625},
      {-0.3125,-0.5,-0.4375,-0.125,0.0,0.0},
      {0.125,-0.5,-0.4375,0.1875,0.0,-0.125},
      {0.375,-0.5,-0.4375,0.4375,0.0,-0.125},
      {-0.4375,0.0,-0.4375,-0.375,0.5,-0.125},
      {-0.1875,0.0,-0.4375,-0.125,0.5,-0.125},
      {0.0625,0.0,-0.4375,0.125,0.5,-0.125},
      {0.3125,0.0,-0.4375,0.375,0.5,-0.125},
      {-0.375,-0.5,-0.375,-0.3125,0.0,-0.0625},
      {-0.125,-0.5,-0.375,-0.0625,0.5,-0.1875},
      {0.0625,-0.5,-0.375,0.125,0.0,-0.1875},
      {0.4375,-0.5,-0.375,0.5,0.0,-0.1875},
      {-0.5,0.0,-0.375,-0.4375,0.5,-0.1875},
      {0.0,0.0,-0.375,0.0625,0.5,-0.1875},
      {0.375,0.0,-0.375,0.4375,0.5,-0.1875},
      {-0.4375,-0.5,-0.3125,-0.375,0.0,-0.125},
      {-0.0625,-0.5,-0.3125,0.0,0.0,-0.125},
      {-0.125,-0.5,-0.1875,-0.0625,0.0,-0.0625},
      {0.125,-0.5,0.0,0.3125,0.0,0.4375},
      {0.1875,0.0,0.0,0.375,0.5,0.4375},
      {-0.375,-0.5,0.0625,-0.1875,0.0,0.5},
      {0.0625,-0.5,0.0625,0.125,0.0,0.375},
      {0.3125,-0.5,0.0625,0.375,0.0,0.375},
      {-0.3125,0.0,0.0625,-0.125,0.5,0.5},
      {0.125,0.0,0.0625,0.1875,0.5,0.375},
      {0.375,0.0,0.0625,0.4375,0.5,0.375},
      {-0.4375,-0.5,0.125,-0.375,0.0,0.4375},
      {-0.1875,-0.5,0.125,-0.125,0.0,0.4375},
      {0.0,-0.5,0.125,0.0625,0.0,0.3125},
      {0.375,-0.5,0.125,0.4375,0.0,0.3125},
      {-0.375,0.0,0.125,-0.3125,0.5,0.4375},
      {-0.125,0.0,0.125,-0.0625,0.5,0.4375},
      {0.0625,0.0,0.125,0.125,0.5,0.3125},
      {0.4375,0.0,0.125,0.5,0.5,0.3125},
      {-0.5,-0.5,0.1875,-0.4375,0.0,0.375},
      {-0.125,-0.5,0.1875,-0.0625,0.0,0.375},
      {-0.4375,0.0,0.1875,-0.375,0.5,0.375},
      {-0.0625,0.0,0.1875,0.0,0.5,0.375},
    },
  }
-- node box {x=0, y=1, z=0}
local palisade_crossing_point_box = {
    type = "fixed",
    fixed = {
      {-0.375,-0.5,-0.4375,-0.1875,0.0625,0.0},
      {0.125,-0.5,-0.4375,0.3125,0.0625,0.0},
      {-0.4375,-0.5,-0.375,-0.375,0.0625,-0.0625},
      {-0.1875,-0.5,-0.375,-0.125,0.0625,-0.0625},
      {0.0625,-0.5,-0.375,0.125,0.0625,-0.0625},
      {0.3125,-0.5,-0.375,0.375,0.0625,-0.0625},
      {-0.375,0.0625,-0.375,-0.1875,0.1875,-0.0625},
      {0.125,0.0625,-0.375,0.3125,0.1875,-0.0625},
      {-0.5,-0.5,-0.3125,-0.4375,0.0625,-0.125},
      {-0.125,-0.5,-0.3125,-0.0625,0.0625,-0.125},
      {0.0,-0.5,-0.3125,0.0625,0.0625,-0.125},
      {0.375,-0.5,-0.3125,0.4375,0.0625,-0.125},
      {-0.4375,0.0625,-0.3125,-0.375,0.1875,-0.125},
      {-0.1875,0.0625,-0.3125,-0.125,0.1875,-0.125},
      {0.0625,0.0625,-0.3125,0.125,0.1875,-0.125},
      {0.3125,0.0625,-0.3125,0.375,0.1875,-0.125},
      {-0.3125,0.1875,-0.3125,-0.25,0.3125,-0.125},
      {0.1875,0.1875,-0.3125,0.25,0.3125,-0.125},
      {-0.375,0.1875,-0.25,-0.3125,0.3125,-0.1875},
      {-0.25,0.1875,-0.25,-0.1875,0.3125,-0.1875},
      {0.125,0.1875,-0.25,0.1875,0.3125,-0.1875},
      {0.25,0.1875,-0.25,0.3125,0.3125,-0.1875},
      {-0.3125,0.3125,-0.25,-0.25,0.4375,-0.1875},
      {0.1875,0.3125,-0.25,0.25,0.4375,-0.1875},
      {-0.3125,-0.5,0.0,-0.125,0.0625,0.4375},
      {-0.375,-0.5,0.0625,-0.3125,0.0625,0.375},
      {-0.125,-0.5,0.0625,-0.0625,0.0625,0.375},
      {0.125,-0.5,0.0625,0.3125,0.0625,0.5},
      {-0.3125,0.0625,0.0625,-0.125,0.1875,0.375},
      {-0.4375,-0.5,0.125,-0.375,0.0625,0.3125},
      {-0.0625,-0.5,0.125,0.0,0.0625,0.3125},
      {0.0625,-0.5,0.125,0.125,0.0625,0.4375},
      {0.3125,-0.5,0.125,0.375,0.0625,0.4375},
      {-0.375,0.0625,0.125,-0.3125,0.1875,0.3125},
      {-0.125,0.0625,0.125,-0.0625,0.1875,0.3125},
      {0.125,0.0625,0.125,0.3125,0.1875,0.4375},
      {-0.25,0.1875,0.125,-0.1875,0.3125,0.3125},
      {0.0,-0.5,0.1875,0.0625,0.0625,0.375},
      {0.375,-0.5,0.1875,0.4375,0.0625,0.375},
      {0.0625,0.0625,0.1875,0.125,0.1875,0.375},
      {0.3125,0.0625,0.1875,0.375,0.1875,0.375},
      {-0.3125,0.1875,0.1875,-0.25,0.3125,0.25},
      {-0.1875,0.1875,0.1875,-0.125,0.3125,0.25},
      {0.1875,0.1875,0.1875,0.25,0.3125,0.375},
      {-0.25,0.3125,0.1875,-0.1875,0.4375,0.25},
      {0.125,0.1875,0.25,0.1875,0.3125,0.3125},
      {0.25,0.1875,0.25,0.3125,0.3125,0.3125},
      {0.1875,0.3125,0.25,0.25,0.4375,0.3125},
    },
  }
-- node box {x=0, y=1, z=0}
local palisade_post_box = {
    type = "fixed",
    fixed = {
      {-0.1875,-0.5,-0.5,0.25,-0.3125,-0.3125},
      {-0.125,-0.3125,-0.5,0.1875,-0.1875,0.0},
      {-0.0625,-0.1875,-0.5,0.125,-0.0625,0.25},
      {-0.1875,-0.3125,-0.4375,-0.125,-0.25,-0.125},
      {0.1875,-0.3125,-0.4375,0.25,-0.25,-0.125},
      {-0.125,-0.1875,-0.4375,-0.0625,-0.125,0.125},
      {0.125,-0.1875,-0.4375,0.1875,-0.125,0.125},
      {-0.0625,-0.0625,-0.4375,0.125,0.0,0.375},
      {-0.1875,-0.25,-0.375,-0.125,-0.1875,-0.0625},
      {0.1875,-0.25,-0.375,0.25,-0.1875,-0.0625},
      {-0.125,-0.125,-0.375,-0.0625,-0.0625,0.1875},
      {0.125,-0.125,-0.375,0.1875,-0.0625,0.1875},
      {-0.0625,0.0,-0.375,0.125,0.0625,0.4375},
      {-0.125,-0.5,-0.3125,0.1875,-0.3125,-0.1875},
      {-0.1875,-0.4375,-0.3125,-0.125,-0.3125,-0.25},
      {0.1875,-0.4375,-0.3125,0.25,-0.3125,-0.25},
      {-0.1875,-0.1875,-0.3125,-0.125,-0.125,0.0},
      {0.1875,-0.1875,-0.3125,0.25,-0.125,0.0},
      {-0.125,-0.0625,-0.3125,-0.0625,0.0,0.25},
      {0.125,-0.0625,-0.3125,0.1875,0.0,0.25},
      {-0.0625,0.0625,-0.3125,0.125,0.125,0.5},
      {-0.1875,-0.375,-0.25,-0.125,-0.3125,-0.1875},
      {0.1875,-0.375,-0.25,0.25,-0.3125,-0.1875},
      {-0.1875,-0.125,-0.25,-0.125,-0.0625,0.0625},
      {0.1875,-0.125,-0.25,0.25,-0.0625,0.0625},
      {-0.125,0.0,-0.25,-0.0625,0.0625,0.3125},
      {0.125,0.0,-0.25,0.1875,0.0625,0.3125},
      {-0.0625,0.125,-0.25,0.125,0.1875,0.5},
      {-0.0625,-0.5,-0.1875,0.125,-0.3125,-0.0625},
      {-0.125,-0.4375,-0.1875,-0.0625,-0.3125,-0.125},
      {0.125,-0.4375,-0.1875,0.1875,-0.3125,-0.125},
      {-0.1875,-0.0625,-0.1875,-0.125,0.0,0.125},
      {0.1875,-0.0625,-0.1875,0.25,0.0,0.125},
      {-0.125,0.0625,-0.1875,-0.0625,0.125,0.375},
      {0.125,0.0625,-0.1875,0.1875,0.125,0.375},
      {-0.0625,0.1875,-0.1875,0.125,0.25,0.5},
      {-0.125,-0.375,-0.125,-0.0625,-0.3125,-0.0625},
      {0.125,-0.375,-0.125,0.1875,-0.3125,-0.0625},
      {-0.1875,0.0,-0.125,-0.125,0.0625,0.1875},
      {0.1875,0.0,-0.125,0.25,0.0625,0.1875},
      {-0.125,0.125,-0.125,-0.0625,0.1875,0.4375},
      {0.125,0.125,-0.125,0.1875,0.1875,0.4375},
      {-0.0625,0.25,-0.125,0.125,0.3125,0.5},
      {-0.0625,-0.4375,-0.0625,0.125,-0.3125,0.0},
      {-0.1875,0.0625,-0.0625,-0.125,0.125,0.25},
      {0.1875,0.0625,-0.0625,0.25,0.125,0.25},
      {-0.125,0.1875,-0.0625,-0.0625,0.25,0.5},
      {0.125,0.1875,-0.0625,0.1875,0.25,0.5},
      {-0.0625,0.3125,-0.0625,0.125,0.375,0.5},
      {-0.0625,-0.375,0.0,0.125,-0.1875,0.0625},
      {-0.125,-0.25,0.0,-0.0625,-0.1875,0.0625},
      {0.125,-0.25,0.0,0.1875,-0.1875,0.0625},
      {-0.1875,0.125,0.0,-0.125,0.1875,0.3125},
      {0.1875,0.125,0.0,0.25,0.1875,0.3125},
      {-0.125,0.25,0.0,-0.0625,0.3125,0.5},
      {0.125,0.25,0.0,0.1875,0.3125,0.5},
      {-0.0625,0.375,0.0,0.125,0.4375,0.5},
      {-0.0625,-0.3125,0.0625,0.125,-0.1875,0.125},
      {-0.1875,0.1875,0.0625,-0.125,0.25,0.375},
      {0.1875,0.1875,0.0625,0.25,0.25,0.375},
      {-0.125,0.3125,0.0625,-0.0625,0.375,0.5},
      {0.125,0.3125,0.0625,0.1875,0.375,0.5},
      {-0.0625,0.4375,0.0625,0.125,0.5,0.5},
      {-0.0625,-0.25,0.125,0.125,-0.1875,0.1875},
      {-0.1875,0.25,0.125,-0.125,0.3125,0.4375},
      {0.1875,0.25,0.125,0.25,0.3125,0.4375},
      {-0.125,0.375,0.125,-0.0625,0.4375,0.5},
      {0.125,0.375,0.125,0.1875,0.4375,0.5},
      {-0.1875,0.3125,0.1875,-0.125,0.375,0.5},
      {0.1875,0.3125,0.1875,0.25,0.375,0.5},
      {-0.125,0.4375,0.1875,-0.0625,0.5,0.5},
      {0.125,0.4375,0.1875,0.1875,0.5,0.5},
      {-0.0625,-0.125,0.25,0.125,-0.0625,0.3125},
      {-0.1875,0.375,0.25,-0.125,0.4375,0.5},
      {0.1875,0.375,0.25,0.25,0.4375,0.5},
      {-0.1875,0.4375,0.3125,-0.125,0.5,0.5},
      {0.1875,0.4375,0.3125,0.25,0.5,0.5},
    },
  }
-- node box {x=0, y=1, z=0}
local palisade_post_point_box = {
    type = "fixed",
    fixed = {
      {-0.1875,-0.5,-0.5,0.25,-0.3125,-0.3125},
      {-0.125,-0.3125,-0.5,0.1875,-0.1875,0.0},
      {-0.0625,-0.1875,-0.5,0.125,-0.0625,0.25},
      {-0.1875,-0.3125,-0.4375,-0.125,-0.25,-0.125},
      {0.1875,-0.3125,-0.4375,0.25,-0.25,-0.125},
      {-0.125,-0.1875,-0.4375,-0.0625,-0.125,0.125},
      {0.125,-0.1875,-0.4375,0.1875,-0.125,0.125},
      {-0.0625,-0.0625,-0.4375,0.125,0.0,0.3125},
      {-0.1875,-0.25,-0.375,-0.125,-0.1875,-0.0625},
      {0.1875,-0.25,-0.375,0.25,-0.1875,-0.0625},
      {-0.125,-0.125,-0.375,-0.0625,-0.0625,0.1875},
      {0.125,-0.125,-0.375,0.1875,-0.0625,0.1875},
      {-0.0625,0.0,-0.375,0.125,0.0625,0.3125},
      {-0.125,-0.5,-0.3125,0.1875,-0.3125,-0.1875},
      {-0.1875,-0.4375,-0.3125,-0.125,-0.3125,-0.25},
      {0.1875,-0.4375,-0.3125,0.25,-0.3125,-0.25},
      {-0.1875,-0.1875,-0.3125,-0.125,-0.125,0.0},
      {0.1875,-0.1875,-0.3125,0.25,-0.125,0.0},
      {-0.125,-0.0625,-0.3125,-0.0625,0.0,0.25},
      {0.125,-0.0625,-0.3125,0.1875,0.0,0.25},
      {-0.0625,0.0625,-0.3125,0.125,0.125,0.3125},
      {-0.1875,-0.375,-0.25,-0.125,-0.3125,-0.1875},
      {0.1875,-0.375,-0.25,0.25,-0.3125,-0.1875},
      {-0.1875,-0.125,-0.25,-0.125,-0.0625,0.0625},
      {0.1875,-0.125,-0.25,0.25,-0.0625,0.0625},
      {-0.125,0.0,-0.25,-0.0625,0.0625,0.25},
      {0.125,0.0,-0.25,0.1875,0.0625,0.25},
      {-0.0625,0.125,-0.25,0.125,0.1875,0.3125},
      {-0.0625,-0.5,-0.1875,0.125,-0.3125,-0.0625},
      {-0.125,-0.4375,-0.1875,-0.0625,-0.3125,-0.125},
      {0.125,-0.4375,-0.1875,0.1875,-0.3125,-0.125},
      {-0.1875,-0.0625,-0.1875,-0.125,0.0,0.125},
      {0.1875,-0.0625,-0.1875,0.25,0.0,0.125},
      {-0.125,0.0625,-0.1875,-0.0625,0.125,0.25},
      {0.125,0.0625,-0.1875,0.1875,0.125,0.25},
      {-0.0625,0.1875,-0.1875,0.125,0.25,0.375},
      {-0.125,-0.375,-0.125,-0.0625,-0.3125,-0.0625},
      {0.125,-0.375,-0.125,0.1875,-0.3125,-0.0625},
      {-0.1875,0.0,-0.125,-0.125,0.0625,0.1875},
      {0.1875,0.0,-0.125,0.25,0.0625,0.1875},
      {-0.125,0.125,-0.125,-0.0625,0.1875,0.25},
      {0.125,0.125,-0.125,0.1875,0.1875,0.25},
      {-0.0625,0.25,-0.125,0.125,0.3125,0.375},
      {-0.0625,-0.4375,-0.0625,0.125,-0.3125,0.0},
      {-0.1875,0.0625,-0.0625,-0.125,0.125,0.1875},
      {0.1875,0.0625,-0.0625,0.25,0.125,0.1875},
      {-0.125,0.1875,-0.0625,-0.0625,0.25,0.25},
      {0.125,0.1875,-0.0625,0.1875,0.25,0.25},
      {-0.0625,-0.375,0.0,0.125,-0.1875,0.0625},
      {-0.125,-0.25,0.0,-0.0625,-0.1875,0.0625},
      {0.125,-0.25,0.0,0.1875,-0.1875,0.0625},
      {-0.1875,0.125,0.0,-0.125,0.1875,0.1875},
      {0.1875,0.125,0.0,0.25,0.1875,0.1875},
      {-0.0625,-0.3125,0.0625,0.125,-0.1875,0.125},
      {-0.0625,-0.25,0.125,0.125,-0.1875,0.1875},
      {-0.0625,0.3125,0.1875,0.125,0.375,0.375},
      {-0.0625,-0.125,0.25,0.125,-0.0625,0.3125},
      {-0.125,0.25,0.25,-0.0625,0.3125,0.3125},
      {0.125,0.25,0.25,0.1875,0.3125,0.3125},
      {0.0,0.375,0.3125,0.0625,0.4375,0.4375},
      {0.0,0.3125,0.375,0.0625,0.375,0.4375},
      {0.0,0.4375,0.4375,0.0625,0.5,0.5},
    },
  }

local function after_place_palisade(pos, placer, itemstack, pointed_thing)
  local node = minetest.get_node(pos)
  
  local under = minetest.get_node(pointed_thing.under)
  if minetest.get_item_group(under.name, "palisade_wall")>0 and (under.param2~=node.param2) then
    node.param2 = under.param2
    minetest.swap_node(pos, node)
  end
end

function palisade.register_palisade(key, def)
  local tree = minetest.registered_nodes[def.tree_node]
  if not tree then
    error("[palisade] Node "..def.tree_node.." isn't defined.")
  end
  if (def.tiles==nil) then
    def.tiles = {tree.tiles[3], tree.tiles[1], tree.tiles[2]}
  end
  local groups = table.copy(tree.groups)
  groups.palisade = 1
  groups.palisade_wall = 1
  minetest.register_node(":palisade:"..key.."_palisade_wall", {
      description = def.desc.." "..S("Palisade Wall"),
      paramtype = "light",
      paramtype2 = "facedir",
      drawtype = "mesh",
      mesh = "palisade_palisade_wall.obj",
      tiles = table.copy(def.tiles),
      selection_box = palisade_wall_box,
      collision_box = palisade_wall_box,
      groups = table.copy(groups),
      sounds = table.copy(tree.sounds),
      after_place_node = after_place_palisade,
    })
  minetest.register_node(":palisade:"..key.."_palisade_wall_point", {
      description = def.desc.." "..S("Palisade Wall Point"),
      paramtype = "light",
      paramtype2 = "facedir",
      drawtype = "mesh",
      mesh = "palisade_palisade_wall_point.obj",
      tiles = table.copy(def.tiles),
      selection_box = palisade_wall_point_box,
      collision_box = palisade_wall_point_box,
      groups = table.copy(groups),
      sounds = table.copy(tree.sounds),
      after_place_node = after_place_palisade,
    })
  minetest.register_node(":palisade:"..key.."_palisade_corner_inner", {
      description = def.desc.." "..S("Palisade Inner Corner"),
      paramtype = "light",
      paramtype2 = "facedir",
      drawtype = "mesh",
      mesh = "palisade_palisade_corner_inner.obj",
      tiles = table.copy(def.tiles),
      selection_box = palisade_corner_inner_box,
      collision_box = palisade_corner_inner_box,
      groups = table.copy(groups),
      sounds = table.copy(tree.sounds),
      after_place_node = after_place_palisade,
    })
  minetest.register_node(":palisade:"..key.."_palisade_corner_inner_point", {
      description = def.desc.." "..S("Palisade Inner Corner Point"),
      paramtype = "light",
      paramtype2 = "facedir",
      drawtype = "mesh",
      mesh = "palisade_palisade_corner_inner_point.obj",
      tiles = table.copy(def.tiles),
      selection_box = palisade_corner_inner_point_box,
      collision_box = palisade_corner_inner_point_box,
      groups = table.copy(groups),
      sounds = table.copy(tree.sounds),
      after_place_node = after_place_palisade,
    })
  minetest.register_node(":palisade:"..key.."_palisade_corner_outer", {
      description = def.desc.." "..S("Palisade Outer Corner"),
      paramtype = "light",
      paramtype2 = "facedir",
      drawtype = "mesh",
      mesh = "palisade_palisade_corner_outer.obj",
      tiles = table.copy(def.tiles),
      selection_box = palisade_corner_outer_box,
      collision_box = palisade_corner_outer_box,
      groups = table.copy(groups),
      sounds = table.copy(tree.sounds),
      after_place_node = after_place_palisade,
    })
  minetest.register_node(":palisade:"..key.."_palisade_corner_outer_point", {
      description = def.desc.." "..S("Palisade Outer Corner Point"),
      paramtype = "light",
      paramtype2 = "facedir",
      drawtype = "mesh",
      mesh = "palisade_palisade_corner_outer_point.obj",
      tiles = table.copy(def.tiles),
      selection_box = palisade_corner_outer_point_box,
      collision_box = palisade_corner_outer_point_box,
      groups = table.copy(groups),
      sounds = table.copy(tree.sounds),
      after_place_node = after_place_palisade,
    })
  minetest.register_node(":palisade:"..key.."_palisade_crossing", {
      description = def.desc.." "..S("Palisade Crossing"),
      paramtype = "light",
      paramtype2 = "facedir",
      drawtype = "mesh",
      mesh = "palisade_palisade_crossing.obj",
      tiles = table.copy(def.tiles),
      selection_box = palisade_crossing_box,
      collision_box = palisade_crossing_box,
      groups = table.copy(groups),
      sounds = table.copy(tree.sounds),
      after_place_node = after_place_palisade,
    })
  minetest.register_node(":palisade:"..key.."_palisade_crossing_point", {
      description = def.desc.." "..S("Palisade Crossing Point"),
      paramtype = "light",
      paramtype2 = "facedir",
      drawtype = "mesh",
      mesh = "palisade_palisade_crossing_point.obj",
      tiles = table.copy(def.tiles),
      selection_box = palisade_crossing_point_box,
      collision_box = palisade_crossing_point_box,
      groups = table.copy(groups),
      sounds = table.copy(tree.sounds),
      after_place_node = after_place_palisade,
    })
  groups.palisade_wall = nil
  groups.palisade_post = 1
  minetest.register_node(":palisade:"..key.."_palisade_post", {
      description = def.desc.." "..S("Palisade Post"),
      paramtype = "light",
      paramtype2 = "facedir",
      drawtype = "mesh",
      mesh = "palisade_palisade_post.obj",
      tiles = table.copy(def.tiles),
      selection_box = palisade_post_box,
      collision_box = palisade_post_box,
      groups = table.copy(groups),
      sounds = table.copy(tree.sounds),
    })
  minetest.register_node(":palisade:"..key.."_palisade_post_point", {
      description = def.desc.." "..S("Palisade Post Point"),
      paramtype = "light",
      paramtype2 = "facedir",
      drawtype = "mesh",
      mesh = "palisade_palisade_post_point.obj",
      tiles = table.copy(def.tiles),
      selection_box = palisade_post_point_box,
      collision_box = palisade_post_point_box,
      groups = table.copy(groups),
      sounds = table.copy(tree.sounds),
    })
  
  minetest.register_craft({
      output = "palisade:"..key.."_palisade_corner_inner 2",
      recipe = {
        {def.tree_node},
        {def.tree_node},
      },
    })
  minetest.register_craft({
      type = "shapeless",
      output = "palisade:"..key.."_palisade_corner_inner_point",
      recipe = {
        "palisade:"..key.."_palisade_corner_inner"
      },
    })
  minetest.register_craft({
      output = "palisade:"..key.."_palisade_wall",
      recipe = {
        {"palisade:"..key.."_palisade_corner_inner", "palisade:"..key.."_palisade_corner_inner"},
      },
    })
  minetest.register_craft({
      type = "shapeless",
      output = "palisade:"..key.."_palisade_corner_inner 2",
      recipe = {
        "palisade:"..key.."_palisade_wall"
      },
    })
  minetest.register_craft({
      output = "palisade:"..key.."_palisade_wall_point",
      recipe = {
        {"palisade:"..key.."_palisade_corner_inner_point", "palisade:"..key.."_palisade_corner_inner_point"},
      },
    })
  minetest.register_craft({
      type = "shapeless",
      output = "palisade:"..key.."_palisade_corner_inner_point 2",
      recipe = {
        "palisade:"..key.."_palisade_wall_point"
      },
    })
  minetest.register_craft({
      output = "palisade:"..key.."_palisade_corner_outer",
      recipe = {
        {"palisade:"..key.."_palisade_corner_inner", ""},
        {"palisade:"..key.."_palisade_corner_inner", "palisade:"..key.."_palisade_corner_inner"},
      },
    })
  minetest.register_craft({
      type = "shapeless",
      output = "palisade:"..key.."_palisade_corner_inner 3",
      recipe = {
        "palisade:"..key.."_palisade_corner_outer"
      },
    })
  minetest.register_craft({
      output = "palisade:"..key.."_palisade_corner_outer_point",
      recipe = {
        {"palisade:"..key.."_palisade_corner_inner_point", ""},
        {"palisade:"..key.."_palisade_corner_inner_point", "palisade:"..key.."_palisade_corner_inner_point"},
      },
    })
  minetest.register_craft({
      type = "shapeless",
      output = "palisade:"..key.."_palisade_corner_inner_point 3",
      recipe = {
        "palisade:"..key.."_palisade_corner_outer_point"
      },
    })
  minetest.register_craft({
      output = "palisade:"..key.."_palisade_crossing",
      recipe = {
        {"palisade:"..key.."_palisade_corner_inner", "palisade:"..key.."_palisade_corner_inner"},
        {"palisade:"..key.."_palisade_corner_inner", "palisade:"..key.."_palisade_corner_inner"},
      },
    })
  minetest.register_craft({
      type = "shapeless",
      output = "palisade:"..key.."_palisade_corner_inner 4",
      recipe = {
        "palisade:"..key.."_palisade_crossing"
      },
    })
  minetest.register_craft({
      output = "palisade:"..key.."_palisade_crossing_point",
      recipe = {
        {"palisade:"..key.."_palisade_corner_inner_point", "palisade:"..key.."_palisade_corner_inner_point"},
        {"palisade:"..key.."_palisade_corner_inner_point", "palisade:"..key.."_palisade_corner_inner_point"},
      },
    })
  minetest.register_craft({
      type = "shapeless",
      output = "palisade:"..key.."_palisade_corner_inner_point 4",
      recipe = {
        "palisade:"..key.."_palisade_crossing_point"
      },
    })
  minetest.register_craft({
      output = "palisade:"..key.."_palisade_post 2",
      recipe = {
        {"", "palisade:"..key.."_palisade_corner_inner"},
        {"palisade:"..key.."_palisade_corner_inner", ""},
      },
    })
  minetest.register_craft({
      type = "shapeless",
      output = "palisade:"..key.."_palisade_corner_inner",
      recipe = {
        "palisade:"..key.."_palisade_post"
      },
    })
  minetest.register_craft({
      output = "palisade:"..key.."_palisade_post_point 2",
      recipe = {
        {"", "palisade:"..key.."_palisade_corner_inner_point"},
        {"palisade:"..key.."_palisade_corner_inner_point", ""},
      },
    })
  minetest.register_craft({
      type = "shapeless",
      output = "palisade:"..key.."_palisade_corner_inner_point",
      recipe = {
        "palisade:"..key.."_palisade_post_point"
      },
    })
end

for key,tree in pairs(palisade.trees) do
  palisade.register_palisade(key, tree)
end

