# Luanti mod: `players_effects`

This mod add functions for easier using of player based effects.

## Available Effects

### Basic Player Attribute Effects

#### `player:speed`
- Modifies player movement speed
- Base value: 1.0 (normal speed)
- Supports integration with:
  - `player_monoids` (if available)
  - `pova` mod (if available)
  - Fallback to vanilla physics override

#### `player:jump`
- Modifies player jump height
- Base value: 1.0 (normal jump)
- Supports integration with:
  - `player_monoids` (if available)
  - `pova` mod (if available)
  - Fallback to vanilla physics override

### Eye Vision Effects

#### `player:right_eye_vision`
- Controls right eye vision quality
- Base value: 1.0 (perfect vision)
- Values < 1.0 create visual impairment overlay on right side
- Automatically applies HUD overlay when impaired

#### `player:left_eye_vision`
- Controls left eye vision quality
- Base value: 1.0 (perfect vision)
- Values < 1.0 create visual impairment overlay on left side
- Automatically applies HUD overlay when impaired

**Eye Vision System Features:**
- Dynamic HUD overlay based on vision values
- Separate control for each eye
- Persistent across player sessions
- Automatically removed on respawn
- Uses custom textures: `players_effects_eye_vision.png`, `players_effects_right_eye_vision.png`, `players_effects_left_eye_vision.png`

### Brain Concussion Effects

A complex effect system simulating brain injuries with multiple sub-effects:

#### Visual Shaking Effect
- Randomly shakes camera view (horizontal and vertical)
- Intensity based on concussion severity
- Configurable horizontal/vertical intensity coefficients
- Applied at random intervals

#### Visual Sensitivity Effect
- Adds semi-transparent overlay to screen
- Opacity scales with concussion intensity
- Uses texture: `players_effects_visual_sensitivity.png`
- Automatically manages HUD element lifecycle

#### Item Drop Effect
- Causes player to randomly drop wielded item
- Configurable drop chance per item (via `diarm_chance` in item definition)
- Optional hit area restriction
- Item spawned at player position

**Brain Concussion System Features:**
- Time-based decay system
- Configurable intensity curves with thresholds
- Multiple simultaneous sub-effects
- Gaussian distribution for effect timing and intensity
- Accumulative damage factor (repeated hits increase severity)
- Effects triggered at random intervals based on severity
- Normal distribution parameters:
  - `mean_interval` / `std_interval` - Time between effect triggers
  - `mean_duration` / `std_duration` - Duration of each effect
  - `mean_intensity` / `std_intensity` - Strength of each effect
- Intensity thresholds: `threshold_start`, `threshold_peak`
- Curve parameters: `base_value`, `peak_value`, `over_value`, `curve`

## Source code:

Copyright (c) 2025 SFENCE
MIT - check [LICENSE.md](LICENSE.md) file

## License of media (textures, sounds and models):

CC BY-SA 4.0 - check [LICENSE.md](LICENSE.md) file

Copyright (c) 2025 SFENCE (CC BY-SA 4.0): All textures not mentioned bellow.

## Found bug? Want improvements?
If you found bug, have improvement idea etc, use https://github.com/sfence/players_effects/issues . Author is opened to help via PR, but strongly recommend to consult improvement idea first via issue or different communication platform.
