
players_effects.brain_concussion = {}
local brain_concussion = players_effects.brain_concussion

local brain_concussion_group_label = "players_effects:brain_concussion"

local function calculate_brain_concussion(self, player, hit_data)
	if self.cb_calculate then
		return self:cb_calculate(player, hit_data)
	else
		local data = {}
		data.time = hit_data.damage
		if self.time_per_damage then
			data.time = hit_data.damage * self.time_per_damage
		end
		data.intensity = 0.8
		return data
	end
end

local function create_effects_group_brain_concussion(self, player)
	local group_data = {
		effects = table.copy(self.effects),
		cb_update = function(self, player, dtime, add_value)
			local brain_data = players_effects.get_storage_data(player, "players_effects:brain_concussion")
			brain_data.time = brain_data.time or 0 - dtime
			--print("Brain concussion group time remaining: "..self.time)
			if brain_data.time > 0 then
				attributes_effects.request_object_on_step_update(player:get_guid())
				for effect_name, effect in pairs(self.effects) do
					local effect_data = brain_data.effects[effect_name]
					effect_data.time = effect_data.time + dtime
					if effect_data.time > effect_data.end_time then
						effect:cb_next_time(self, player, brain_data, effect_data)
						--print("Next brain concussion effect '"..effect_name.."': start_time="..effect_data.start_time..", end_time="..effect_data.end_time..", intensity="..effect_data.intensity)
					elseif effect_data.time > effect_data.start_time then
						effect:cb_apply_effect(self, player, brain_data, effect_data, add_value)
						--print("Applying brain concussion effect '"..effect_name.."', intensity="..effect_data.intensity)
					end
				end
				players_effects.set_storage_data(player, "players_effects:brain_concussion", brain_data)
				return true
			else
				return false
			end
		end,
		cb_remove = function(self, player_guid)
			local player = core.objects_by_guid[player_guid]
			local brain_data = players_effects.get_storage_data(player, "players_effects:brain_concussion")
			for effect_name, effect in pairs(self.effects) do
				if effect.cb_remove_effect then
					effect:cb_remove_effect(self, player, brain_data, brain_data.effects[effect_name])
				end
			end
			players_effects.remove_storage_data(player, "players_effects:brain_concussion")
		end
	}
	return group_data
end

function brain_concussion.add_effects_group_brain_concussion(self, player, hit_data)
	local group_id = attributes_effects.get_effects_group_id(player:get_guid(), brain_concussion_group_label)
	if group_id then
		local group_data = attributes_effects.get_effects_group(group_id)
		local time_data = players_effects.get_storage_data(player, "players_effects:brain_concussion")

		local calc_data = calculate_brain_concussion(self, player, hit_data)

		self:add_brain_concussion(group_data, time_data, calc_data)
	else
		local brain_data = calculate_brain_concussion(self, player, hit_data)

		brain_data.effects = {}

		for effect_name, effect in pairs(self.effects) do
			brain_data.effects[effect_name] = {
				time = 0,
				start_time = 0,
				end_time = 0,
			}
		end
		players_effects.set_storage_data(player, "players_effects:brain_concussion", brain_data)

		local group_data = create_effects_group_brain_concussion(self, player)

		attributes_effects.add_effects_group_to_object(player:get_guid(), brain_concussion_group_label, group_data)
		attributes_effects.objects_list[player:get_guid()].verbose = true
	end
end

function brain_concussion.load_effects_group_brain_concussion(self, player)
	local brain_data = players_effects.get_storage_data(player, "players_effects:brain_concussion")
	
	if brain_data.intensity then
		local group_data = create_effects_group_brain_concussion(self, player)

		attributes_effects.add_effects_group_to_object(player:get_guid(), brain_concussion_group_label, group_data)
		attributes_effects.objects_list[player:get_guid()].verbose = true
	end
end

function brain_concussion.respawn_brain_concussion_default(self, player)
	players_effects.remove_storage_data(player, "players_effects:brain_concussion")
end

function brain_concussion.add_brain_concussion_default(self, group_data, time_data, calc_data)
	local base = calc_data.intensity
	local factor = 1 + time_data.intensity * self.add_brain_concussion_factor
	time_data.intensity = math.min(1, time_data.intensity + base * factor)
end

local function value_from_data_and_intensity(data, intensity)
	if intensity < data.threshold_start then
		return data.base_value
	elseif intensity < data.threshold_peak then
		local t = (intensity - data.threshold_start) / (data.threshold_peak - data.threshold_start)
		return data.base_value + t * (data.peak_value - data.base_value)
	else
		local overshoot = intensity - data.threshold_peak
		local decay = 1 - math.exp(-data.curve * overshoot)
		return data.peak_value + decay * (data.over_value - data.peak_value)
	end
end

function brain_concussion.effects_next_time_default(self, group_data, player, brain_data, time_data)
	time_data.time = 0

	local mean_interval = value_from_data_and_intensity(self.mean_interval, brain_data.intensity)
	local std_interval  = value_from_data_and_intensity(self.std_interval, brain_data.intensity)
	local mean_duration = value_from_data_and_intensity(self.mean_duration, brain_data.intensity)
	local std_duration  = value_from_data_and_intensity(self.std_duration, brain_data.intensity)
	local mean_intensity = value_from_data_and_intensity(self.mean_intensity, brain_data.intensity)
	local std_intensity  = value_from_data_and_intensity(self.std_intensity, brain_data.intensity)

	local interval  = math.max(1, players_effects.rand_normal(mean_interval, std_interval))
	local duration  = math.max(0.5, players_effects.rand_normal(mean_duration, std_duration))
	local intensity = math.max(0, math.min(1, players_effects.rand_normal(mean_intensity, std_intensity)))

	time_data.start_time = time_data.time + interval
	time_data.end_time   = time_data.start_time + duration
	time_data.intensity  = intensity
end

brain_concussion.effect_visual_shaking = {
	cb_next_time = brain_concussion.effects_next_time_default,
	cb_apply_effect = function(self, group_data, player, brain_data, time_data, add_value)
		local look_horizontal = player:get_look_horizontal()
		local look_vertical = player:get_look_vertical()
		local hor_intensity = time_data.intensity * self.horizontal_intensity_coef
		look_horizontal = look_horizontal + (math.random() - 0.5) * hor_intensity
		local ver_intensity = time_data.intensity * self.vertical_intensity_coef
		look_vertical = look_vertical + (math.random() - 0.5) * ver_intensity
		player:set_look_horizontal(look_horizontal)
		player:set_look_vertical(look_vertical)
	end,
}

brain_concussion.effect_visual_sensitivity = {
	cb_next_time = function(self, brain_data, player, brain_data, time_data)
		if self.hud_id then
			player:hud_remove(self.hud_id)
			self.hud_id = nil
		end
		brain_concussion.effects_next_time_default(self, group_data, player, brain_data, time_data)
	end,
	cb_apply_effect = function(self, group_data, player, brain_data, time_data, add_value)
		if not self.hud_id then
			local hud_def = {
				type = "image",
				position = {x = 0, y = 0},
				offset = {x = 0, y = 0},
				-- Negative scale used by some clients to simulate zoom
				scale = {x = -100, y = -100},
				text = "",
				alignment = {x = 1, y = 1},
				z_index = 1000,
			}
			self.hud_id = player:hud_add(hud_def)
		end
		local opacity = math.floor(time_data.intensity * self.opacity_coef)
		opacity = math.max(0, math.min(255, opacity))
		local texture = "players_effects_visual_sensitivity.png^[opacity:"..opacity
		player:hud_change(self.hud_id, "text", texture)
	end,
	cb_remove_effect = function(self, group_data, player, brain_data, time_data)
		if self.hud_id then
			player:hud_remove(self.hud_id)
			self.hud_id = nil
		end
	end,
}


brain_concussion.effect_drop_item = {
	cb_next_time = brain_concussion.effects_next_time_default,
	cb_apply_effect = function(self, group_data, player, brain_data, time_data, add_value)
		if self.hit_area then
			if not vector.in_area(hit_data.details.hit_relative, self.hit_area.min, self.hit_area.max) then
				return
			end
		end

		local wielded = player:get_wielded_item()
		if wielded:is_empty() then
			return
		end
		local def = wielded:get_definition()
		if def and def.diarm_chance then
			local chance = def.diarm_chance
			if math.random() > chance then
				return
			end
		end
		player:set_wielded_item(ItemStack(""))
		
		local pos = player:get_pos()
		core.add_item(pos, wielded)
	end,
}