
players_effects.eye_vision = {}

local eye_vision = players_effects.eye_vision

local group_name = "players_effects:eye_vision"

function eye_vision.set_right_eye_vision(player, value)
	local eye_data = player:get_meta():get("players_effects:eye_vision")
	eye_data = core.parse_json(eye_data or "{}") or {}
	if not eye_data.right_eye then
		eye_data.right_eye = 1.0
	end
	if math.abs(eye_data.right_eye - value) > 0.001 then
		eye_data.right_eye = value
		player:get_meta():set_string("players_effects:eye_vision", core.write_json(eye_data))
		eye_vision.apply_effects_group(player)
	elseif value < 1.0 then
		if not attributes_effects.get_effects_group_id(player:get_guid(), group_name) then
			eye_vision.apply_effects_group(player)
		end
	end
end

function eye_vision.set_left_eye_vision(player, value)
	local eye_data = player:get_meta():get("players_effects:eye_vision")
	eye_data = core.parse_json(eye_data or "{}") or {}
	if not eye_data.left_eye then
		eye_data.left_eye = 1.0
	end
	if math.abs(eye_data.left_eye - value) > 0.001 then
		eye_data.left_eye = value
		player:get_meta():set_string("players_effects:eye_vision", core.write_json(eye_data))
		eye_vision.apply_effects_group(player)
	elseif value < 1.0 then
		if not attributes_effects.get_effects_group_id(player:get_guid(), group_name) then
			eye_vision.apply_effects_group(player)
		end
	end
end

function eye_vision.apply_effects_group(player)
	local eye_data = player:get_meta():get("players_effects:eye_vision")
	eye_data = core.parse_json(eye_data or "{}") or {}
	local right_eye_value = eye_data.right_eye or 1.0
	local left_eye_value = eye_data.left_eye or 1.0

	if right_eye_value < 1.0 or left_eye_value < 1.0 then
		local player_guid = player:get_guid()
		if not attributes_effects.get_effects_group_id(player_guid, group_name) then
			local effects_group = {
				cb_update = function(self, player, dtime, add_value)
					local eye_data = player:get_meta():get_string("players_effects:eye_vision")
					eye_data = core.parse_json(eye_data or "{}") or {}
					local right_eye_value = eye_data.right_eye or 1.0
					local left_eye_value = eye_data.left_eye or 1.0
					
					print("Right eye value: "..right_eye_value..", Left eye value: "..left_eye_value)

					if right_eye_value < 1.0 or left_eye_value < 1.0 then
						if not self.hud_id then
							local hud_def = {
								type = "image",
								position = {x = 0, y = 0},
								offset = {x = 0, y = 0},
								-- Negative scale used by some clients to simulate zoom
								scale = {x = -100, y = -100},
								text = "",
								alignment = {x = 1, y = 1},
								z_index = 1000,
							}
							self.hud_id = player:hud_add(hud_def)
							print("Added eye vision HUD with ID: "..self.hud_id)
						end

						local texture = ""
						local sep = ""
						local vision_value = math.max(right_eye_value, left_eye_value)
						if vision_value < 1.0 then
							local opaque = math.floor(255 - vision_value * 255)
							opaque = math.max(0, math.min(255, opaque))
							texture = "(players_effects_eye_vision.png^[opacity:"..opaque..")"
							sep = "^"
						end
						if right_eye_value < vision_value then
							right_eye_value = vision_value - right_eye_value
							opaque = math.floor(right_eye_value * 255)
							opaque = math.max(0, math.min(255, opaque))
							texture = texture..sep.."(players_effects_right_eye_vision.png^[opacity:"..opaque..")"
						end
						if left_eye_value < vision_value then
							left_eye_value = vision_value - left_eye_value
							opaque = math.floor(left_eye_value * 255)
							opaque = math.max(0, math.min(255, opaque))
							texture = texture..sep.."(players_effects_left_eye_vision.png^[opacity:"..opaque..")"
						end

						-- Update the HUD element with the current eye vision values
						player:hud_change(self.hud_id, "text", texture)
						print("Updated eye vision HUD with texture: "..texture)

						return true
					else
						print("Effect groups to be removed for player GUID: "..player_guid)
						return false
					end
				end,
				cb_remove = function(self, player_guid)
					print("Removing eye vision HUD for player GUID: "..player_guid)
					local player = core.objects_by_guid[player_guid]
					if player and self.hud_id then
						print("Removing eye vision HUD with ID: "..self.hud_id)
						player:hud_remove(self.hud_id)
					end
				end,
			}
			attributes_effects.add_effects_group_to_object(player_guid, group_name, effects_group)
			attributes_effects.objects_list[player_guid].verbose = true
			print(dump(attributes_effects.objects_list[player_guid]))
		else
			attributes_effects.request_object_on_step_update(player_guid)
		end
	end
end

players_effects.register_on_respawn_callback(function(player)
	player:get_meta():set_string("players_effects:eye_vision", core.write_json({}))
end)

players_effects.register_on_join_callback(function(player)
	eye_vision.apply_effects_group(player)
end)