
attributes_effects.register_value_effect("player:speed", {
	cb_is_available = function(effect_def, obj)
		return obj:is_player()
	end,
	cb_get_value = function(effect_def, obj)
		return 1.0
	end,
	cb_calculate_value = function(effect_def, orig_value, value_list)
		return attributes_effects.default_calculate_value(effect_def, orig_value, value_list)
	end,
	cb_set_value = function(effect_def, obj, calc_value)
		if use_player_monoids then
			player_monoids.speed:add_change(obj, calc_value,
			"players_effects:speed")
		elseif use_pova_mod then
			pova.add_override(name, "3d_armor", {
				speed = calc_value - 1,
			})
			pova.do_override(obj)
		else
			local physics_override = obj:get_physics_override()
			physics_override.speed = calc_value
			obj:set_physics_override(physics_override)
		end
	end,
})

attributes_effects.register_value_effect("player:right_eye_vision", {
	cb_is_available = function(effect_def, obj)
		return obj:is_player()
	end,
	cb_get_value = function(effect_def, obj)
		return 1.0
	end,
	cb_calculate_value = function(effect_def, orig_value, value_list)
		return attributes_effects.default_calculate_value(effect_def, orig_value, value_list)
	end,
	cb_set_value = function(effect_def, obj, calc_value)
		players_effects.eye_vision.set_right_eye_vision(obj, calc_value)
	end,
})

attributes_effects.register_value_effect("player:left_eye_vision", {
	cb_is_available = function(effect_def, obj)
		return obj:is_player()
	end,
	cb_get_value = function(effect_def, obj)
		return 1.0
	end,
	cb_calculate_value = function(effect_def, orig_value, value_list)
		return attributes_effects.default_calculate_value(effect_def, orig_value, value_list)
	end,
	cb_set_value = function(effect_def, obj, calc_value)
		players_effects.eye_vision.set_left_eye_vision(obj, calc_value)
	end,
})

attributes_effects.register_value_effect("player:jump", {
	cb_is_available = function(effect_def, obj)
		return obj:is_player()
	end,
	cb_get_value = function(effect_def, obj)
		return 1.0
	end,
	cb_calculate_value = function(effect_def, orig_value, value_list)
		return attributes_effects.default_calculate_value(effect_def, orig_value, value_list)
	end,
	cb_set_value = function(effect_def, obj, calc_value)
		if use_player_monoids then
			player_monoids.jump:add_change(obj, calc_value,
			"players_effects:jump")
		elseif use_pova_mod then
			pova.add_override(name, "3d_armor", {
				jump = calc_value - 1,
			})
			pova.do_override(obj)
		else
			local physics_override = obj:get_physics_override()
			physics_override.jump = calc_value
			obj:set_physics_override(physics_override)
		end
	end,
})