
local callbacks_on_heal = players_effects.callbacks.on_heal
local callbacks_on_respawn = players_effects.callbacks.on_respawn
local callbacks_on_join = players_effects.callbacks.on_join

core.register_on_player_hpchange(function(player, hp_change, reason)
	if hp_change >= 0 then
		local player_guid = player:get_guid()
		if reason.type == "respawn" then
			-- respawning
			for _, callback in ipairs(callbacks_on_respawn) do
				callback(player)
			end
			attributes_effects.request_object_on_step_update(player:get_guid())
			core.log("action", "[players_effects] Requested step update for respawned player "..player_guid)
		else
			-- just healing
			for _, callback in ipairs(callbacks_on_heal) do
				callback(player, hp_change, reason)
			end
			attributes_effects.request_object_on_step_update(player:get_guid())
			core.log("action", "[players_effects] Requested step update for healed player "..player_guid)
		end
	end
end)

core.register_on_joinplayer(function(player)
	local callbacks_on_join = players_effects.callbacks.on_join
	for _, callback in ipairs(callbacks_on_join) do
		callback(player)
	end
	core.log("action", "[players_effects] Processed on_join callbacks for player "..player:get_guid())
end)