
function players_effects.rand_normal(mean, stddev)
	local u1 = math.random()
	local u2 = math.random()
	local z0 = math.sqrt(-2 * math.log(u1)) * math.cos(2 * math.pi * u2)
	return mean + z0 * stddev
end


function players_effects.random_effect_data(rand_data, actual_intensity)
	local interval = rand_normal(rand_data.mean_interval, rand_data.std_interval)
	interval = interval * (1.0 - 0.5 * actual_intensity)
	
	local duration = rand_normal(rand_data.mean_duration, rand_data.std_duration)
	duration = duration * (1.0 + 0.5 * actual_intensity)
	
	local intensity = rand_normal(rand_data.mean_intensity, rand_data.std_intensity)
	intensity = intensity * (0.5 + actual_intensity)

	interval = math.max(1, interval)
	duration = math.max(0.5, duration)
	intensity = math.max(0, math.min(1, intensity)) 

	return {
			interval = interval,
			duration = duration,
			intensity = intensity
	}
end