
local S = power_generators.translator

-- node box {x=0, y=0, z=0}
local hor_box = {
  type = "fixed",
  fixed = {
    {-0.5,-0.5,-0.5,-0.375,0.5,-0.375},
    {0.375,-0.5,-0.5,0.5,0.5,-0.375},
    {-0.0625,-0.0625,-0.5,0.0625,0.0625,0.5},
    {-0.375,-0.125,-0.4375,0.375,-0.0625,-0.375},
    {-0.125,-0.0625,-0.4375,-0.0625,0.125,-0.375},
    {0.0625,-0.0625,-0.4375,0.125,0.125,-0.375},
    {-0.375,0.0625,-0.4375,-0.125,0.125,-0.375},
    {-0.0625,0.0625,-0.4375,0.0625,0.125,-0.375},
    {0.125,0.0625,-0.4375,0.375,0.125,-0.375},
    {-0.4375,-0.125,-0.375,-0.375,0.125,-0.3125},
    {0.375,-0.125,-0.375,0.4375,0.125,-0.3125},
    {-0.4375,-0.125,-0.3125,-0.375,-0.0625,0.5},
    {0.375,-0.125,-0.3125,0.4375,-0.0625,0.5},
    {-0.4375,0.0625,-0.3125,-0.375,0.125,0.5},
    {0.375,0.0625,-0.3125,0.4375,0.125,0.5},
    {-0.4375,-0.0625,-0.125,-0.375,0.0625,-0.0625},
    {0.375,-0.0625,-0.125,0.4375,0.0625,-0.0625},
    {-0.4375,-0.0625,0.0625,-0.375,0.0625,0.125},
    {0.375,-0.0625,0.0625,0.4375,0.0625,0.125},
    {-0.4375,-0.0625,0.3125,-0.375,0.0625,0.5},
    {0.375,-0.0625,0.3125,0.4375,0.0625,0.5},
    {-0.5,-0.5,0.375,-0.375,-0.125,0.5},
    {0.375,-0.5,0.375,0.5,-0.125,0.5},
    {-0.5,-0.125,0.375,-0.4375,0.5,0.5},
    {-0.375,-0.125,0.375,0.375,-0.0625,0.4375},
    {0.4375,-0.125,0.375,0.5,0.5,0.5},
    {-0.375,-0.0625,0.375,-0.3125,0.125,0.4375},
    {-0.125,-0.0625,0.375,-0.0625,0.125,0.4375},
    {0.0625,-0.0625,0.375,0.125,0.125,0.4375},
    {0.3125,-0.0625,0.375,0.375,0.125,0.4375},
    {-0.3125,0.0625,0.375,-0.125,0.125,0.4375},
    {-0.0625,0.0625,0.375,0.0625,0.125,0.4375},
    {0.125,0.0625,0.375,0.3125,0.125,0.4375},
    {-0.4375,0.125,0.375,-0.375,0.5,0.5},
    {0.375,0.125,0.375,0.4375,0.5,0.5},
  },
}
-- node box {x=0, y=0, z=0}
local ver_box = {
  type = "fixed",
  fixed = {
    {-0.5,-0.5,-0.5,-0.375,0.5,-0.375},
    {0.375,-0.5,-0.5,0.5,0.5,-0.375},
    {-0.375,-0.125,-0.4375,0.375,-0.0625,-0.375},
    {-0.125,-0.0625,-0.4375,-0.0625,0.125,-0.375},
    {0.0625,-0.0625,-0.4375,0.125,0.125,-0.375},
    {-0.375,0.0625,-0.4375,-0.125,0.125,-0.375},
    {-0.0625,0.0625,-0.4375,0.0625,0.125,-0.375},
    {0.125,0.0625,-0.4375,0.375,0.125,-0.375},
    {-0.4375,-0.125,-0.375,-0.375,0.125,-0.3125},
    {0.375,-0.125,-0.375,0.4375,0.125,-0.3125},
    {-0.4375,-0.125,-0.3125,-0.375,-0.0625,0.5},
    {0.375,-0.125,-0.3125,0.4375,-0.0625,0.5},
    {-0.4375,0.0625,-0.3125,-0.375,0.125,0.5},
    {0.375,0.0625,-0.3125,0.4375,0.125,0.5},
    {-0.4375,-0.0625,-0.125,-0.375,0.0625,-0.0625},
    {0.375,-0.0625,-0.125,0.4375,0.0625,-0.0625},
    {-0.0625,-0.5,-0.0625,0.0625,0.5,0.0625},
    {-0.4375,-0.0625,0.0625,-0.375,0.0625,0.125},
    {0.375,-0.0625,0.0625,0.4375,0.0625,0.125},
    {-0.4375,-0.0625,0.3125,-0.375,0.0625,0.5},
    {0.375,-0.0625,0.3125,0.4375,0.0625,0.5},
    {-0.5,-0.5,0.375,-0.375,-0.125,0.5},
    {0.375,-0.5,0.375,0.5,-0.125,0.5},
    {-0.5,-0.125,0.375,-0.4375,0.5,0.5},
    {-0.375,-0.125,0.375,0.375,-0.0625,0.4375},
    {0.4375,-0.125,0.375,0.5,0.5,0.5},
    {-0.375,-0.0625,0.375,-0.3125,0.125,0.4375},
    {-0.125,-0.0625,0.375,-0.0625,0.125,0.4375},
    {0.0625,-0.0625,0.375,0.125,0.125,0.4375},
    {0.3125,-0.0625,0.375,0.375,0.125,0.4375},
    {-0.3125,0.0625,0.375,-0.125,0.125,0.4375},
    {-0.0625,0.0625,0.375,0.0625,0.125,0.4375},
    {0.125,0.0625,0.375,0.3125,0.125,0.4375},
    {-0.4375,0.125,0.375,-0.375,0.5,0.5},
    {0.375,0.125,0.375,0.4375,0.5,0.5},
  },
}

minetest.register_node("power_generators:shaft_hor", {
    description = S("Shaft"),
    drawtype = "mesh",
    mesh = "power_generators_shaft.obj",
    tiles = {"power_generators_frame_steel.png", "power_generators_shaft_steel.png"},
    paramtype = "light",
    paramtype2 = "facedir",
    selection_box = hor_box,
    collision_box = hor_box,
    groups = {cracky = 1, shaft = 2},
    _shaft_sides = {"front","back"},
    
    on_construct = function(pos)
      local meta = minetest.get_meta(pos)
      meta:set_float("I", 1)
      meta:set_float("fric", 0.1)
    end,
  })

minetest.register_node("power_generators:shaft_ver", {
    description = S("Shaft"),
    drawtype = "mesh",
    mesh = "power_generators_shaft_ver.obj",
    tiles = {"power_generators_frame_steel.png", "power_generators_shaft_steel.png"},
    paramtype = "light",
    paramtype2 = "facedir",
    selection_box = ver_box,
    collision_box = ver_box,
    groups = {cracky = 1, shaft = 2},
    _shaft_sides = {"bottom","top"},
    
    on_construct = function(pos)
      local meta = minetest.get_meta(pos)
      meta:set_float("I", 2)
    end,
  })

