
local S = rope_bridges.translator;

-- node box {x=0, y=0, z=0}
local part_flat = {
    type = "fixed",
    fixed = {
      {-0.3125,-0.375,-0.5,-0.25,-0.3125,-0.3125},
      {0.25,-0.375,-0.5,0.3125,-0.3125,-0.3125},
      {-0.4375,0.4375,-0.5,-0.375,0.5,0.5},
      {0.375,0.4375,-0.5,0.4375,0.5,0.5},
      {-0.4375,-0.375,-0.375,-0.3125,-0.3125,-0.125},
      {-0.25,-0.375,-0.375,0.25,-0.3125,-0.125},
      {0.3125,-0.375,-0.375,0.4375,-0.3125,-0.125},
      {-0.3125,-0.4375,-0.3125,-0.25,-0.375,-0.1875},
      {0.25,-0.4375,-0.3125,0.3125,-0.375,-0.1875},
      {-0.3125,-0.375,-0.3125,-0.25,-0.3125,-0.1875},
      {0.25,-0.375,-0.3125,0.3125,-0.3125,-0.1875},
      {-0.3125,-0.3125,-0.3125,-0.25,-0.25,-0.1875},
      {0.25,-0.3125,-0.3125,0.3125,-0.25,-0.1875},
      {-0.375,-0.25,-0.3125,-0.3125,0.125,-0.25},
      {0.3125,-0.25,-0.3125,0.375,0.125,-0.25},
      {-0.4375,0.125,-0.3125,-0.375,0.4375,-0.25},
      {0.375,0.125,-0.3125,0.4375,0.4375,-0.25},
      {-0.5,0.4375,-0.3125,-0.4375,0.5,-0.25},
      {-0.375,0.4375,-0.3125,-0.3125,0.5,-0.25},
      {0.3125,0.4375,-0.3125,0.375,0.5,-0.25},
      {0.4375,0.4375,-0.3125,0.5,0.5,-0.25},
      {-0.3125,-0.375,-0.1875,-0.25,-0.3125,0.1875},
      {0.25,-0.375,-0.1875,0.3125,-0.3125,0.1875},
      {-0.4375,-0.375,0.125,-0.3125,-0.3125,0.375},
      {-0.25,-0.375,0.125,0.25,-0.3125,0.375},
      {0.3125,-0.375,0.125,0.4375,-0.3125,0.375},
      {-0.3125,-0.4375,0.1875,-0.25,-0.375,0.3125},
      {0.25,-0.4375,0.1875,0.3125,-0.375,0.3125},
      {-0.3125,-0.375,0.1875,-0.25,-0.3125,0.3125},
      {0.25,-0.375,0.1875,0.3125,-0.3125,0.3125},
      {-0.3125,-0.3125,0.1875,-0.25,-0.25,0.3125},
      {0.25,-0.3125,0.1875,0.3125,-0.25,0.3125},
      {-0.375,-0.25,0.25,-0.3125,0.125,0.3125},
      {0.3125,-0.25,0.25,0.375,0.125,0.3125},
      {-0.4375,0.125,0.25,-0.375,0.4375,0.3125},
      {0.375,0.125,0.25,0.4375,0.4375,0.3125},
      {-0.5,0.4375,0.25,-0.4375,0.5,0.3125},
      {-0.375,0.4375,0.25,-0.3125,0.5,0.3125},
      {0.3125,0.4375,0.25,0.375,0.5,0.3125},
      {0.4375,0.4375,0.25,0.5,0.5,0.3125},
      {-0.3125,-0.375,0.3125,-0.25,-0.3125,0.5},
      {0.25,-0.375,0.3125,0.3125,-0.3125,0.5},
    },
  }
  
-- node box {x=0, y=0, z=0}
local part_up = {
    type = "fixed",
    fixed = {
      {-0.3125,-0.1875,-0.5,-0.25,-0.125,-0.4375},
      {0.25,-0.1875,-0.5,0.3125,-0.125,-0.4375},
      {-0.3125,-0.25,-0.4375,-0.25,-0.1875,-0.3125},
      {0.25,-0.25,-0.4375,0.3125,-0.1875,-0.3125},
      {-0.4375,-0.25,-0.375,-0.3125,-0.1875,-0.125},
      {-0.25,-0.25,-0.375,0.25,-0.1875,-0.125},
      {0.3125,-0.25,-0.375,0.4375,-0.1875,-0.125},
      {-0.3125,-0.3125,-0.3125,-0.25,-0.25,-0.1875},
      {0.25,-0.3125,-0.3125,0.3125,-0.25,-0.1875},
      {-0.3125,-0.25,-0.3125,-0.25,-0.1875,-0.1875},
      {0.25,-0.25,-0.3125,0.3125,-0.1875,-0.1875},
      {-0.3125,-0.1875,-0.3125,-0.25,-0.125,-0.1875},
      {0.25,-0.1875,-0.3125,0.3125,-0.125,-0.1875},
      {-0.375,-0.125,-0.3125,-0.3125,0.25,-0.25},
      {0.3125,-0.125,-0.3125,0.375,0.25,-0.25},
      {-0.4375,0.25,-0.3125,-0.375,0.5,-0.25},
      {0.375,0.25,-0.3125,0.4375,0.5,-0.25},
      {-0.3125,-0.25,-0.1875,-0.25,-0.1875,-0.0625},
      {0.25,-0.25,-0.1875,0.3125,-0.1875,-0.0625},
      {-0.3125,-0.3125,-0.0625,-0.25,-0.25,0.0625},
      {0.25,-0.3125,-0.0625,0.3125,-0.25,0.0625},
      {-0.3125,-0.375,0.0625,-0.25,-0.3125,0.1875},
      {0.25,-0.375,0.0625,0.3125,-0.3125,0.1875},
      {-0.4375,-0.375,0.125,-0.3125,-0.3125,0.375},
      {-0.25,-0.375,0.125,0.25,-0.3125,0.375},
      {0.3125,-0.375,0.125,0.4375,-0.3125,0.375},
      {-0.4375,0.4375,0.125,-0.375,0.5,0.4375},
      {0.375,0.4375,0.125,0.4375,0.5,0.4375},
      {-0.3125,-0.4375,0.1875,-0.25,-0.375,0.3125},
      {0.25,-0.4375,0.1875,0.3125,-0.375,0.3125},
      {-0.3125,-0.375,0.1875,-0.25,-0.3125,0.3125},
      {0.25,-0.375,0.1875,0.3125,-0.3125,0.3125},
      {-0.3125,-0.3125,0.1875,-0.25,-0.25,0.3125},
      {0.25,-0.3125,0.1875,0.3125,-0.25,0.3125},
      {-0.375,-0.25,0.25,-0.3125,0.125,0.3125},
      {0.3125,-0.25,0.25,0.375,0.125,0.3125},
      {-0.4375,0.125,0.25,-0.375,0.4375,0.3125},
      {0.375,0.125,0.25,0.4375,0.4375,0.3125},
      {-0.5,0.4375,0.25,-0.4375,0.5,0.3125},
      {-0.375,0.4375,0.25,-0.3125,0.5,0.3125},
      {0.3125,0.4375,0.25,0.375,0.5,0.3125},
      {0.4375,0.4375,0.25,0.5,0.5,0.3125},
      {-0.3125,-0.375,0.3125,-0.25,-0.3125,0.4375},
      {0.25,-0.375,0.3125,0.3125,-0.3125,0.4375},
      {-0.3125,-0.4375,0.4375,-0.25,-0.375,0.5},
      {0.25,-0.4375,0.4375,0.3125,-0.375,0.5},
      {-0.4375,0.375,0.4375,-0.375,0.4375,0.5},
      {0.375,0.375,0.4375,0.4375,0.4375,0.5},
    },
  }

for _,values in pairs({
      {-0.4375,-0.375,-0.5,-0.375,-0.3125,-0.4375},
      {0.375,-0.375,-0.5,0.4375,-0.3125,-0.4375},
      {-0.4375,-0.4375,-0.4375,-0.375,-0.375,-0.125},
      {0.375,-0.4375,-0.4375,0.4375,-0.375,-0.125},
      {-0.5,-0.5,-0.3125,-0.375,-0.4375,-0.25},
      {0.375,-0.5,-0.3125,0.5,-0.4375,-0.25},
      {-0.375,-0.4375,-0.3125,-0.3125,-0.375,-0.25},
      {0.3125,-0.4375,-0.3125,0.375,-0.375,-0.25},
      {-0.4375,-0.5,-0.125,-0.375,-0.4375,0.125},
      {0.375,-0.5,-0.125,0.4375,-0.4375,0.125},
    }) do
  values[2] = values[2] + 1;
  values[5] = values[5] + 1;
  table.insert(part_up.fixed, values)
end

-- node box {x=0, y=0, z=0}
local part_flatup = {
    type = "fixed",
    fixed = {
      {-0.3125,-0.1875,-0.5,-0.25,-0.125,-0.4375},
      {0.25,-0.1875,-0.5,0.3125,-0.125,-0.4375},
      {-0.3125,-0.25,-0.4375,-0.25,-0.1875,-0.3125},
      {0.25,-0.25,-0.4375,0.3125,-0.1875,-0.3125},
      {-0.4375,-0.25,-0.375,-0.3125,-0.1875,-0.125},
      {-0.25,-0.25,-0.375,0.25,-0.1875,-0.125},
      {0.3125,-0.25,-0.375,0.4375,-0.1875,-0.125},
      {-0.3125,-0.3125,-0.3125,-0.25,-0.25,-0.1875},
      {0.25,-0.3125,-0.3125,0.3125,-0.25,-0.1875},
      {-0.3125,-0.25,-0.3125,-0.25,-0.1875,-0.1875},
      {0.25,-0.25,-0.3125,0.3125,-0.1875,-0.1875},
      {-0.3125,-0.1875,-0.3125,-0.25,-0.125,-0.1875},
      {0.25,-0.1875,-0.3125,0.3125,-0.125,-0.1875},
      {-0.375,-0.125,-0.3125,-0.3125,0.25,-0.25},
      {0.3125,-0.125,-0.3125,0.375,0.25,-0.25},
      {-0.4375,0.25,-0.3125,-0.375,0.5,-0.25},
      {0.375,0.25,-0.3125,0.4375,0.5,-0.25},
      {-0.3125,-0.25,-0.1875,-0.25,-0.1875,-0.0625},
      {0.25,-0.25,-0.1875,0.3125,-0.1875,-0.0625},
      {-0.3125,-0.3125,-0.0625,-0.25,-0.25,0.0625},
      {0.25,-0.3125,-0.0625,0.3125,-0.25,0.0625},
      {-0.3125,-0.375,0.0625,-0.25,-0.3125,0.1875},
      {0.25,-0.375,0.0625,0.3125,-0.3125,0.1875},
      {-0.4375,-0.375,0.125,-0.3125,-0.3125,0.375},
      {-0.25,-0.375,0.125,0.25,-0.3125,0.375},
      {0.3125,-0.375,0.125,0.4375,-0.3125,0.375},
      {-0.4375,0.4375,0.125,-0.375,0.5,0.5},
      {0.375,0.4375,0.125,0.4375,0.5,0.5},
      {-0.3125,-0.4375,0.1875,-0.25,-0.375,0.3125},
      {0.25,-0.4375,0.1875,0.3125,-0.375,0.3125},
      {-0.3125,-0.375,0.1875,-0.25,-0.3125,0.3125},
      {0.25,-0.375,0.1875,0.3125,-0.3125,0.3125},
      {-0.3125,-0.3125,0.1875,-0.25,-0.25,0.3125},
      {0.25,-0.3125,0.1875,0.3125,-0.25,0.3125},
      {-0.375,-0.25,0.25,-0.3125,0.125,0.3125},
      {0.3125,-0.25,0.25,0.375,0.125,0.3125},
      {-0.4375,0.125,0.25,-0.375,0.4375,0.3125},
      {0.375,0.125,0.25,0.4375,0.4375,0.3125},
      {-0.5,0.4375,0.25,-0.4375,0.5,0.3125},
      {-0.375,0.4375,0.25,-0.3125,0.5,0.3125},
      {0.3125,0.4375,0.25,0.375,0.5,0.3125},
      {0.4375,0.4375,0.25,0.5,0.5,0.3125},
      {-0.3125,-0.375,0.3125,-0.25,-0.3125,0.5},
      {0.25,-0.375,0.3125,0.3125,-0.3125,0.5},
    },
  }

for _,values in pairs({
      {-0.4375,-0.375,-0.5,-0.375,-0.3125,-0.4375},
      {0.375,-0.375,-0.5,0.4375,-0.3125,-0.4375},
      {-0.4375,-0.4375,-0.4375,-0.375,-0.375,-0.125},
      {0.375,-0.4375,-0.4375,0.4375,-0.375,-0.125},
      {-0.5,-0.5,-0.3125,-0.375,-0.4375,-0.25},
      {0.375,-0.5,-0.3125,0.5,-0.4375,-0.25},
      {-0.375,-0.4375,-0.3125,-0.3125,-0.375,-0.25},
      {0.3125,-0.4375,-0.3125,0.375,-0.375,-0.25},
      {-0.4375,-0.5,-0.125,-0.375,-0.4375,0.125},
      {0.375,-0.5,-0.125,0.4375,-0.4375,0.125},
    }) do
  values[2] = values[2] + 1;
  values[5] = values[5] + 1;
  table.insert(part_flatup.fixed, values)
end

-- node box {x=0, y=0, z=0}
local part_upflat = {
    type = "fixed",
    fixed = {
      {-0.3125,-0.25,-0.5,-0.25,-0.1875,-0.3125},
      {0.25,-0.25,-0.5,0.3125,-0.1875,-0.3125},
      {-0.4375,-0.25,-0.375,-0.3125,-0.1875,-0.125},
      {-0.25,-0.25,-0.375,0.25,-0.1875,-0.125},
      {0.3125,-0.25,-0.375,0.4375,-0.1875,-0.125},
      {-0.3125,-0.3125,-0.3125,-0.25,-0.25,-0.1875},
      {0.25,-0.3125,-0.3125,0.3125,-0.25,-0.1875},
      {-0.3125,-0.25,-0.3125,-0.25,-0.1875,-0.1875},
      {0.25,-0.25,-0.3125,0.3125,-0.1875,-0.1875},
      {-0.3125,-0.1875,-0.3125,-0.25,-0.125,-0.1875},
      {0.25,-0.1875,-0.3125,0.3125,-0.125,-0.1875},
      {-0.375,-0.125,-0.3125,-0.3125,0.25,-0.25},
      {0.3125,-0.125,-0.3125,0.375,0.25,-0.25},
      {-0.4375,0.25,-0.3125,-0.375,0.5,-0.25},
      {0.375,0.25,-0.3125,0.4375,0.5,-0.25},
      {-0.3125,-0.25,-0.1875,-0.25,-0.1875,-0.0625},
      {0.25,-0.25,-0.1875,0.3125,-0.1875,-0.0625},
      {-0.3125,-0.3125,-0.0625,-0.25,-0.25,0.0625},
      {0.25,-0.3125,-0.0625,0.3125,-0.25,0.0625},
      {-0.3125,-0.375,0.0625,-0.25,-0.3125,0.1875},
      {0.25,-0.375,0.0625,0.3125,-0.3125,0.1875},
      {-0.4375,-0.375,0.125,-0.3125,-0.3125,0.375},
      {-0.25,-0.375,0.125,0.25,-0.3125,0.375},
      {0.3125,-0.375,0.125,0.4375,-0.3125,0.375},
      {-0.4375,0.4375,0.125,-0.375,0.5,0.4375},
      {0.375,0.4375,0.125,0.4375,0.5,0.4375},
      {-0.3125,-0.4375,0.1875,-0.25,-0.375,0.3125},
      {0.25,-0.4375,0.1875,0.3125,-0.375,0.3125},
      {-0.3125,-0.375,0.1875,-0.25,-0.3125,0.3125},
      {0.25,-0.375,0.1875,0.3125,-0.3125,0.3125},
      {-0.3125,-0.3125,0.1875,-0.25,-0.25,0.3125},
      {0.25,-0.3125,0.1875,0.3125,-0.25,0.3125},
      {-0.375,-0.25,0.25,-0.3125,0.125,0.3125},
      {0.3125,-0.25,0.25,0.375,0.125,0.3125},
      {-0.4375,0.125,0.25,-0.375,0.4375,0.3125},
      {0.375,0.125,0.25,0.4375,0.4375,0.3125},
      {-0.5,0.4375,0.25,-0.4375,0.5,0.3125},
      {-0.375,0.4375,0.25,-0.3125,0.5,0.3125},
      {0.3125,0.4375,0.25,0.375,0.5,0.3125},
      {0.4375,0.4375,0.25,0.5,0.5,0.3125},
      {-0.3125,-0.375,0.3125,-0.25,-0.3125,0.4375},
      {0.25,-0.375,0.3125,0.3125,-0.3125,0.4375},
      {-0.3125,-0.4375,0.4375,-0.25,-0.375,0.5},
      {0.25,-0.4375,0.4375,0.3125,-0.375,0.5},
      {-0.4375,0.375,0.4375,-0.375,0.4375,0.5},
      {0.375,0.375,0.4375,0.4375,0.4375,0.5},
    },
  }

for _,values in pairs({
      {-0.4375,-0.4375,-0.5,-0.375,-0.375,-0.125},
      {0.375,-0.4375,-0.5,0.4375,-0.375,-0.125},
      {-0.5,-0.5,-0.3125,-0.375,-0.4375,-0.25},
      {0.375,-0.5,-0.3125,0.5,-0.4375,-0.25},
      {-0.375,-0.4375,-0.3125,-0.3125,-0.375,-0.25},
      {0.3125,-0.4375,-0.3125,0.375,-0.375,-0.25},
      {-0.4375,-0.5,-0.125,-0.375,-0.4375,0.125},
      {0.375,-0.5,-0.125,0.4375,-0.4375,0.125},
    }) do
  values[2] = values[2] + 1;
  values[5] = values[5] + 1;
  table.insert(part_upflat.fixed, values)
end
  
-- node box {x=0, y=0, z=0}
local part_flatupflat = {
    type = "fixed",
    fixed = {
      {-0.3125,-0.25,-0.5,-0.25,-0.1875,-0.0625},
      {0.25,-0.25,-0.5,0.3125,-0.1875,-0.0625},
      {-0.4375,-0.25,-0.375,-0.3125,-0.1875,-0.125},
      {-0.25,-0.25,-0.375,0.25,-0.1875,-0.125},
      {0.3125,-0.25,-0.375,0.4375,-0.1875,-0.125},
      {-0.3125,-0.3125,-0.3125,-0.25,-0.25,-0.1875},
      {0.25,-0.3125,-0.3125,0.3125,-0.25,-0.1875},
      {-0.3125,-0.1875,-0.3125,-0.25,-0.125,-0.1875},
      {0.25,-0.1875,-0.3125,0.3125,-0.125,-0.1875},
      {-0.375,-0.125,-0.3125,-0.3125,0.25,-0.25},
      {0.3125,-0.125,-0.3125,0.375,0.25,-0.25},
      {-0.4375,0.25,-0.3125,-0.375,0.5,-0.25},
      {0.375,0.25,-0.3125,0.4375,0.5,-0.25},
      {-0.3125,-0.3125,-0.0625,-0.25,-0.25,0.0625},
      {0.25,-0.3125,-0.0625,0.3125,-0.25,0.0625},
      {-0.3125,-0.375,0.0625,-0.25,-0.3125,0.5},
      {0.25,-0.375,0.0625,0.3125,-0.3125,0.5},
      {-0.4375,-0.375,0.125,-0.3125,-0.3125,0.375},
      {-0.25,-0.375,0.125,0.25,-0.3125,0.375},
      {0.3125,-0.375,0.125,0.4375,-0.3125,0.375},
      {-0.4375,0.4375,0.125,-0.375,0.5,0.5},
      {0.375,0.4375,0.125,0.4375,0.5,0.5},
      {-0.3125,-0.4375,0.1875,-0.25,-0.375,0.3125},
      {0.25,-0.4375,0.1875,0.3125,-0.375,0.3125},
      {-0.3125,-0.3125,0.1875,-0.25,-0.25,0.3125},
      {0.25,-0.3125,0.1875,0.3125,-0.25,0.3125},
      {-0.375,-0.25,0.25,-0.3125,0.125,0.3125},
      {0.3125,-0.25,0.25,0.375,0.125,0.3125},
      {-0.4375,0.125,0.25,-0.375,0.4375,0.3125},
      {0.375,0.125,0.25,0.4375,0.4375,0.3125},
      {-0.5,0.4375,0.25,-0.4375,0.5,0.3125},
      {-0.375,0.4375,0.25,-0.3125,0.5,0.3125},
      {0.3125,0.4375,0.25,0.375,0.5,0.3125},
      {0.4375,0.4375,0.25,0.5,0.5,0.3125},
    },
  }

for _,values in pairs({
      {-0.4375,-0.4375,-0.5,-0.375,-0.375,-0.125},
      {0.375,-0.4375,-0.5,0.4375,-0.375,-0.125},
      {-0.5,-0.5,-0.3125,-0.375,-0.4375,-0.25},
      {0.375,-0.5,-0.3125,0.5,-0.4375,-0.25},
      {-0.375,-0.4375,-0.3125,-0.3125,-0.375,-0.25},
      {0.3125,-0.4375,-0.3125,0.375,-0.375,-0.25},
      {-0.4375,-0.5,-0.125,-0.375,-0.4375,0.125},
      {0.375,-0.5,-0.125,0.4375,-0.4375,0.125},
    }) do
  values[2] = values[2] + 1;
  values[5] = values[5] + 1;
  table.insert(part_flatupflat.fixed, values)
end
  
-- node box {x=0, y=0, z=0}
local part_stilt = {
    type = "fixed",
    fixed = {
      {-0.3125,-0.25,-0.5,-0.25,-0.1875,-0.1875},
      {0.25,-0.25,-0.5,0.3125,-0.1875,-0.1875},
      {-0.4375,0.375,-0.5,-0.375,0.4375,-0.375},
      {0.375,0.375,-0.5,0.4375,0.4375,-0.375},
      {-0.4375,-0.5,-0.375,-0.3125,-0.25,-0.125},
      {0.3125,-0.5,-0.375,0.4375,-0.25,-0.125},
      {-0.4375,-0.25,-0.375,-0.3125,-0.1875,-0.3125},
      {0.3125,-0.25,-0.375,0.4375,-0.1875,-0.3125},
      {-0.4375,-0.1875,-0.375,-0.3125,0.3125,-0.125},
      {0.3125,-0.1875,-0.375,0.4375,0.3125,-0.125},
      {-0.5,0.3125,-0.375,-0.3125,0.375,-0.3125},
      {0.3125,0.3125,-0.375,0.5,0.375,-0.3125},
      {-0.4375,0.375,-0.375,-0.3125,0.5,-0.125},
      {0.3125,0.375,-0.375,0.4375,0.5,-0.125},
      {-0.5,-0.5,-0.3125,-0.4375,-0.25,-0.1875},
      {-0.3125,-0.5,-0.3125,-0.25,-0.25,-0.1875},
      {0.25,-0.5,-0.3125,0.3125,-0.25,-0.1875},
      {0.4375,-0.5,-0.3125,0.5,-0.25,-0.1875},
      {-0.5,-0.25,-0.3125,-0.4375,-0.1875,-0.1875},
      {-0.4375,-0.25,-0.3125,-0.3125,-0.1875,-0.1875},
      {0.3125,-0.25,-0.3125,0.4375,-0.1875,-0.1875},
      {0.4375,-0.25,-0.3125,0.5,-0.1875,-0.1875},
      {-0.5,-0.1875,-0.3125,-0.4375,0.3125,-0.1875},
      {-0.3125,-0.1875,-0.3125,-0.25,0.3125,-0.1875},
      {0.25,-0.1875,-0.3125,0.3125,0.3125,-0.1875},
      {0.4375,-0.1875,-0.3125,0.5,0.3125,-0.1875},
      {-0.5,0.3125,-0.3125,-0.4375,0.375,-0.1875},
      {-0.4375,0.3125,-0.3125,-0.3125,0.375,-0.1875},
      {-0.3125,0.3125,-0.3125,-0.25,0.375,-0.1875},
      {0.25,0.3125,-0.3125,0.3125,0.375,-0.1875},
      {0.3125,0.3125,-0.3125,0.4375,0.375,-0.1875},
      {0.4375,0.3125,-0.3125,0.5,0.375,-0.1875},
      {-0.5,0.375,-0.3125,-0.4375,0.5,-0.1875},
      {-0.3125,0.375,-0.3125,-0.25,0.5,-0.1875},
      {0.25,0.375,-0.3125,0.3125,0.5,-0.1875},
      {0.4375,0.375,-0.3125,0.5,0.5,-0.1875},
      {-0.4375,-0.25,-0.1875,-0.3125,-0.1875,-0.125},
      {0.3125,-0.25,-0.1875,0.4375,-0.1875,-0.125},
      {-0.4375,0.3125,-0.1875,-0.3125,0.375,-0.125},
      {0.3125,0.3125,-0.1875,0.4375,0.375,-0.125},
    },
  }
  
-- node box {x=0, y=0, z=0}
local part_stilt_cb = {
    type = "fixed",
    fixed = {
      {-0.3125,-0.25,-0.5,-0.25,-0.1875,-0.3125},
      {0.25,-0.25,-0.5,0.3125,-0.1875,-0.3125},
      {-0.4375,0.375,-0.5,-0.375,0.4375,-0.125},
      {0.375,0.375,-0.5,0.4375,0.4375,-0.125},
      {-0.4375,-0.5,-0.375,-0.3125,0.375,-0.125},
      {0.3125,-0.5,-0.375,0.4375,0.375,-0.125},
      {-0.5,0.3125,-0.375,-0.4375,0.375,-0.1875},
      {0.4375,0.3125,-0.375,0.5,0.375,-0.1875},
      {-0.375,0.375,-0.375,-0.3125,0.5,-0.125},
      {0.3125,0.375,-0.375,0.375,0.5,-0.125},
      {-0.4375,0.4375,-0.375,-0.375,0.5,-0.125},
      {0.375,0.4375,-0.375,0.4375,0.5,-0.125},
      {-0.5,-0.5,-0.3125,-0.4375,0.3125,-0.1875},
      {0.4375,-0.5,-0.3125,0.5,0.3125,-0.1875},
      {-0.5,0.375,-0.3125,-0.4375,0.5,-0.1875},
      {0.4375,0.375,-0.3125,0.5,0.5,-0.1875},
      -- support platform for easier entry
      {-0.3125,-0.5,-0.25,0.3125,-0.4375,-0.125},
    },
  }

local function get_lvlcode(level)
  if level>4 then
    level = level - 8;
  end
  local lvlcode = tostring(level);
  if (level<0) then
    lvlcode = "n"..(-level);
  end
  return lvlcode;
end

function rope_bridges.register_planks_bridge(bridge_name, bridge_data)
  local use_waving = 0
  if rope_bridges.bridge_body_waving then
    use_waving = 2
  end
  for lvl=0,7 do
    local level = lvl-3;
    
    local lvlcode = get_lvlcode(level)
    
    -- FLAT
    local my_box = table.copy(part_flat);
    for index,values in pairs(my_box.fixed) do
      values[2] = values[2] + level*0.125;
      values[5] = values[5] + level*0.125;
    end
    
    local my_data = {
        description = bridge_data.desc.." "..S("Flat").." "..level,
        groups = {choppy = 2},
        
        sunlight_propagates = true,
        waving = use_waving,
        paramtype = "light",
        paramtype2 = "facedir",
        drawtype = "mesh",
        mesh = "rope_bridges_planks_flat_l"..lvlcode..".obj",
        tiles = bridge_data.tiles,
        
        selection_box = my_box;
        collision_box = my_box;
        
        sounds = bridge_data.sounds;
      }
    
    minetest.register_node(bridge_name.."_flat_l"..lvlcode, my_data);
    
    minetest.register_craft({
        output = bridge_name.."_flat_l"..get_lvlcode(level+1),
        type = "shapeless",
        recipe = {bridge_name.."_flat_l"..lvlcode},
      });
    -- UP
    local my_box = table.copy(part_up);
    for index,values in pairs(my_box.fixed) do
      values[2] = values[2] + level*0.125;
      values[5] = values[5] + level*0.125;
      --my_box.fixed[index] = value;
    end
    
    local my_data = {
        description = bridge_data.desc.." "..S("Up").." "..level,
        groups = {choppy = 2},
        
        sunlight_propagates = true,
        waving = use_waving,
        paramtype = "light",
        paramtype2 = "facedir",
        drawtype = "mesh",
        mesh = "rope_bridges_planks_up_l"..lvlcode..".obj",
        tiles = bridge_data.tiles,
        
        selection_box = my_box;
        collision_box = my_box;
        
        sounds = bridge_data.sounds;
      }
    
    minetest.register_node(bridge_name.."_up_l"..lvlcode, my_data);
    
    minetest.register_craft({
        output = bridge_name.."_up_l"..get_lvlcode(level+1),
        type = "shapeless",
        recipe = {bridge_name.."_up_l"..lvlcode},
      });
    -- FLAT-UP
    local my_box = table.copy(part_flatup);
    for index,values in pairs(my_box.fixed) do
      values[2] = values[2] + level*0.125;
      values[5] = values[5] + level*0.125;
      --my_box.fixed[index] = value;
    end
    
    local my_data = {
        description = bridge_data.desc.." "..S("Flat-Up").." "..level,
        groups = {choppy = 2},
        
        sunlight_propagates = true,
        waving = use_waving,
        paramtype = "light",
        paramtype2 = "facedir",
        drawtype = "mesh",
        mesh = "rope_bridges_planks_flatup_l"..lvlcode..".obj",
        tiles = bridge_data.tiles,
        
        selection_box = my_box;
        collision_box = my_box;
        
        sounds = bridge_data.sounds;
      }
    
    minetest.register_node(bridge_name.."_flatup_l"..lvlcode, my_data);
    
    minetest.register_craft({
        output = bridge_name.."_flatup_l"..get_lvlcode(level+1),
        type = "shapeless",
        recipe = {bridge_name.."_flatup_l"..lvlcode},
      });
    -- UP-FLAT
    local my_box = table.copy(part_upflat);
    for index,values in pairs(my_box.fixed) do
      values[2] = values[2] + level*0.125;
      values[5] = values[5] + level*0.125;
      --my_box.fixed[index] = value;
    end
    
    local my_data = {
        description = bridge_data.desc.." "..S("Up-Flat").." "..level,
        groups = {choppy = 2},
        
        sunlight_propagates = true,
        waving = use_waving,
        paramtype = "light",
        paramtype2 = "facedir",
        drawtype = "mesh",
        mesh = "rope_bridges_planks_upflat_l"..lvlcode..".obj",
        tiles = bridge_data.tiles,
        
        selection_box = my_box;
        collision_box = my_box;
        
        sounds = bridge_data.sounds;
      }
    
    minetest.register_node(bridge_name.."_upflat_l"..lvlcode, my_data);
    
    minetest.register_craft({
        output = bridge_name.."_upflat_l"..get_lvlcode(level+1),
        type = "shapeless",
        recipe = {bridge_name.."_upflat_l"..lvlcode},
      });
    -- FLAT-UP-FLAT
    local my_box = table.copy(part_flatupflat);
    for index,values in pairs(my_box.fixed) do
      values[2] = values[2] + level*0.125;
      values[5] = values[5] + level*0.125;
      --my_box.fixed[index] = value;
    end
    
    local my_data = {
        description = bridge_data.desc.." "..S("Flat-Up-Flat").." "..level,
        groups = {choppy = 2},
        
        sunlight_propagates = true,
        waving = use_waving,
        paramtype = "light",
        paramtype2 = "facedir",
        drawtype = "mesh",
        mesh = "rope_bridges_planks_flatupflat_l"..lvlcode..".obj",
        tiles = bridge_data.tiles,
        
        selection_box = my_box;
        collision_box = my_box;
        
        sounds = bridge_data.sounds;
      }
    
    minetest.register_node(bridge_name.."_flatupflat_l"..lvlcode, my_data);
    
    minetest.register_craft({
        output = bridge_name.."_flatupflat_l"..get_lvlcode(level+1),
        type = "shapeless",
        recipe = {bridge_name.."_flatupflat_l"..lvlcode},
      });
    -- STILT
    local my_box = table.copy(part_stilt);
    for index,values in pairs(my_box.fixed) do
      values[2] = values[2] + level*0.125;
      values[5] = values[5] + level*0.125;
      --my_box.fixed[index] = value;
    end
    
    local my_cb_box = table.copy(part_stilt_cb);
    for index,values in pairs(my_cb_box.fixed) do
      values[2] = values[2] + level*0.125;
      values[5] = values[5] + level*0.125;
      --my_cb_box.fixed[index] = value;
    end
    
    local stilt_tiles = table.copy(bridge_data.tiles)
    stilt_tiles[1] = stilt_tiles[1].."^[transformR90"
    local my_data = {
        description = bridge_data.desc.." "..S("Stilt").." "..level,
        groups = {choppy = 2},
        
        sunlight_propagates = true,
        paramtype = "light",
        paramtype2 = "facedir",
        drawtype = "mesh",
        mesh = "rope_bridges_planks_stilt_l"..lvlcode..".obj",
        tiles = stilt_tiles,
        
        selection_box = my_box;
        collision_box = my_cb_box;
        
        sounds = bridge_data.sounds;
      }
    
    minetest.register_node(bridge_name.."_stilt_l"..lvlcode, my_data);
    
    minetest.register_craft({
        output = bridge_name.."_stilt_l"..get_lvlcode(level+1),
        type = "shapeless",
        recipe = {bridge_name.."_stilt_l"..lvlcode},
      });
  end
  minetest.register_craft({
      output = bridge_name.."_up_l0 2",
      recipe = {
        {"",bridge_name.."_flat_l0"},
        {bridge_name.."_flat_l0", ""}},
    });
  minetest.register_craft({
      output = bridge_name.."_flatup_l0 2",
      recipe = {
        {bridge_name.."_flat_l0", bridge_name.."_up_l0"}},
    });
  minetest.register_craft({
      output = bridge_name.."_flat_l0 2",
      recipe = {
        {bridge_name.."_flatup_l0", bridge_name.."_flatu_l0"}},
    });
  minetest.register_craft({
      output = bridge_name.."_upflat_l0 2",
      recipe = {
        {bridge_name.."_up_l0", bridge_name.."_flat_l0"}},
    });
  minetest.register_craft({
      output = bridge_name.."_flat_l0 2",
      recipe = {
        {bridge_name.."_upflat_l0", bridge_name.."_upflat_l0"}},
    });
  minetest.register_craft({
      output = bridge_name.."_flatupflat_l0 3",
      recipe = {
        {bridge_name.."_flat_l0", bridge_name.."_up_l0", bridge_name.."_flat_l0"}},
    });
  minetest.register_craft({
      output = bridge_name.."_flat_l0 2",
      recipe = {
        {bridge_name.."_flatupflat_l0", bridge_name.."_flatuflat_l0"}},
    });
  
  minetest.register_craft({
      output = bridge_name.."_flat_l0",
      recipe = {
          {bridge_data.recipe_rope, "", bridge_data.recipe_rope},
          {bridge_data.recipe_rope, "", bridge_data.recipe_rope},
          {bridge_data.recipe_rope, bridge_data.recipe_slab, bridge_data.recipe_rope},
        },
    });
  minetest.register_craft({
      output = bridge_name.."_stilt_l0",
      recipe = {
          {bridge_data.recipe_rope, "", bridge_data.recipe_rope},
          {bridge_data.recipe_panel, "", bridge_data.recipe_panel},
          {bridge_data.recipe_rope, "", bridge_data.recipe_rope},
        },
    });
end

local wood_sounds = nil;
if minetest.get_modpath("default") then
  wood_sounds = default.node_sound_wood_defaults();
end
if minetest.get_modpath("hades_sounds") then
  wood_sounds = hades_sounds.node_sound_wood_defaults();
end
if minetest.get_modpath("sounds") then
  wood_sounds = sounds.node_wood();
end

for rope_key,rope_data in pairs(rope_bridges.ropes) do
  for wood_key,wood_data in pairs(rope_bridges.woods) do
    local wood_def = minetest.registered_nodes[wood_data.wood_node]
    if not wood_def then
      error("[rope_bridges] Wood node "..wood_data.wood_node.." is not defined.")
    end
    if not wood_data.texture then
      wood_data.texture = wood_def.tiles[1]
    end
    rope_bridges.register_planks_bridge("rope_bridges:planks_"..wood_key.."_"..rope_key,{
        desc = rope_data.desc.." "..S("Rope Bridge with").." "..wood_data.desc.." ".. S("Planks"),
        tiles = {wood_data.texture, rope_data.texture},
        sounds = wood_def.sounds,
        recipe_rope = rope_data.item,
        recipe_slab = wood_data.recipe_slab,
        recipe_panel = wood_data.recipe_panel,
      })
  end
end

