
local S = minetest.get_translator("skeletons");

-- node box {x=0, y=1, z=0}
local node_box_head = {
  type = "fixed",
  fixed = {
    {-0.0625,-0.5,-0.3125,0.0,-0.3125,-0.25},
    {-0.125,-0.5,-0.25,-0.0625,-0.4375,-0.125},
    {0.0,-0.5,-0.25,0.0625,-0.4375,-0.125},
    {-0.125,-0.375,-0.25,-0.0625,-0.3125,-0.1875},
    {0.0,-0.375,-0.25,0.0625,-0.3125,-0.1875},
    {-0.125,-0.4375,-0.1875,-0.0625,-0.375,-0.125},
    {0.0,-0.4375,-0.1875,0.0625,-0.375,-0.125},
    {-0.1875,-0.3125,-0.1875,-0.125,-0.25,0.0},
    {-0.0625,-0.3125,-0.1875,0.0,-0.25,-0.125},
    {0.0625,-0.3125,-0.1875,0.125,-0.25,0.0},
    {-0.1875,-0.5,-0.125,-0.125,-0.3125,-0.0625},
    {0.0625,-0.5,-0.125,0.125,-0.3125,-0.0625},
    {-0.1875,-0.25,-0.125,0.125,-0.1875,-0.0625},
    {-0.1875,-0.4375,-0.0625,-0.125,-0.3125,0.0625},
    {0.0625,-0.4375,-0.0625,0.125,-0.3125,0.0625},
    {-0.1875,-0.25,-0.0625,-0.125,-0.125,0.0},
    {0.0625,-0.25,-0.0625,0.125,-0.125,0.0},
    {-0.125,-0.1875,-0.0625,0.0625,-0.125,0.0},
    {-0.1875,-0.25,0.0,-0.125,-0.1875,0.0625},
    {0.0625,-0.25,0.0,0.125,-0.1875,0.0625},
    {-0.0625,-0.1875,0.0,0.0,-0.0625,0.0625},
    {-0.1875,-0.125,0.0,-0.0625,-0.0625,0.125},
    {0.0,-0.125,0.0,0.125,-0.0625,0.125},
    {-0.1875,-0.375,0.0625,-0.125,-0.25,0.125},
    {0.0625,-0.375,0.0625,0.125,-0.25,0.125},
    {-0.1875,-0.1875,0.0625,-0.125,-0.125,0.1875},
    {0.0625,-0.1875,0.0625,0.125,-0.125,0.1875},
    {-0.0625,-0.125,0.0625,0.0,-0.0625,0.25},
    {-0.1875,-0.3125,0.125,-0.125,-0.1875,0.1875},
    {0.0625,-0.3125,0.125,0.125,-0.1875,0.1875},
    {-0.1875,-0.125,0.125,-0.125,-0.0625,0.1875},
    {0.0625,-0.125,0.125,0.125,-0.0625,0.1875},
    {-0.125,-0.3125,0.1875,0.0625,-0.25,0.25},
    {-0.125,-0.25,0.1875,-0.0625,-0.125,0.25},
    {0.0,-0.25,0.1875,0.0625,-0.125,0.25},
    {-0.0625,-0.1875,0.1875,0.0,-0.125,0.25},
    {-0.125,-0.375,0.3125,0.0625,-0.3125,0.375},
    {-0.125,-0.3125,0.3125,-0.0625,-0.1875,0.375},
    {0.0,-0.3125,0.3125,0.0625,-0.1875,0.375},
    {-0.0625,-0.25,0.3125,0.0,-0.1875,0.375},
    {-0.125,-0.4375,0.4375,0.0625,-0.375,0.5},
    {-0.125,-0.375,0.4375,-0.0625,-0.25,0.5},
    {0.0,-0.375,0.4375,0.0625,-0.25,0.5},
    {-0.0625,-0.3125,0.4375,0.0,-0.25,0.5},
  },
}
  
-- node box {x=0, y=0, z=1}
local node_box_front_bottom = {
  type = "fixed",
  fixed = {
    {-0.4375,0.25,-0.5,-0.3125,0.375,-0.375},
    {0.25,0.25,-0.5,0.375,0.375,-0.375},
    {-0.375,0.375,-0.5,-0.3125,0.5,-0.4375},
    {0.25,0.375,-0.5,0.3125,0.5,-0.4375},
    {-0.0625,0.0625,-0.4375,0.0,0.125,-0.3125},
    {-0.4375,0.125,-0.4375,-0.3125,0.25,-0.375},
    {0.25,0.125,-0.4375,0.375,0.25,-0.375},
    {-0.4375,0.375,-0.4375,-0.375,0.5,-0.375},
    {0.3125,0.375,-0.4375,0.375,0.5,-0.375},
    {-0.5,-0.5,-0.375,-0.375,-0.375,-0.25},
    {0.3125,-0.5,-0.375,0.4375,-0.375,-0.25},
    {-0.4375,0.0625,-0.375,-0.3125,0.1875,-0.3125},
    {-0.125,0.0625,-0.375,-0.0625,0.125,-0.3125},
    {0.0,0.0625,-0.375,0.0625,0.125,-0.3125},
    {0.25,0.0625,-0.375,0.375,0.1875,-0.3125},
    {-0.5,0.375,-0.375,-0.4375,0.4375,-0.3125},
    {0.375,0.375,-0.375,0.4375,0.4375,-0.3125},
    {-0.4375,0.4375,-0.375,-0.375,0.5,-0.3125},
    {0.3125,0.4375,-0.375,0.375,0.5,-0.3125},
    {-0.5,-0.375,-0.3125,-0.375,-0.1875,-0.1875},
    {0.3125,-0.375,-0.3125,0.4375,-0.1875,-0.1875},
    {-0.5,-0.125,-0.3125,-0.375,0.0625,-0.1875},
    {0.3125,-0.125,-0.3125,0.4375,0.0625,-0.1875},
    {-0.4375,0.0625,-0.3125,-0.3125,0.125,-0.25},
    {-0.25,0.0625,-0.3125,-0.125,0.125,-0.25},
    {0.0625,0.0625,-0.3125,0.1875,0.125,-0.25},
    {0.25,0.0625,-0.3125,0.375,0.125,-0.25},
    {-0.3125,0.125,-0.3125,-0.25,0.25,-0.25},
    {0.1875,0.125,-0.3125,0.25,0.25,-0.25},
    {-0.375,0.25,-0.3125,-0.3125,0.4375,-0.25},
    {0.25,0.25,-0.3125,0.3125,0.4375,-0.25},
    {-0.5,0.4375,-0.3125,-0.4375,0.5,-0.25},
    {-0.3125,0.4375,-0.3125,-0.25,0.5,-0.25},
    {-0.125,0.4375,-0.3125,0.0625,0.5,-0.25},
    {0.1875,0.4375,-0.3125,0.25,0.5,-0.25},
    {0.375,0.4375,-0.3125,0.4375,0.5,-0.25},
    {-0.5,-0.1875,-0.25,-0.375,-0.125,-0.125},
    {0.3125,-0.1875,-0.25,0.4375,-0.125,-0.125},
    {-0.5,0.0625,-0.25,-0.375,0.1875,-0.1875},
    {-0.125,0.0625,-0.25,0.0625,0.125,-0.1875},
    {0.3125,0.0625,-0.25,0.4375,0.1875,-0.1875},
    {-0.3125,0.0625,-0.1875,-0.125,0.125,-0.125},
    {0.0625,0.0625,-0.1875,0.25,0.125,-0.125},
    {-0.375,0.125,-0.1875,-0.3125,0.25,-0.125},
    {0.25,0.125,-0.1875,0.3125,0.25,-0.125},
    {-0.4375,0.25,-0.1875,-0.375,0.4375,-0.125},
    {0.3125,0.25,-0.1875,0.375,0.4375,-0.125},
    {-0.375,0.4375,-0.1875,-0.3125,0.5,-0.125},
    {-0.125,0.4375,-0.1875,0.0625,0.5,-0.125},
    {0.25,0.4375,-0.1875,0.3125,0.5,-0.125},
    {-0.125,0.0625,-0.125,0.0625,0.125,-0.0625},
    {-0.3125,0.125,-0.0625,-0.125,0.1875,0.0},
    {0.0625,0.125,-0.0625,0.25,0.1875,0.0},
    {-0.375,0.1875,-0.0625,-0.3125,0.25,0.0},
    {0.25,0.1875,-0.0625,0.3125,0.25,0.0},
    {-0.4375,0.25,-0.0625,-0.375,0.4375,0.0},
    {0.3125,0.25,-0.0625,0.375,0.4375,0.0},
    {-0.375,0.4375,-0.0625,-0.3125,0.5,0.0},
    {-0.125,0.4375,-0.0625,0.0625,0.5,0.0},
    {0.25,0.4375,-0.0625,0.3125,0.5,0.0},
    {-0.125,0.125,0.0,0.0625,0.1875,0.0625},
    {-0.25,0.125,0.0625,-0.125,0.1875,0.125},
    {0.0625,0.125,0.0625,0.1875,0.1875,0.125},
    {-0.3125,0.1875,0.0625,-0.25,0.3125,0.125},
    {0.1875,0.1875,0.0625,0.25,0.3125,0.125},
    {-0.375,0.3125,0.0625,-0.3125,0.5,0.125},
    {0.25,0.3125,0.0625,0.3125,0.5,0.125},
    {-0.125,0.125,0.125,0.0625,0.1875,0.1875},
    {-0.25,0.1875,0.1875,-0.125,0.25,0.25},
    {0.0625,0.1875,0.1875,0.1875,0.25,0.25},
    {-0.3125,0.25,0.1875,-0.25,0.375,0.25},
    {0.1875,0.25,0.1875,0.25,0.375,0.25},
    {-0.375,0.375,0.1875,-0.3125,0.5,0.25},
    {0.25,0.375,0.1875,0.3125,0.5,0.25},
    {-0.125,0.1875,0.25,0.0625,0.25,0.3125},
    {-0.1875,0.25,0.3125,-0.125,0.3125,0.5},
    {0.0625,0.25,0.3125,0.125,0.3125,0.5},
    {-0.25,0.3125,0.3125,-0.1875,0.375,0.375},
    {0.125,0.3125,0.3125,0.1875,0.375,0.375},
    {-0.3125,0.375,0.3125,-0.25,0.4375,0.375},
    {0.1875,0.375,0.3125,0.25,0.4375,0.375},
    {-0.375,0.4375,0.3125,-0.3125,0.5,0.375},
    {0.25,0.4375,0.3125,0.3125,0.5,0.375},
    {-0.25,0.3125,0.4375,-0.1875,0.4375,0.5},
    {0.125,0.3125,0.4375,0.1875,0.4375,0.5},
    {-0.3125,0.4375,0.4375,-0.25,0.5,0.5},
    {0.1875,0.4375,0.4375,0.25,0.5,0.5},
  },
}
-- node box {x=0, y=0, z=2}
local node_box_back_bottom = {
  type = "fixed",
  fixed = {
    {-0.1875,0.3125,-0.5,-0.125,0.375,-0.375},
    {0.0625,0.3125,-0.5,0.125,0.375,-0.375},
    {-0.25,0.375,-0.4375,-0.1875,0.4375,-0.375},
    {0.125,0.375,-0.4375,0.1875,0.4375,-0.375},
    {-0.3125,0.4375,-0.4375,-0.25,0.5,-0.375},
    {0.1875,0.4375,-0.4375,0.25,0.5,-0.375},
    {-0.375,-0.5,-0.0625,-0.25,-0.375,0.0625},
    {0.1875,-0.5,-0.0625,0.3125,-0.375,0.0625},
    {-0.375,0.0625,0.0,-0.25,0.25,0.125},
    {0.1875,0.0625,0.0,0.3125,0.25,0.125},
    {-0.375,-0.4375,0.0625,-0.25,-0.3125,0.125},
    {0.1875,-0.4375,0.0625,0.3125,-0.3125,0.125},
    {-0.375,-0.125,0.0625,-0.25,0.0625,0.1875},
    {0.1875,-0.125,0.0625,0.3125,0.0625,0.1875},
    {-0.375,0.25,0.0625,-0.25,0.375,0.1875},
    {0.1875,0.25,0.0625,0.3125,0.375,0.1875},
    {-0.375,-0.375,0.125,-0.25,-0.125,0.1875},
    {0.1875,-0.375,0.125,0.3125,-0.125,0.1875},
    {-0.3125,0.4375,0.125,-0.25,0.5,0.3125},
    {0.1875,0.4375,0.125,0.25,0.5,0.3125},
    {-0.375,-0.3125,0.1875,-0.25,-0.125,0.25},
    {0.1875,-0.3125,0.1875,0.3125,-0.125,0.25},
    {-0.125,0.25,0.1875,0.0625,0.3125,0.3125},
    {-0.25,0.3125,0.1875,-0.125,0.375,0.375},
    {0.0625,0.3125,0.1875,0.1875,0.375,0.375},
    {-0.3125,0.375,0.1875,-0.25,0.4375,0.3125},
    {0.1875,0.375,0.1875,0.25,0.4375,0.3125},
    {-0.375,-0.25,0.25,-0.25,-0.1875,0.3125},
    {0.1875,-0.25,0.25,0.3125,-0.1875,0.3125},
    {-0.375,-0.1875,0.3125,-0.25,-0.125,0.375},
    {0.1875,-0.1875,0.3125,0.3125,-0.125,0.375},
    {-0.0625,0.0625,0.4375,0.0,0.5,0.5},
  },
}
-- node box {x=0, y=1, z=1}
local node_box_front_top = {
  type = "fixed",
  fixed = {
    {-0.375,-0.5,-0.4375,-0.3125,-0.4375,-0.375},
    {-0.125,-0.5,-0.4375,0.0625,-0.4375,-0.375},
    {0.25,-0.5,-0.4375,0.3125,-0.4375,-0.375},
    {-0.125,-0.4375,-0.4375,-0.0625,-0.3125,-0.375},
    {0.0,-0.4375,-0.4375,0.0625,-0.3125,-0.375},
    {0.1875,-0.4375,-0.4375,0.25,-0.375,-0.375},
    {-0.0625,-0.375,-0.4375,0.0,-0.25,-0.375},
    {-0.4375,-0.5,-0.375,-0.375,-0.4375,-0.25},
    {0.3125,-0.5,-0.375,0.375,-0.4375,-0.25},
    {-0.375,-0.4375,-0.375,-0.3125,-0.375,-0.25},
    {0.25,-0.4375,-0.375,0.3125,-0.375,-0.25},
    {-0.3125,-0.375,-0.375,-0.25,-0.3125,-0.25},
    {0.1875,-0.375,-0.375,0.25,-0.3125,-0.25},
    {-0.25,-0.3125,-0.375,-0.1875,-0.25,-0.1875},
    {0.125,-0.3125,-0.375,0.1875,-0.25,-0.1875},
    {-0.3125,-0.5,-0.3125,-0.25,-0.4375,-0.25},
    {-0.125,-0.5,-0.3125,-0.0625,-0.375,-0.25},
    {0.0,-0.5,-0.3125,0.0625,-0.375,-0.25},
    {0.1875,-0.5,-0.3125,0.25,-0.4375,-0.25},
    {-0.4375,-0.4375,-0.3125,-0.375,-0.375,-0.1875},
    {-0.25,-0.4375,-0.3125,-0.125,-0.375,-0.25},
    {-0.0625,-0.4375,-0.3125,0.0,-0.25,-0.25},
    {0.0625,-0.4375,-0.3125,0.1875,-0.375,-0.25},
    {0.3125,-0.4375,-0.3125,0.375,-0.375,-0.1875},
    {-0.1875,-0.25,-0.3125,-0.125,-0.1875,-0.0625},
    {0.0625,-0.25,-0.3125,0.125,-0.1875,-0.0625},
    {-0.375,-0.375,-0.25,-0.3125,-0.3125,-0.1875},
    {0.25,-0.375,-0.25,0.3125,-0.3125,-0.1875},
    {-0.3125,-0.3125,-0.25,-0.25,-0.25,-0.0625},
    {0.1875,-0.3125,-0.25,0.25,-0.25,-0.0625},
    {-0.125,-0.25,-0.25,-0.0625,-0.1875,-0.125},
    {0.0,-0.25,-0.25,0.0625,-0.1875,-0.125},
    {-0.375,-0.5,-0.1875,-0.3125,-0.4375,-0.125},
    {-0.125,-0.5,-0.1875,-0.0625,-0.375,-0.125},
    {0.0,-0.5,-0.1875,0.0625,-0.375,-0.125},
    {0.25,-0.5,-0.1875,0.3125,-0.4375,-0.125},
    {-0.3125,-0.4375,-0.1875,-0.125,-0.375,-0.125},
    {-0.0625,-0.4375,-0.1875,0.0,-0.25,-0.125},
    {0.0625,-0.4375,-0.1875,0.25,-0.375,-0.125},
    {-0.4375,-0.375,-0.1875,-0.375,-0.3125,-0.125},
    {0.3125,-0.375,-0.1875,0.375,-0.3125,-0.125},
    {-0.375,-0.3125,-0.1875,-0.3125,-0.25,-0.125},
    {0.25,-0.3125,-0.1875,0.3125,-0.25,-0.125},
    {-0.25,-0.25,-0.1875,-0.1875,-0.1875,-0.0625},
    {0.125,-0.25,-0.1875,0.1875,-0.1875,-0.0625},
    {-0.375,-0.375,-0.125,-0.3125,-0.3125,-0.0625},
    {0.25,-0.375,-0.125,0.3125,-0.3125,-0.0625},
    {-0.375,-0.5,-0.0625,-0.3125,-0.4375,0.0},
    {-0.125,-0.5,-0.0625,-0.0625,-0.375,0.0},
    {0.0,-0.5,-0.0625,0.0625,-0.375,0.0},
    {0.25,-0.5,-0.0625,0.3125,-0.4375,0.0},
    {-0.3125,-0.4375,-0.0625,-0.125,-0.375,0.0},
    {-0.0625,-0.4375,-0.0625,0.0,-0.25,0.0},
    {0.0625,-0.4375,-0.0625,0.25,-0.375,0.0},
    {-0.375,-0.5,0.0625,-0.3125,-0.4375,0.125},
    {-0.125,-0.5,0.0625,0.0625,-0.4375,0.125},
    {0.25,-0.5,0.0625,0.3125,-0.4375,0.125},
    {-0.3125,-0.4375,0.0625,-0.25,-0.375,0.125},
    {-0.125,-0.4375,0.0625,-0.0625,-0.3125,0.125},
    {0.0,-0.4375,0.0625,0.0625,-0.3125,0.125},
    {0.1875,-0.4375,0.0625,0.25,-0.375,0.125},
    {-0.25,-0.375,0.0625,-0.125,-0.3125,0.125},
    {-0.0625,-0.375,0.0625,0.0,-0.25,0.125},
    {0.0625,-0.375,0.0625,0.1875,-0.3125,0.125},
    {-0.375,-0.5,0.1875,-0.3125,-0.4375,0.25},
    {-0.125,-0.5,0.1875,0.0625,-0.4375,0.25},
    {0.25,-0.5,0.1875,0.3125,-0.4375,0.25},
    {-0.3125,-0.4375,0.1875,-0.25,-0.375,0.25},
    {-0.125,-0.4375,0.1875,-0.0625,-0.3125,0.25},
    {0.0,-0.4375,0.1875,0.0625,-0.3125,0.25},
    {0.1875,-0.4375,0.1875,0.25,-0.375,0.25},
    {-0.25,-0.375,0.1875,-0.125,-0.3125,0.25},
    {-0.0625,-0.375,0.1875,0.0,-0.25,0.25},
    {0.0625,-0.375,0.1875,0.1875,-0.3125,0.25},
    {-0.375,-0.5,0.3125,-0.3125,-0.4375,0.375},
    {0.25,-0.5,0.3125,0.3125,-0.4375,0.375},
    {-0.3125,-0.4375,0.3125,-0.25,-0.375,0.375},
    {-0.125,-0.4375,0.3125,0.0625,-0.375,0.375},
    {0.1875,-0.4375,0.3125,0.25,-0.375,0.375},
    {-0.25,-0.375,0.3125,-0.1875,-0.3125,0.375},
    {-0.125,-0.375,0.3125,-0.0625,-0.25,0.375},
    {0.0,-0.375,0.3125,0.0625,-0.25,0.375},
    {0.125,-0.375,0.3125,0.1875,-0.3125,0.375},
    {-0.1875,-0.3125,0.3125,-0.125,-0.25,0.375},
    {-0.0625,-0.3125,0.3125,0.0,-0.25,0.375},
    {0.0625,-0.3125,0.3125,0.125,-0.25,0.375},
    {-0.3125,-0.5,0.4375,-0.25,-0.4375,0.5},
    {0.1875,-0.5,0.4375,0.25,-0.4375,0.5},
    {-0.25,-0.4375,0.4375,-0.1875,-0.3125,0.5},
    {-0.125,-0.4375,0.4375,0.0625,-0.375,0.5},
    {0.125,-0.4375,0.4375,0.1875,-0.3125,0.5},
    {-0.125,-0.375,0.4375,-0.0625,-0.25,0.5},
    {0.0,-0.375,0.4375,0.0625,-0.25,0.5},
    {-0.1875,-0.3125,0.4375,-0.125,-0.25,0.5},
    {-0.0625,-0.3125,0.4375,0.0,-0.25,0.5},
    {0.0625,-0.3125,0.4375,0.125,-0.25,0.5},
  },
}
-- node box {x=0, y=1, z=2}
local node_box_back_top = {
  type = "fixed",
  fixed = {
    {-0.3125,-0.5,-0.4375,-0.25,-0.4375,-0.375},
    {0.1875,-0.5,-0.4375,0.25,-0.4375,-0.375},
    {-0.25,-0.4375,-0.4375,-0.1875,-0.3125,-0.375},
    {-0.125,-0.4375,-0.4375,0.0625,-0.375,-0.375},
    {0.125,-0.4375,-0.4375,0.1875,-0.3125,-0.375},
    {-0.125,-0.375,-0.4375,-0.0625,-0.25,-0.375},
    {0.0,-0.375,-0.4375,0.0625,-0.25,-0.375},
    {-0.1875,-0.3125,-0.4375,-0.125,-0.25,-0.375},
    {-0.0625,-0.3125,-0.4375,0.0,-0.25,-0.375},
    {0.0625,-0.3125,-0.4375,0.125,-0.25,-0.375},
    {-0.125,-0.4375,-0.3125,0.0625,-0.375,-0.25},
    {-0.125,-0.375,-0.3125,-0.0625,-0.25,-0.25},
    {0.0,-0.375,-0.3125,0.0625,-0.25,-0.25},
    {-0.25,-0.3125,-0.3125,-0.125,-0.25,-0.25},
    {-0.0625,-0.3125,-0.3125,0.0,-0.25,-0.25},
    {0.0625,-0.3125,-0.3125,0.1875,-0.25,-0.25},
    {-0.125,-0.4375,-0.1875,0.0625,-0.375,-0.125},
    {-0.125,-0.375,-0.1875,-0.0625,-0.25,-0.125},
    {0.0,-0.375,-0.1875,0.0625,-0.25,-0.125},
    {-0.25,-0.3125,-0.1875,-0.125,-0.25,-0.125},
    {-0.0625,-0.3125,-0.1875,0.0,-0.25,-0.125},
    {0.0625,-0.3125,-0.1875,0.1875,-0.25,-0.125},
    {-0.5,-0.5,-0.0625,-0.4375,-0.1875,0.0},
    {0.375,-0.5,-0.0625,0.4375,-0.1875,0.0},
    {-0.125,-0.4375,-0.0625,0.0625,-0.375,0.0},
    {-0.125,-0.375,-0.0625,-0.0625,-0.25,0.0},
    {0.0,-0.375,-0.0625,0.0625,-0.25,0.0},
    {-0.3125,-0.3125,-0.0625,-0.125,-0.25,0.0},
    {-0.0625,-0.3125,-0.0625,0.0,-0.25,0.0},
    {0.0625,-0.3125,-0.0625,0.25,-0.25,0.0},
    {-0.4375,-0.4375,0.0,-0.375,-0.25,0.0625},
    {0.3125,-0.4375,0.0,0.375,-0.25,0.0625},
    {-0.375,-0.4375,0.0625,-0.3125,-0.25,0.125},
    {-0.125,-0.4375,0.0625,0.0625,-0.375,0.125},
    {0.25,-0.4375,0.0625,0.3125,-0.25,0.125},
    {-0.125,-0.375,0.0625,-0.0625,-0.25,0.125},
    {0.0,-0.375,0.0625,0.0625,-0.25,0.125},
    {-0.25,-0.3125,0.0625,-0.125,-0.25,0.125},
    {-0.0625,-0.3125,0.0625,0.0,-0.25,0.125},
    {0.0625,-0.3125,0.0625,0.1875,-0.25,0.125},
    {-0.3125,-0.25,0.0625,-0.25,-0.1875,0.125},
    {0.1875,-0.25,0.0625,0.25,-0.1875,0.125},
    {-0.3125,-0.5,0.125,-0.25,-0.25,0.1875},
    {0.1875,-0.5,0.125,0.25,-0.25,0.1875},
    {-0.25,-0.25,0.125,-0.125,-0.1875,0.1875},
    {0.0625,-0.25,0.125,0.1875,-0.1875,0.1875},
    {-0.125,-0.4375,0.1875,0.0625,-0.375,0.25},
    {-0.125,-0.375,0.1875,-0.0625,-0.25,0.25},
    {0.0,-0.375,0.1875,0.0625,-0.25,0.25},
    {-0.25,-0.3125,0.1875,-0.125,-0.25,0.25},
    {-0.0625,-0.3125,0.1875,0.0,-0.25,0.25},
    {0.0625,-0.3125,0.1875,0.1875,-0.25,0.25},
    {-0.0625,-0.375,0.25,0.0,-0.3125,0.375},
    {-0.0625,-0.4375,0.375,0.0,-0.375,0.4375},
    {-0.0625,-0.5,0.4375,0.0,-0.4375,0.5},
  },
}

skeletons.register_skeleton("horse_skeleton_head", S("part of horse skeleton"), node_box_head)
skeletons.register_skeleton("horse_skeleton_front_bottom", S("part of horse skeleton"), node_box_front_bottom)
skeletons.register_skeleton("horse_skeleton_front_top", S("part of horse skeleton"), node_box_front_top)
skeletons.register_skeleton("horse_skeleton_back_bottom", S("part of horse skeleton"), node_box_back_bottom)
skeletons.register_skeleton("horse_skeleton_back_top", S("part of horse skeleton"), node_box_back_top)

-- add bone drop
if skeletons.have_horse then
  local entity = minetest.registered_entities["mob_horse:horse"]
  if (not entity) then
    entity = minetest.registered_entities["hades_horse:horse"]
  end

  if entity then
    table.insert(entity.drops, {name = "skeletons:fresh_horse_skeleton_head", chance = 1, min = 1, max = 1})
    table.insert(entity.drops, {name = "skeletons:fresh_horse_skeleton_front_bottom", chance = 1, min = 1, max = 1})
    table.insert(entity.drops, {name = "skeletons:fresh_horse_skeleton_front_top", chance = 1, min = 1, max = 1})
    table.insert(entity.drops, {name = "skeletons:fresh_horse_skeleton_back_bottom", chance = 1, min = 1, max = 1})
    table.insert(entity.drops, {name = "skeletons:fresh_horse_skeleton_back_top", chance = 1, min = 1, max = 1})
  end
end
if skeletons.have_animalia then
  local entity = minetest.registered_entities["animalia:horse"]
  if (not entity) then
    entity = minetest.registered_entities["hades_animalia:horse"]
  end

  if entity then
    table.insert(entity.drops, {name = "skeletons:fresh_horse_skeleton_head", chance = 1, min = 1, max = 1})
    table.insert(entity.drops, {name = "skeletons:fresh_horse_skeleton_front_bottom", chance = 1, min = 1, max = 1})
    table.insert(entity.drops, {name = "skeletons:fresh_horse_skeleton_front_top", chance = 1, min = 1, max = 1})
    table.insert(entity.drops, {name = "skeletons:fresh_horse_skeleton_back_bottom", chance = 1, min = 1, max = 1})
    table.insert(entity.drops, {name = "skeletons:fresh_horse_skeleton_back_top", chance = 1, min = 1, max = 1})
  end
end

