core.register_node("knapping_stones:flint_outcrop", {
    description = "Flint Outcrop",
    drawtype = "mesh",
    drop = "mcl_core:flint",
    groups = { handy = 1, dig_immediate = 3, attached_node = 1 },
    inventory_image = "flint_outcrop_texture.png",
    mesh = "flint_outcrop.gltf",
    paramtype = "light",
    paramtype2 = "facedir",
    selection_box = {
        type = "fixed",
        fixed = { -0.35, -0.5, -0.35, 0.35, -0.3125, 0.35 },
    },
    collision_box = {
        type = "fixed",
        fixed = { -5 / 16, -8 / 16, -6 / 16, 5 / 16, -6 / 16, 5 / 16 },
    },
    sunlight_propagates = true,
    tiles = { "flint_outcrop_texture.png" },
    --tiles = { "rock_texture2.png", "rock_texture.png" },
    walkable = true,
    sounds = mcl_sounds.node_sound_gravel_defaults(),
})

core.register_decoration({
    decoration = {
        "knapping_stones:flint_outcrop",
    },
    place_on = {
        "mcl_core:dirt_with_grass",
        "mcl_core:gravel",
        "mcl_core:stone",
        "mcl_core:sand",
        "mcl_core:cobble",
        "mcl_core:mossycobble",
        "mcl_core:water_source",
        "mcl_core:river_water_source",
    },
    noise_params = {
        offset = 0,
        scale = 0.001,
        spread = {
            y = 50,
            z = 50,
            x = 50
        },
        seed = 0,
        octaves = 5,
        persist = 0.8,
        flags = "absvalue",
        lacunarity = 5
    },
    param2 = 0,
    flags = "all_floors",
    deco_type = "simple",
    param2_max = 3,
    y_min = 1,
    y_max = mcl_vars.mg_overworld_max,
})
