local tools = {
    -- flint items have the same stats as wooden ones
    pick_flint = {
        title = 'Flint Pickaxe',
        inventory_image = 'flint_pick',
        tool_type = 'pick',
        texture = 'flint_obj',
        input = "mcl_core:flint",
        tool_capabilities = {
            full_punch_interval = 0.83333333,
            max_drop_level = 1,
            damage_groups = { fleshy = 2 },
            punch_attack_uses = 30,
        },
        _mcl_diggroups = {
            pickaxey = { speed = 2, level = 1, uses = 60 }
        },
        replaces = "mcl_tools:pick_wood"
    },
    axe_flint = {
        title = 'Flint Axe',
        inventory_image = 'flint_axe',
        tool_type = 'axe',
        texture = 'flint_obj',
        input = "mcl_core:flint",
        tool_capabilities = {
            full_punch_interval = 1.25,
            max_drop_level = 1,
            damage_groups = { fleshy = 7 },
            punch_attack_uses = 30,
        },
        _mcl_diggroups = {
            axey = { speed = 2, level = 1, uses = 60 }
        },
        replaces = "mcl_tools:axe_wood"
    },
    shovel_flint = {
        title = 'Flint Shovel',
        inventory_image = 'flint_shovel',
        tool_type = 'shovel',
        texture = 'flint_obj',
        input = "mcl_core:flint",
        tool_capabilities = {
            full_punch_interval = 1,
            max_drop_level = 1,
            damage_groups = { fleshy = 2 },
            punch_attack_uses = 30,
        },
        _mcl_diggroups = {
            shovely = { speed = 2, level = 2, uses = 60 }
        },
        replaces = "mcl_tools:shovel_wood"
    },
    sword_flint = {
        title = 'Flint Sword',
        inventory_image = 'flint_sword',
        tool_type = 'sword',
        texture = 'flint_obj',
        input = "mcl_core:flint",
        tool_capabilities = {
            full_punch_interval = 0.625,
            max_drop_level = 1,
            damage_groups = { fleshy = 4 },
            punch_attack_uses = 60,
        },
        _mcl_diggroups = {
            swordy = { speed = 2, level = 1, uses = 60 },
            swordy_cobweb = { speed = 2, level = 1, uses = 60 }
        },
        replaces = "mcl_tools:sword_wood"
    },
    -- granite tools have the same stats as stone
    pick_granite = {
        title = 'Granite Pickaxe',
        inventory_image = 'granite_pick',
        tool_type = 'pick',
        texture = 'granite_obj',
        input = "mcl_core:granite",
        tool_capabilities = {
            full_punch_interval = 0.83333333,
            max_drop_level = 3,
            damage_groups = { fleshy = 3 },
            punch_attack_uses = 66,
        },
        _mcl_diggroups = {
            pickaxey = { speed = 4, level = 3, uses = 132 }
        },
        replaces = "mcl_tools:pick_stone"
    },
    axe_granite = {
        title = 'Granite Axe',
        inventory_image = 'granite_axe',
        tool_type = 'axe',
        texture = 'granite_obj',
        input = "mcl_core:granite",
        tool_capabilities = {
            full_punch_interval = 1.25,
            max_drop_level = 3,
            damage_groups = { fleshy = 9 },
            punch_attack_uses = 66,
        },
        _mcl_diggroups = {
            axey = { speed = 4, level = 3, uses = 132 }
        },
        replaces = "mcl_tools:axe_stone"
    },
    shovel_granite = {
        title = 'Granite Shovel',
        inventory_image = 'granite_shovel',
        tool_type = 'shovel',
        texture = 'granite_obj',
        input = "mcl_core:granite",
        tool_capabilities = {
            full_punch_interval = 1,
            max_drop_level = 3,
            damage_groups = { fleshy = 3 },
            punch_attack_uses = 66,
        },
        _mcl_diggroups = {
            shovely = { speed = 4, level = 3, uses = 132 }
        },
        replaces = "mcl_tools:shovel_stone"
    },
    sword_granite = {
        title = 'Granite Sword',
        inventory_image = 'granite_sword',
        tool_type = 'sword',
        texture = 'granite_obj',
        input = "mcl_core:granite",
        tool_capabilities = {
            full_punch_interval = 0.625,
            max_drop_level = 3,
            damage_groups = { fleshy = 5 },
            punch_attack_uses = 132,
        },
        _mcl_diggroups = {
            swordy = { speed = 4, level = 3, uses = 132 },
            swordy_cobweb = { speed = 4, level = 3, uses = 132 }
        },
        replaces = "mcl_tools:sword_stone"
    },
}

for toolName, toolDef in pairs(tools) do
    local head_item_id = "knapping_voxelibre:" .. toolName .. "_head"
    local tool_id = 'knapping_voxelibre:' .. toolName

    core.register_craftitem(head_item_id, {
        description = "Knapped " .. toolDef.title .. " Head",
        inventory_image = toolDef.inventory_image .. "_head.png",
    })

    knapping_voxelibre_core.register_recipe({
        input = toolDef.input,
        output = head_item_id,
        recipe = knapping_voxelibre_core.default_recipes[toolDef.tool_type],
        texture = toolDef.texture .. ".png"
    })

    if toolDef.replaces then
        core.clear_craft({
            output = toolDef.replaces,
        })
        -- copy the old tool's properties if it exists
        local oldToolDef = core.registered_items[toolDef.replaces]
        --core.log(dump(oldToolDef))

        -- initialize the new tool with the old tool's properties
        local updatedToolDef = table.copy(oldToolDef)
        updatedToolDef.description = toolDef.title
        updatedToolDef.inventory_image = toolDef.inventory_image .. ".png"
        updatedToolDef.wield_image = is_shovel and (toolDef.inventory_image .. ".png^[transformR90") or
            (toolDef.inventory_image .. ".png")

        core.register_tool(tool_id, updatedToolDef)
    else
        local is_shovel = string.find(toolName, "shovel")
        core.register_tool(tool_id, {
            description = toolDef.title,
            inventory_image = toolDef.inventory_image .. ".png",
            wield_image = is_shovel and (toolDef.inventory_image .. ".png^[transformR90") or
                (toolDef.inventory_image .. ".png"),
            tool_capabilities = toolDef.tool_capabilities,
            _mcl_toollike_wield = true,
            _mcl_diggroups = toolDef._mcl_diggroups,
            sound = { breaks = "default_tool_breaks" },
        })
    end

    core.register_craft({
        output = tool_id,
        type = 'shaped',
        recipe = {
            { head_item_id },
            { 'group:stick' }
        }
    })
end

--[[
core.clear_craft({
    output = "mcl_core:pick_wood",
})
core.clear_craft({
    output = "mcl_core:axe_wood",
})
core.clear_craft({
    output = "mcl_core:shovel_wood",
})
core.clear_craft({
    output = "mcl_core:hoe_wood",
})
core.clear_craft({
    output = "mcl_core:sword_wood",
})

core.clear_craft({
    output = "mcl_core:pick_stone",
})
core.clear_craft({
    output = "mcl_core:axe_stone",
})
core.clear_craft({
    output = "mcl_core:shovel_stone",
})
core.clear_craft({
    output = "mcl_core:hoe_stone",
})
core.clear_craft({
    output = "mcl_core:sword_stone",
})
]]


--[[
core.override_item("mcl_core:dirt", {
    after_dig_node = function(pos, oldnode, oldmetadata, digger)
        -- 50% chance to drop a loose granite stone when any tool digs dirt
        if math.random() < 0.50 then
            core.add_item(pos, "mcl_core:flint")
        end
        -- Also ensure default dirt drop happens if it's not handled automatically by default mod
        -- minetest.add_item(pos, "default:dirt")
    end
})
]]

for node_name, node_def in pairs(minetest.registered_nodes) do
    -- restrict the player's ability to break things with his hands by removing digging groups
    -- keep handy so that the player can still break things that are intended to be easily breakable
    if string.find(node_name, "mcl_meshhand") then
        --node_def._mcl_diggroups.handy = nil
        node_def._mcl_diggroups.axey = nil
        node_def._mcl_diggroups.shovely = nil
        --node_def._mcl_diggroups.hoey = nil
        node_def._mcl_diggroups.pickaxey = nil
    end

    -- make trees and stone unpunchable by removing handy
    -- remove handy from nodes, but only if they already have a tool-based way to break them
    local is_handy = node_def.groups and node_def.groups.handy
    local is_block = node_def.groups and (node_def.groups.building_block or node_def.groups.deco_block)
    local is_diggable = node_def.groups and (node_def.groups.axey or node_def.groups.shovely or node_def.groups.pickaxey)
    if is_handy and is_block and is_diggable then
        node_def.groups.handy = nil
    end
end
