# Everness Mapgen [everness]

Everness is a mapgen, which aims to provide an endless array of
beautiful biomes from the surface lands to the caverns with custom-painted
textures. It creates both a sense of discovery and of danger when one lands in the wrong biome.
It also adds structures, dungeons with loot chests, and custom skyboxes based on the biome.

![screenshot](screenshot.png)

## Features

* player name tag will hide when sneaking
* item magnet pickup when holding sneak
* granular biome settings
* custom sounds for some blocks, biomes
* custom textures
* custom biomes and cavern biomes
* custom tools, blocks
* custom skyboxes based on biome
* inlcudes (not for all) e.g. walls, doors, glass, stairs, vines, tools, panes, trees...

## Biomes

Additionally adds extra biomes to the MT game default biomes:

* Coral Forest
* Coral Forest Dunes
* Coral Forest Ocean
* Coral Forest Under
* Frosted Icesheet
* Frosted Icesheet Ocean
* Frosted Icesheet Under
* Cursed Lands
* Cursed Lands Dunes
* Cursed Lands Swamp
* Cursed Lands Ocean
* Cursed Lands Under
* Crystal Forest
* Crystal Forest Dunes
* Crystal Forest Shore
* Crystal Forest Ocean
* Crystal Forest Under
* Bamboo Forest
* Bamboo Forest Under
* Forsaken Desert
* Forsaken Desert Ocean
* Forsaken Desert Under
* Baobab Savanna
* Forsaken Tundra
* Forsaken Tundra Beach
* Forsaken Tundra Ocean
* Forsaken Tundra Under

## Wiki

https://bitbucket.org/minetest_gamers/everness/wiki/Home

## Report Bugs/Suggestions

https://bitbucket.org/minetest_gamers/everness/issues

## Dependencies

- default

## Optional Dependencies

- xpanes
- doors
- stairs
- walls
- x_obsidianmese (for paths)
- x_tumbleweed (adds tumbleweeds to deserts)
- x_farming (bonemeal, recipes...)

## License

see included [LICENSE.txt](LICENSE.txt) file for more info

## Installation

see: https://wiki.minetest.net/Installing_Mods
