---@diagnostic disable: codestyle-check
---https://github.com/sumneko/lua-language-server/wiki

------All `vector.*` functions allow vectors `{x = X, y = Y, z = Z}` without metatables. Returned vectors always have a metatable set.
---@class Vector
---@field x integer|number Pitch
---@field y integer|number Yaw
---@field z integer|number Roll
---@field multiply fun(v: Vector, s: number|integer): Vector Returns a scaled vector. Deprecated: If `s` is a vector: Returns the Schur product.
---@field subtract fun(v: Vector, x: number|integer|Vector): Vector Returns a vector. If `x` is a vector: Returns the difference of `v` subtracted by `x`. If `x` is a number: Subtracts `x` from each component of `v`.
---@field add fun(v: Vector, x: number|integer|Vector): Vector Returns a vector. If `x` is a vector: Returns the sum of `v` and `x`. If `x` is a number: Adds `x` to each component of `v`.
---@field normalize fun(v: Vector): Vector Returns a vector of length 1 with direction of vector `v`. If `v` has zero length, returns `(0, 0, 0)`.
---@field distance fun(p1: Vector, p2: Vector): number|integer Returns zero or a positive number, the distance between `p1` and `p2`.
---@field round fun(v: Vector): Vector Returns a vector, each dimension rounded to nearest integer. At a multiple of 0.5, rounds away from zero.
---@field new fun(a, b?, c?): Vector Returns a new vector `(a, b, c)`.
---@field direction fun(p1: Vector, p2: Vector): Vector Returns a vector of length 1 with direction `p1` to `p2`. If `p1` and `p2` are identical, returns `(0, 0, 0)`.
---@field divide fun(v: Vector, s: Vector | number): Vector Returns a scaled vector. Deprecated: If `s` is a vector: Returns the Schur quotient.
