XBows:register_bow('bow_training', {
    description = 'Training Bow',
    inventory_image = 'x_bows_extras_bow_training.png',
    custom = {
        inventory_image_charged = 'x_bows_extras_bow_training_charged.png',
        uses = 385,
        crit_chance = 5,
        recipe = {
            {'', 'group:orange', 'farming:string'},
            {'group:orange', '', 'farming:string'},
            {'', 'group:orange', 'farming:string'}
        },
        fuel_burntime = 5,
        mod_name = 'x_bows_extras',
        allowed_ammunition = {
            'x_bows_extras:arrow_training',
            'x_bows_extras:arrow_rip',
            'x_bows_extras:arrow_flyup',
            'x_bows_extras:arrow_cluster',
            'x_bows_extras:arrow_torch',
            'x_bows_extras:arrow_teleport',
            'x_bows_extras:arrow_healing',
            'x_bows_extras:arrow_knockback',
            'x_bows_extras:arrow_diamond_tipped_poison'
        }
    }
})

XBows:register_bow('bubble_gun', {
    description = 'Bubble gun',
    inventory_image = 'x_bows_extras_bubble_gun.png',
    wield_image = 'x_bows_extras_bubble_gun.png^[transformFX',
    custom = {
        inventory_image_charged = 'x_bows_extras_bubble_gun_charged.png',
        wield_image_charged = 'x_bows_extras_bubble_gun_charged.png^[transformFX',
        uses = 385,
        recipe = {
            {'', 'wool:blue', 'farming:string'},
            {'wool:blue', '', 'farming:string'},
            {'', 'wool:blue', 'farming:string'}
        },
        fuel_burntime = 5,
        mod_name = 'x_bows_extras',
        strength_min = 1,
        strength_max = 4,
        acc_x_min = -2,
        acc_y_min = -2,
        acc_z_min = -2,
        acc_x_max = 2,
        acc_y_max = 2,
        acc_z_max = 2,
        allowed_ammunition = {'x_bows_extras:bubble_gun_bubble'},
        sound_load = 'x_bows_extras_bubble_gun_shot',
        sound_hit = 'x_bows_extras_bubble_gun_pop',
        sound_shoot = 'x_bows_extras_bubble_gun_shot',
        sound_shoot_crit = 'x_bows_extras_bubble_gun_shot',
    }
})


XBows:register_bow('bazooka', {
    description = 'Bazooka',
    inventory_image = 'x_bows_extras_bazooka.png',
    wield_image = 'x_bows_extras_bazooka.png^[transformFX',
    custom = {
        inventory_image_charged = 'x_bows_extras_bazooka_charged.png',
        wield_image_charged = 'x_bows_extras_bazooka_charged.png^[transformFX',
        uses = 385,
        recipe = {
            {'', 'wool:black', 'farming:string'},
            {'wool:black', '', 'farming:string'},
            {'', 'wool:black', 'farming:string'}
        },
        mod_name = 'x_bows_extras',
        allowed_ammunition = {'x_bows_extras:bazooka_bullet'},
        gravity = -0.5,
        strength = 150,
    }
})

XBows:register_arrow('bazooka_bullet', {
    description = 'Bazooka bullet',
    inventory_image = 'x_bows_extras_bazooka_bullet.png',
    wield_image = 'x_bows_extras_bazooka_bullet.png',
    custom = {
        recipe = {
            {'wool:black'},
            {'group:stick'},
            {'farming:string'}
        },
        tool_capabilities = {
            full_punch_interval = 1.2,
            max_drop_level = 0,
            damage_groups = {fleshy=16}
        },
        mod_name = 'x_bows_extras',
        projectile_textures = {'x_bows_extras:bazooka_bullet_node'},
        projectile_visual_size = {x = 0.2, y = 0.2, z = 0.2},
        projectile_entity = 'x_bows_extras:bazooka_entity',
        on_hit_node = function(self)
            local pos = self.object:get_pos()

            self.object:remove()

            if minetest.get_modpath('tnt') then
                tnt.boom(pos, {
                    radius = 5
                })
            else
                minetest.chat_send_player(self._user_name, 'TNT mod is disabled. No explosion will happen.')
            end
        end,
        on_hit_player = function(self)
            local pos = self.object:get_pos()

            self.object:remove()

            if minetest.get_modpath('tnt') then
                tnt.boom(pos, {
                    radius = 5
                })
            else
                minetest.chat_send_player(self._user_name, 'TNT mod is disabled. No explosion will happen.')
            end
        end,
        on_hit_entity = function(self)
            local pos = self.object:get_pos()

            self.object:remove()

            if minetest.get_modpath('tnt') then
                tnt.boom(pos, {
                    radius = 5
                })
            else
                minetest.chat_send_player(self._user_name, 'TNT mod is disabled. No explosion will happen.')
            end
        end
    }
})

XBows:register_arrow('bubble_gun_bubble', {
    description = 'Bubbles',
    inventory_image = 'x_bows_extras_bubble_gun_bubble.png',
    wield_image = 'x_bows_extras_bubble_gun_bubble.png',
    custom = {
        recipe = {
            {'group:water_bucket'},
            {'group:stick'},
            {'farming:string'}
        },
        tool_capabilities = {
            full_punch_interval = 0.4,
            max_drop_level = 0,
            damage_groups = {fleshy=0}
        },
        mod_name = 'x_bows_extras',
        particle_effect = 'x_bows_extras_bubble_gun_bubble',
        particle_effect_crit = 'x_bows_extras_bubble_gun_bubble',
        particle_effect_fast = 'x_bows_extras_bubble_gun_bubble',
        projectile_textures = {'x_bows_extras:bubble_node'},
        projectile_visual_size = {x = 0.2, y = 0.2, z = 0.2},
        projectile_entity = 'x_bows_extras:bubble_entity'
    }
})

XBows:register_arrow('arrow_training', {
    description = 'Arrow Training',
    inventory_image = 'x_bows_extras_arrow_training.png',
    wield_image = 'x_bows_extras_arrow_training.png',
    custom = {
        recipe = {
            {'default:flint'},
            {'group:stick'},
            {'wool:orange'}
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 0,
            damage_groups = {fleshy=0}
        },
        fuel_burntime = 2,
        mod_name = 'x_bows_extras'
    }
})

XBows:register_arrow('arrow_rip', {
    description = 'Arrow R.I.P.',
    inventory_image = 'x_bows_extras_arrow_rip.png',
    wield_image = 'x_bows_extras_arrow_rip.png',
    custom = {
        recipe = {
            {'default:flint'},
            {'group:stick'},
            {'wool:black'}
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 0,
            damage_groups = {fleshy=0}
        },
        fuel_burntime = 2,
        mod_name = 'x_bows_extras',
        on_hit_player = function(self, pointed_thing)
            local pos = pointed_thing.ref:get_pos()
            local nodes = {}
            self.object:remove()

            for i = 1, 5 do
                for j = 1, 3 do
                    for k = 1, 3 do
                        local px = {x = (pos.x - 2) + j, y = pos.y - i, z = (pos.z - 2) + k}
                        local pz = {x = (pos.x - 2) + k, y = pos.y - i, z = (pos.z - 2) + j}
                        local nx = minetest.get_node(px)
                        local nz = minetest.get_node(pz)
                        table.insert(nodes, {
                            pos = px,
                            node = nx
                        })

                        table.insert(nodes, {
                            pos = pz,
                            node = nz
                        })
                    end
                end
            end

            for i,v in ipairs(nodes) do
                minetest.set_node(v.pos, {name = 'air'})
            end

            minetest.after(1, function(v_nodes)
                for i,v in ipairs(v_nodes) do
                    minetest.set_node(v.pos, v.node)
                end
            end, nodes)
        end,
        on_hit_entity = function(self, pointed_thing)
            local pos = pointed_thing.ref:get_pos()
            local nodes = {}
            self.object:remove()

            for i = 1, 5 do
                for j = 1, 3 do
                    for k = 1, 3 do
                        local px = {x = (pos.x - 2) + j, y = pos.y - i, z = (pos.z - 2) + k}
                        local pz = {x = (pos.x - 2) + k, y = pos.y - i, z = (pos.z - 2) + j}
                        local nx = minetest.get_node(px)
                        local nz = minetest.get_node(pz)
                        table.insert(nodes, {
                            pos = px,
                            node = nx
                        })

                        table.insert(nodes, {
                            pos = pz,
                            node = nz
                        })
                    end
                end
            end

            for i,v in ipairs(nodes) do
                minetest.set_node(v.pos, {name = 'air'})
            end

            minetest.after(1, function(v_nodes)
                for i,v in ipairs(v_nodes) do
                    minetest.set_node(v.pos, v.node)
                end
            end, nodes)
        end
    }
})

XBows:register_arrow('arrow_flyup', {
    description = 'Arrow fly up.',
    inventory_image = 'x_bows_extras_arrow_flyup.png',
    wield_image = 'x_bows_extras_arrow_flyup.png',
    custom = {
        recipe = {
            {'default:flint'},
            {'group:stick'},
            {'wool:green'}
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 0,
            damage_groups = {fleshy=0}
        },
        fuel_burntime = 2,
        mod_name = 'x_bows_extras',
        on_hit_player = function(self, pointed_thing)
            local pos = pointed_thing.ref:get_pos()
            self.object:remove()
            pointed_thing.ref:move_to({x = pos.x, y = pos.y + 7, z = pos.z})
        end,
        on_hit_entity = function(self, pointed_thing)
            local pos = pointed_thing.ref:get_pos()
            self.object:remove()
            pointed_thing.ref:move_to({x = pos.x, y = pos.y + 7, z = pos.z}, true)
        end
    }
})


XBows:register_arrow('arrow_cluster', {
    description = 'Arrow cluster.',
    inventory_image = 'x_bows_extras_arrow_cluster.png',
    wield_image = 'x_bows_extras_arrow_cluster.png',
    custom = {
        recipe = {
            {'x_bows:arrow_wood', 'default:flint', 'x_bows:arrow_wood'},
            {'x_bows:arrow_wood', 'group:stick', 'x_bows:arrow_wood'},
            {'x_bows:arrow_wood', 'farming:string', 'x_bows:arrow_wood'}
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 0,
            damage_groups = {fleshy=0}
        },
        fuel_burntime = 2,
        mod_name = 'x_bows_extras',
        on_after_activate = function(self)
            if self._arrow_name ~= 'x_bows_extras:arrow_cluster' then
                return
            end

            minetest.after(0.5, function(v_self)
                if v_self._attached then
                    return
                end

                local angle = math.random(0, math.pi*2)
                local angle2 = math.random(0, math.pi*2)
                local posadd
                local positions = {}

                for i = 1, 8 do
                    posadd = {x = math.cos(angle), y = 0, z = math.sin(angle)}
                    posadd = vector.normalize(posadd)

                    table.insert(positions, {
                        added = false,
                        pos = vector.add(v_self._old_pos, posadd)
                    })

                    angle = angle + math.pi / 4
                end

                local newpostoadd = {}

                for k, val in ipairs(positions) do
                    if val.added == false then
                        for l = 1, 8 do
                            posadd = {x = math.cos(angle2), y = 0, z = math.sin(angle2)}
                            posadd = vector.normalize(posadd)

                            table.insert(newpostoadd, {
                                added = false,
                                pos = vector.add(val.pos, posadd)
                            })

                            angle2 = angle2 + math.pi / 4
                        end
                        val.added = true
                    end
                end

                for q=1, #newpostoadd do
                    table.insert(positions, newpostoadd[q])
                end

                for _, v in ipairs(positions) do
                    local arrow = minetest.add_entity(
                        v.pos,
                        'x_bows:arrow_entity',
                        minetest.serialize({
                            _arrow_name = 'x_bows:arrow_wood',
                            _bow_name = v_self._bow_name,
                            user_name = v_self._user_name,
                            is_critical_hit = v_self._is_critical_hit,
                            _tool_capabilities = {
                                full_punch_interval = 0.7,
                                max_drop_level = 0,
                                damage_groups = {fleshy=2}
                            },
                            _tflp = 1,
                            _add_damage = 0
                        }))

                    if arrow then
                        local parent_props = v_self.object:get_properties()
                        local parent_vel = v_self.object:get_velocity()
                        local parent_acc = v_self.object:get_acceleration()
                        local parent_yaw = v_self.object:get_yaw()

                        arrow:set_properties(parent_props)
                        arrow:set_velocity(parent_vel)
                        arrow:set_acceleration(parent_acc)
                        arrow:set_yaw(parent_yaw)
                    end
                end
            end, self)
        end
    }
})

XBows:register_arrow('arrow_torch', {
    description = 'Torch arrow',
    inventory_image = 'x_bows_extras_arrow_torch.png',
    wield_image = 'x_bows_extras_arrow_torch.png',
    custom = {
        recipe = {
            {'default:torch'},
            {'group:stick'},
            {'farming:string'}
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 0,
            damage_groups = {fleshy=2}
        },
        mod_name = 'x_bows_extras',
        on_hit_node = function(self, pointed_thing)
            local under = pointed_thing.under
            local above = pointed_thing.above
            local wdir = minetest.dir_to_wallmounted(vector.subtract(under, above))
            local player = minetest.get_player_by_name(self._user_name)

            self.object:remove()

            if wdir == 0 then
                minetest.item_place_node(ItemStack({name = 'default:torch_ceiling'}), player, pointed_thing, wdir)
            elseif wdir == 1 then
                minetest.item_place_node(ItemStack({name = 'default:torch'}), player, pointed_thing, wdir)
            else
                minetest.item_place_node(ItemStack({name = 'default:torch_wall'}), player, pointed_thing, wdir)
            end

            minetest.sound_play('default_place_node_hard', {pos = above, gain = 1.0, max_hear_distance = 10})
        end
    }
})

XBows:register_arrow('arrow_teleport', {
    description = 'Teleport arrow',
    inventory_image = 'x_bows_extras_arrow_teleport.png',
    wield_image = 'x_bows_extras_arrow_teleport.png',
    custom = {
        recipe = {
            {'default:mese'},
            {'default:mese'},
            {'farming:string'}
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 0,
            damage_groups = {fleshy=2}
        },
        mod_name = 'x_bows_extras',
        on_hit_player = function(self, pointed_thing)
            local player = minetest.get_player_by_name(self._user_name)
            local p_pos = player:get_pos()
            local e_pos = pointed_thing.ref:get_pos()

            player:move_to(e_pos)
            pointed_thing.ref:move_to(p_pos)
        end,
        on_hit_entity = function(self, pointed_thing)
            local player = minetest.get_player_by_name(self._user_name)
            local p_pos = player:get_pos()
            local e_pos = pointed_thing.ref:get_pos()

            player:move_to(e_pos)
            pointed_thing.ref:move_to(p_pos)
        end,
        on_hit_node = function(self, pointed_thing)
            local player = minetest.get_player_by_name(self._user_name)
            player:move_to(pointed_thing.above)
        end
    }
})

XBows:register_arrow('arrow_knockback', {
    description = 'Knockback arrow',
    inventory_image = 'x_bows_extras_arrow_knockback.png',
    wield_image = 'x_bows_extras_arrow_knockback.png',
    custom = {
        recipe = {
            {'farming:bread'},
            {'default:stick'},
            {'farming:string'}
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 0,
            damage_groups = {fleshy=2}
        },
        mod_name = 'x_bows_extras',
        on_hit_player = function(self, pointed_thing)
            local _caused_knockback = self._caused_knockback
            local ip_pos = pointed_thing.intersection_point
            local dir = vector.normalize(vector.subtract(self._shot_from_pos, ip_pos))

            pointed_thing.ref:add_velocity({
                x = dir.x * (_caused_knockback * 10) * -1,
                y = 17,
                z = dir.z * (_caused_knockback * 10) * -1
            })
        end,
        on_hit_entity = function(self, pointed_thing)
            local _caused_knockback = self._caused_knockback
            local ip_pos = pointed_thing.intersection_point
            local dir = vector.normalize(vector.subtract(self._shot_from_pos, ip_pos))

            pointed_thing.ref:add_velocity({
                x = dir.x * (_caused_knockback * 10) * -1,
                y = 17,
                z = dir.z * (_caused_knockback * 10) * -1
            })
        end
    }
})

XBows:register_arrow('arrow_healing', {
    description = 'Healing arrow',
    inventory_image = 'x_bows_extras_arrow_healing.png',
    wield_image = 'x_bows_extras_arrow_healing.png',
    custom = {
        recipe = {
            {'farming:bread'},
            {'default:stick'},
            {'farming:string'}
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 0,
            damage_groups = {fleshy=2}
        },
        mod_name = 'x_bows_extras',
        on_hit_player = function(self, pointed_thing)
            local _caused_damage = self._caused_damage
            local player = minetest.get_player_by_name(self._user_name)
            player:set_hp(player:get_hp() + _caused_damage, {type='set_hp', description='Healed from healing arrow.'})
        end,
        on_hit_entity = function(self, pointed_thing)
            local _caused_damage = self._caused_damage
            local player = minetest.get_player_by_name(self._user_name)
            player:set_hp(player:get_hp() + _caused_damage, {type='set_hp', description='Healed from healing arrow.'})
        end
    }
})
