XBows:register_bow('bazooka', {
    description = 'Bazooka',
    inventory_image = 'x_bows_extras_bazooka.png',
    wield_image = 'x_bows_extras_bazooka.png^[transformFX',
    custom = {
        inventory_image_charged = 'x_bows_extras_bazooka_charged.png',
        wield_image_charged = 'x_bows_extras_bazooka_charged.png^[transformFX',
        uses = 385,
        recipe = {
            {'', 'wool:black', 'farming:string'},
            {'wool:black', '', 'farming:string'},
            {'', 'wool:black', 'farming:string'}
        },
        mod_name = 'x_bows_extras',
        allowed_ammunition = {'x_bows_extras:bazooka_bullet'},
        gravity = -0.5,
        strength = 150,
        sound_load = 'x_bows_extras_bazooka_load',
        sound_hit = '',
        sound_shoot = 'x_bows_extras_bazooka_shot',
        sound_shoot_crit = 'x_bows_extras_bazooka_shot'
    }
})

---Boom
---@param self table
---@param pointed_thing PointedThingDef
local function hit(self, pointed_thing)
    local ip_pos = pointed_thing.intersection_point

    self.object:remove()

    if minetest.get_modpath('tnt') then
        tnt.boom(ip_pos, {
            radius = 5
        })

        return
    end

    minetest.chat_send_player(self._user_name, 'TNT mod is disabled. No explosion will happen.')
end

XBows:register_arrow('bazooka_bullet', {
    description = 'Bazooka bullet',
    inventory_image = 'x_bows_extras_bazooka_bullet.png',
    wield_image = 'x_bows_extras_bazooka_bullet.png',
    custom = {
        recipe = {
            {'wool:black'},
            {'group:stick'},
            {'farming:string'}
        },
        tool_capabilities = {
            full_punch_interval = 1.2,
            max_drop_level = 0,
            damage_groups = {fleshy=16}
        },
        mod_name = 'x_bows_extras',
        projectile_textures = {'x_bows_extras:bazooka_bullet_node'},
        projectile_visual_size = {x = 0.2, y = 0.2, z = 0.2},
        projectile_entity = 'x_bows_extras:bazooka_entity',
        on_hit_node = hit,
        on_hit_player = hit,
        on_hit_entity = hit
    }
})

XBows:register_entity('bazooka_entity', {
    _custom = {
        mod_name = 'x_bows_extras'
    }
})
