---Bury
---@param self table
---@param pointed_thing PointedThingDef
local function bury(self, pointed_thing)
    local pos = pointed_thing.ref:get_pos()
    local nodes = {}
    self.object:remove()

    ---y
    for i = 1, 5 do
        ---z
        for j = 1, 3 do
            ---x
            for k = 1, 3 do
                local px = {x = (pos.x - 2) + j, y = pos.y - i, z = (pos.z - 2) + k}
                local pz = {x = (pos.x - 2) + k, y = pos.y - i, z = (pos.z - 2) + j}
                local nx = minetest.get_node(px)
                local nz = minetest.get_node(pz)

                if nx.name ~= 'air' then
                    table.insert(nodes, {
                        pos = px,
                        node = nx
                    })
                end

                if nz.name ~= 'air' then
                    table.insert(nodes, {
                        pos = pz,
                        node = nz
                    })
                end

                minetest.set_node(px, {name = 'air'})
                minetest.set_node(pz, {name = 'air'})
            end
        end
    end

    local place_time_const = 0.1
    local place_time = 1

    for _, val in ipairs(nodes) do
        minetest.after(place_time, function(v_val)
            minetest.set_node(v_val.pos, v_val.node)
        end, val)

        place_time = place_time + place_time_const
    end
end

XBows:register_arrow('arrow_rip', {
    description = 'Arrow R.I.P. - bury players or mobs underground',
    inventory_image = 'x_bows_extras_arrow_rip.png',
    wield_image = 'x_bows_extras_arrow_rip.png',
    custom = {
        recipe = {
            {'default:flint'},
            {'group:stick'},
            {'wool:black'}
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 1,
            damage_groups = {fleshy=8}
        },
        fuel_burntime = 2,
        mod_name = 'x_bows_extras',
        on_hit_player = bury,
        on_hit_entity = bury
    }
})
