---Knockback
---@param self table
---@param pointed_thing PointedThingDef
local function knockback(self, pointed_thing)
    local _caused_knockback = self._caused_knockback
    local ip_pos = pointed_thing.intersection_point
    local dir = vector.normalize(vector.subtract(self._shot_from_pos, ip_pos))

    pointed_thing.ref:add_velocity({
        x = dir.x * (_caused_knockback * 10) * -1,
        y = 7,
        z = dir.z * (_caused_knockback * 10) * -1
    })
end

XBows:register_arrow('arrow_knockback', {
    description = 'Knockback arrow. Pushes players/entities with high power away.',
    inventory_image = 'x_bows_extras_arrow_knockback.png',
    wield_image = 'x_bows_extras_arrow_knockback.png',
    custom = {
        recipe = {
            {'farming:bread'},
            {'default:stick'},
            {'farming:string'}
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 1,
            damage_groups = {fleshy=2}
        },
        mod_name = 'x_bows_extras',
        on_hit_player = knockback,
        on_hit_entity = knockback
    }
})
