---Bubble pop
---@param self table
local function bubble_pop(self)
    local pos = self.object:get_pos()

    minetest.sound_play('x_bows_extras_bubble_gun_pop', {
        gain = 0.3,
        pos = pos,
        max_hear_distance = 10
    })

    minetest.add_particlespawner({
        amount = 30,
        time = 3,
        minpos = pos,
        maxpos = vector.add(pos, {x = 1, y = 1, z = 1}),
        minvel = {x = -1, y = 0.5, z = -1},
        maxvel = {x = 1, y = 1, z = 1},
        minacc = {x = -1, y = 0.5, z = -1},
        maxacc = {x = 1, y = 1, z = 1},
        minexptime = 1,
        maxexptime = 3,
        minsize = 2,
        maxsize = 4,
        texture = 'x_bows_extras_bubble_gun_bubble.png',
    })
end

XBows:register_bow('bubble_gun', {
    description = 'Bubble gun',
    inventory_image = 'x_bows_extras_bubble_gun.png',
    wield_image = 'x_bows_extras_bubble_gun.png^[transformFX',
    custom = {
        inventory_image_charged = 'x_bows_extras_bubble_gun_charged.png',
        wield_image_charged = 'x_bows_extras_bubble_gun_charged.png^[transformFX',
        uses = 385,
        recipe = {
            {'', 'wool:blue', 'farming:string'},
            {'wool:blue', '', 'farming:string'},
            {'', 'wool:blue', 'farming:string'}
        },
        fuel_burntime = 5,
        mod_name = 'x_bows_extras',
        strength_min = 1,
        strength_max = 4,
        acc_x_min = -2,
        acc_y_min = -2,
        acc_z_min = -2,
        acc_x_max = 2,
        acc_y_max = 2,
        acc_z_max = 2,
        allowed_ammunition = {'x_bows_extras:bubble_gun_bubble'},
        sound_load = 'x_bows_extras_bubble_gun_shot',
        sound_hit = 'x_bows_extras_bubble_gun_pop',
        sound_shoot = 'x_bows_extras_bubble_gun_shot',
        sound_shoot_crit = 'x_bows_extras_bubble_gun_shot',
    }
})

XBows:register_arrow('bubble_gun_bubble', {
    description = 'Bubbles',
    inventory_image = 'x_bows_extras_bubble_gun_bubble.png',
    wield_image = 'x_bows_extras_bubble_gun_bubble.png',
    custom = {
        recipe = {
            {'group:water_bucket'},
            {'group:stick'},
            {'farming:string'}
        },
        tool_capabilities = {
            full_punch_interval = 0.4,
            max_drop_level = 0,
            damage_groups = {fleshy=0}
        },
        mod_name = 'x_bows_extras',
        particle_effect = 'x_bows_extras_bubble_gun_bubble',
        particle_effect_crit = 'x_bows_extras_bubble_gun_bubble',
        particle_effect_fast = 'x_bows_extras_bubble_gun_bubble',
        projectile_textures = {'x_bows_extras:bubble_node'},
        projectile_visual_size = {x = 0.2, y = 0.2, z = 0.2},
        projectile_entity = 'x_bows_extras:bubble_entity'
    }
})

minetest.register_node('x_bows_extras:bubble_node', {
    drawtype = 'plantlike',
    tiles = {'x_bows_extras_bubble_gun_bubble.png'},
    groups = {not_in_creative_inventory = 1},
    sunlight_propagates = true,
    paramtype = 'light',
    collision_box = {0, 0, 0, 0, 0, 0},
    selection_box = {0, 0, 0, 0, 0, 0}
})

XBows:register_entity('bubble_entity', {
    _custom = {
        mod_name = 'x_bows_extras',
        on_death = bubble_pop,
        on_punch = bubble_pop
    }
})

XBows:register_particle_effect('x_bows_extras_bubble_gun_bubble', {
    amount = 3,
    time = 1,
    minvel = {x = -0.5, y = -0.5, z = -0.5},
    maxvel = {x = 0.5, y = 0.5, z = 0.5},
    minacc = {x = -1, y = -1, z = -1},
    maxacc = {x = 1, y = 1, z = 1},
    minexptime = 0.2,
    maxexptime = 1,
    minsize = 1,
    maxsize = 4,
    texture = 'x_bows_extras_bubble_gun_bubble.png',
    custom = {
        minpos = {x = -1, y = -1, z = -1},
        maxpos = {x = 1, y = 1, z = 1}
    }
})
