---Fly up
---@param self table
---@param pointed_thing PointedThingDef
local function fly_up(self, pointed_thing)
    local pos = pointed_thing.ref:get_pos()

    self.object:remove()
    pointed_thing.ref:move_to({x = pos.x, y = pos.y + 7, z = pos.z})
end

XBows:register_arrow('arrow_flyup', {
    description = 'Arrow fly up. Fly players/mobs to the air and let them fall.',
    inventory_image = 'x_bows_extras_arrow_flyup.png',
    wield_image = 'x_bows_extras_arrow_flyup.png',
    custom = {
        recipe = {
            {'default:flint'},
            {'group:stick'},
            {'wool:green'}
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 1,
            damage_groups = {fleshy=2}
        },
        fuel_burntime = 2,
        mod_name = 'x_bows_extras',
        on_hit_player = fly_up,
        on_hit_entity = fly_up
    }
})
