---Heal
---@param self table
---@param pointed_thing PointedThingDef
local function heal(self, pointed_thing)
    local _caused_damage = self._caused_damage
    local player = minetest.get_player_by_name(self._user_name)
    player:set_hp(player:get_hp() + _caused_damage, {type='set_hp', description='Healed from healing arrow.'})
end

XBows:register_arrow('arrow_healing', {
    description = 'Healing arrow. Damage points to players/entities will be added as hearts to you.',
    inventory_image = 'x_bows_extras_arrow_healing.png',
    wield_image = 'x_bows_extras_arrow_healing.png',
    custom = {
        recipe = {
            {'farming:bread'},
            {'default:stick'},
            {'farming:string'}
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 1,
            damage_groups = {fleshy=2}
        },
        mod_name = 'x_bows_extras',
        on_hit_player = heal,
        on_hit_entity = heal
    }
})
