XBows:register_arrow('arrow_torch', {
    description = 'Torch arrow. Places torch.',
    inventory_image = 'x_bows_extras_arrow_torch.png',
    wield_image = 'x_bows_extras_arrow_torch.png',
    custom = {
        recipe = {
            {'default:torch'},
            {'group:stick'},
            {'farming:string'}
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 1,
            damage_groups = {fleshy=2}
        },
        mod_name = 'x_bows_extras',
        on_hit_node = function(self, pointed_thing)
            local under = pointed_thing.under
            local above = pointed_thing.above
            local wdir = minetest.dir_to_wallmounted(vector.subtract(under, above))
            local player = minetest.get_player_by_name(self._user_name)

            self.object:remove()

            if wdir == 0 then
                minetest.item_place_node(ItemStack({name = 'default:torch_ceiling'}), player, pointed_thing, wdir)
            elseif wdir == 1 then
                minetest.item_place_node(ItemStack({name = 'default:torch'}), player, pointed_thing, wdir)
            else
                minetest.item_place_node(ItemStack({name = 'default:torch_wall'}), player, pointed_thing, wdir)
            end

            minetest.sound_play('default_place_node_hard', {pos = above, gain = 1.0, max_hear_distance = 10})
        end
    }
})
