XBows:register_arrow('arrow_cluster', {
    description = 'Arrow cluster. Arrow will split to multiple arrows in the air.',
    short_description = 'Arrow cluster',
    inventory_image = 'x_bows_extras_arrow_cluster.png',
    wield_image = 'x_bows_extras_arrow_cluster.png',
    custom = {
        recipe = {
            {'x_bows:arrow_wood', 'default:flint', 'x_bows:arrow_wood'},
            {'x_bows:arrow_wood', 'group:stick', 'x_bows:arrow_wood'},
            {'x_bows:arrow_wood', 'farming:string', 'x_bows:arrow_wood'}
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 1,
            damage_groups = {fleshy=2}
        },
        fuel_burntime = 2,
        mod_name = 'x_bows_extras',
        on_after_activate = function(self)
            if self._arrow_name ~= 'x_bows_extras:arrow_cluster' then
                return
            end

            minetest.after(0.5, function(v_self)
                if v_self._attached then
                    return
                end

                local angle = math.random(0, math.pi*2)
                local angle2 = math.random(0, math.pi*2)
                local posadd
                local positions = {}

                for i = 1, 8 do
                    posadd = {x = math.cos(angle), y = 0, z = math.sin(angle)}
                    posadd = vector.normalize(posadd)

                    table.insert(positions, {
                        added = false,
                        pos = vector.add(v_self._old_pos, posadd)
                    })

                    angle = angle + math.pi / 4
                end

                local newpostoadd = {}

                for k, val in ipairs(positions) do
                    if val.added == false then
                        for l = 1, 8 do
                            posadd = {x = math.cos(angle2), y = 0, z = math.sin(angle2)}
                            posadd = vector.normalize(posadd)

                            table.insert(newpostoadd, {
                                added = false,
                                pos = vector.add(val.pos, posadd)
                            })

                            angle2 = angle2 + math.pi / 4
                        end
                        val.added = true
                    end
                end

                for q=1, #newpostoadd do
                    table.insert(positions, newpostoadd[q])
                end

                for _, v in ipairs(positions) do
                    local arrow = minetest.add_entity(
                        v.pos,
                        'x_bows:arrow_entity',
                        minetest.serialize({
                            _arrow_name = 'x_bows:arrow_wood',
                            _bow_name = v_self._bow_name,
                            user_name = v_self._user_name,
                            is_critical_hit = v_self._is_critical_hit,
                            _tool_capabilities = {
                                full_punch_interval = 0.7,
                                max_drop_level = 0,
                                damage_groups = {fleshy=2}
                            },
                            _tflp = 1,
                            _add_damage = 0
                        }))

                    if arrow then
                        local parent_props = v_self.object:get_properties()
                        local parent_vel = v_self.object:get_velocity()
                        local parent_acc = v_self.object:get_acceleration()
                        local parent_yaw = v_self.object:get_yaw()

                        arrow:set_properties(parent_props)
                        arrow:set_velocity(parent_vel)
                        arrow:set_acceleration(parent_acc)
                        arrow:set_yaw(parent_yaw)
                    end
                end
            end, self)
        end
    }
})
