--[[
    X Bows extras. Adds more bows/guns and arrows to Minetest using X Bows API.
    Copyright (C) 2022 SaKeL <juraj.vajda@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to juraj.vajda@gmail.com
--]]

local S = minetest.get_translator(minetest.get_current_modname())

XBows:register_bow('bazooka', {
    description = S('Bazooka'),
    short_description = S('Bazooka'),
    inventory_image = 'x_bows_extras_bazooka.png',
    wield_image = 'x_bows_extras_bazooka.png^[transformFX',
    custom = {
        inventory_image_charged = 'x_bows_extras_bazooka_charged.png',
        wield_image_charged = 'x_bows_extras_bazooka_charged.png^[transformFX',
        uses = 385,
        recipe = {
            { '', 'wool:black', 'farming:string' },
            { 'wool:black', '', 'farming:string' },
            { '', 'wool:black', 'farming:string' }
        },
        mod_name = 'x_bows_extras',
        allowed_ammunition = { 'x_bows_extras:bazooka_bullet' },
        gravity = -0.5,
        strength = 150,
        sound_load = 'x_bows_extras_bazooka_load',
        sound_hit = '',
        sound_shoot = 'x_bows_extras_bazooka_shot',
        sound_shoot_crit = 'x_bows_extras_bazooka_shot'
    }
})

---Boom
---@param self table
---@param pointed_thing PointedThingDef
local function hit(self, pointed_thing)
    local ip_pos = pointed_thing.intersection_point

    self.object:remove()

    if minetest.is_protected(ip_pos, self._user_name) then
        return
    end

    if minetest.get_modpath('tnt') then
        tnt.boom(ip_pos, {
            radius = 5
        })

        return
    end

    minetest.chat_send_player(self._user_name, 'TNT mod is disabled. No explosion will happen.')
end

XBows:register_arrow('bazooka_bullet', {
    description = S('Bazooka bullet'),
    short_description = S('Bazooka bullet'),
    inventory_image = 'x_bows_extras_bazooka_bullet.png',
    wield_image = 'x_bows_extras_bazooka_bullet.png',
    custom = {
        recipe = {
            { 'wool:black' },
            { 'group:stick' },
            { 'farming:string' }
        },
        tool_capabilities = {
            full_punch_interval = 1.2,
            max_drop_level = 0,
            damage_groups = { fleshy = 16 }
        },
        mod_name = 'x_bows_extras',
        projectile_entity = 'x_bows_extras:bazooka_entity',
        on_hit_node = hit,
        on_hit_player = hit,
        on_hit_entity = hit
    }
})

minetest.register_node('x_bows_extras:bazooka_bullet_node', {
    drawtype = 'nodebox',
    node_box = {
        type = 'fixed',
        fixed = {
            { -0.1875, 0, -0.5, 0.1875, 0, 0.5 },
            { 0, -0.1875, -0.5, 0, 0.1875, 0.5 },
            { -0.5, -0.5, -0.5, 0.5, 0.5, -0.5 },
        }
    },
    -- Textures of node; +Y, -Y, +X, -X, +Z, -Z
    -- Textures of node; top, bottom, right, left, front, back
    tiles = {
        'x_bows_extras_bazooka_bullet_tile_point_top.png',
        'x_bows_extras_bazooka_bullet_tile_point_bottom.png',
        'x_bows_extras_bazooka_bullet_tile_point_right.png',
        'x_bows_extras_bazooka_bullet_tile_point_left.png',
        'x_bows_extras_bazooka_bullet_tile_tail.png',
        'x_bows_extras_bazooka_bullet_tile_tail.png'
    },
    groups = { not_in_creative_inventory = 1 },
    sunlight_propagates = true,
    paramtype = 'light',
    collision_box = { 0, 0, 0, 0, 0, 0 },
    selection_box = { 0, 0, 0, 0, 0, 0 }
})

XBows:register_entity('bazooka_entity', {
    initial_properties = {
        textures = { 'x_bows_extras:bazooka_bullet_node' },
        visual_size = { x = 0.2, y = 0.2, z = 0.2 }
    },
    _custom = {
        mod_name = 'x_bows_extras'
    }
})
