--[[
    X Bows extras. Adds more bows/guns and arrows to Minetest using X Bows API.
    Copyright (C) 2022 SaKeL <juraj.vajda@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to juraj.vajda@gmail.com
--]]

local S = minetest.get_translator(minetest.get_current_modname())

---Bubble pop
---@param self table
local function bubble_pop(self)
    local pos = self.object:get_pos()

    minetest.add_particlespawner({
        amount = 30,
        time = 3,
        minpos = pos,
        maxpos = vector.add(pos, { x = 1, y = 1, z = 1 }),
        minvel = { x = -1, y = 0.5, z = -1 },
        maxvel = { x = 1, y = 1, z = 1 },
        minacc = { x = -1, y = 0.5, z = -1 },
        maxacc = { x = 1, y = 1, z = 1 },
        minexptime = 1,
        maxexptime = 3,
        minsize = 2,
        maxsize = 4,
        texture = 'x_bows_extras_bubble_gun_bubble.png',
    })
end

XBows:register_bow('bubble_gun', {
    description = S('Bubble gun'),
    short_description = S('Bubble gun'),
    inventory_image = 'x_bows_extras_bubble_gun.png',
    wield_image = 'x_bows_extras_bubble_gun.png^[transformFX',
    custom = {
        inventory_image_charged = 'x_bows_extras_bubble_gun_charged.png',
        wield_image_charged = 'x_bows_extras_bubble_gun_charged.png^[transformFX',
        uses = 385,
        recipe = {
            { '', 'wool:blue', 'farming:string' },
            { 'wool:blue', '', 'farming:string' },
            { '', 'wool:blue', 'farming:string' }
        },
        fuel_burntime = 5,
        mod_name = 'x_bows_extras',
        strength_min = 1,
        strength_max = 4,
        acc_x_min = -2,
        acc_y_min = -2,
        acc_z_min = -2,
        acc_x_max = 2,
        acc_y_max = 2,
        acc_z_max = 2,
        allowed_ammunition = { 'x_bows_extras:bubble_gun_bubble' },
        sound_load = 'x_bows_extras_bubble_gun_shot',
        sound_hit = 'x_bows_extras_bubble_gun_pop',
        sound_shoot = 'x_bows_extras_bubble_gun_shot',
        sound_shoot_crit = 'x_bows_extras_bubble_gun_shot',
    }
})

XBows:register_arrow('bubble_gun_bubble', {
    description = S('Bubbles'),
    short_description = S('Bubbles'),
    inventory_image = 'x_bows_extras_bubble_gun_bubble.png',
    wield_image = 'x_bows_extras_bubble_gun_bubble.png',
    custom = {
        recipe = {
            { 'group:water_bucket' },
            { 'group:stick' },
            { 'farming:string' }
        },
        tool_capabilities = {
            full_punch_interval = 0.4,
            max_drop_level = 0,
            damage_groups = { fleshy = 0 }
        },
        mod_name = 'x_bows_extras',
        particle_effect = 'x_bows_extras_bubble_gun_bubble',
        particle_effect_crit = 'x_bows_extras_bubble_gun_bubble',
        particle_effect_fast = 'x_bows_extras_bubble_gun_bubble',
        projectile_entity = 'x_bows_extras:bubble_entity',
        ---@diagnostic disable-next-line: unused-local
        on_hit_node = function(self, pointed_thing)
            self.object:set_properties({ collisionbox = { -0.5, -0.5, -0.5, 0.5, 0.5, 0.5 } })
        end
    }
})

XBows:register_entity('bubble_entity', {
    initial_properties = {
        visual = 'mesh',
        mesh = 'x_bows_extras_bubble_gun_bubble.b3d',
        textures = { 'x_bows_extras_bubble_gun_bubble_mesh.png' }
    },
    _custom = {
        animations = {
            ---@diagnostic disable-next-line: assign-type-mismatch
            idle = { { x = 41, y = 42 }, 0, 0, false },
            ---@diagnostic disable-next-line: assign-type-mismatch
            on_hit_node = { { x = 1, y = 40 }, 40, 0, false }
        },
        mod_name = 'x_bows_extras',
        rotation_factor = function()
            local rot = math.floor(math.random(60, 100) / 10)

            if math.random(1, 2) == 1 then
                rot = rot * -1
            end

            return math.pi / rot
        end,
        on_death = function(self)
            local pos = self.object:get_pos()

            minetest.sound_play('x_bows_extras_bubble_gun_pop', {
                gain = 0.3,
                pos = pos,
                max_hear_distance = 10
            })

            bubble_pop(self)
        end,
        on_punch = bubble_pop
    }
})

XBows:register_particle_effect('x_bows_extras_bubble_gun_bubble', {
    amount = 3,
    time = 1,
    minvel = { x = -0.5, y = -0.5, z = -0.5 },
    maxvel = { x = 0.5, y = 0.5, z = 0.5 },
    minacc = { x = -1, y = -1, z = -1 },
    maxacc = { x = 1, y = 1, z = 1 },
    minexptime = 0.2,
    maxexptime = 1,
    minsize = 1,
    maxsize = 4,
    texture = 'x_bows_extras_bubble_gun_bubble.png',
    custom = {
        minpos = { x = -1, y = -1, z = -1 },
        maxpos = { x = 1, y = 1, z = 1 }
    }
})
