--[[
    X Bows extras. Adds more bows/guns and arrows to Minetest using X Bows API.
    Copyright (C) 2023 SaKeL <juraj.vajda@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to juraj.vajda@gmail.com
--]]

local S = minetest.get_translator(minetest.get_current_modname())

---Heal
---@param self table
---@param pointed_thing PointedThingDef
---@diagnostic disable-next-line: unused-local
local function heal(self, pointed_thing)
    local _caused_damage = self._caused_damage
    local player = minetest.get_player_by_name(self._user_name)
    player:set_hp(player:get_hp() + _caused_damage, { type = 'set_hp', description = 'Healed from healing arrow.' })
end

XBows:register_arrow('arrow_healing', {
    description = S('Healing arrow. Damage points to players/entities will be added as hearts to you.'),
    short_description = S('Healing arrow'),
    inventory_image = 'x_bows_extras_arrow_healing.png',
    wield_image = 'x_bows_extras_arrow_healing.png',
    custom = {
        recipe = {
            { 'farming:bread' },
            { 'default:stick' },
            { 'farming:string' }
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 1,
            damage_groups = { fleshy = 2 }
        },
        mod_name = 'x_bows_extras',
        on_hit_player = heal,
        on_hit_entity = heal
    }
})
