--[[
    X Bows extras. Adds more bows/guns and arrows to Minetest using X Bows API.
    Copyright (C) 2023 SaKeL <juraj.vajda@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to juraj.vajda@gmail.com
--]]

local S = minetest.get_translator(minetest.get_current_modname())

XBows:register_arrow('arrow_torch', {
    description = S('Torch arrow. Places torch.'),
    short_description = S('Torch arrow'),
    inventory_image = 'x_bows_extras_arrow_torch.png',
    wield_image = 'x_bows_extras_arrow_torch.png',
    custom = {
        recipe = {
            { 'default:torch' },
            { 'group:stick' },
            { 'farming:string' }
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 1,
            damage_groups = { fleshy = 2 }
        },
        mod_name = 'x_bows_extras',
        on_hit_node = function(self, pointed_thing)
            local under = pointed_thing.under
            local above = pointed_thing.above
            local wdir = minetest.dir_to_wallmounted(vector.subtract(under, above))
            local player = minetest.get_player_by_name(self._user_name)

            self.object:remove()

            if wdir == 0 then
                minetest.item_place_node(ItemStack({ name = 'default:torch_ceiling' }), player, pointed_thing, wdir)
            elseif wdir == 1 then
                minetest.item_place_node(ItemStack({ name = 'default:torch' }), player, pointed_thing, wdir)
            else
                minetest.item_place_node(ItemStack({ name = 'default:torch_wall' }), player, pointed_thing, wdir)
            end

            minetest.sound_play('default_place_node_hard', { pos = above, gain = 1.0, max_hear_distance = 10 })
        end
    }
})
