--[[
    X Bows extras. Adds more bows/guns and arrows to Minetest using X Bows API.
    Copyright (C) 2025 SaKeL

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to juraj.vajda@gmail.com
--]]

local S = core.get_translator(core.get_current_modname())

---Bury
---@param self table
---@param pointed_thing PointedThingDef
local function bury(self, pointed_thing)
    local pos = pointed_thing.ref:get_pos()
    local nodes = {}
    self.object:remove()

    ---y
    for i = 1, 5 do
        ---z
        for j = 1, 3 do
            ---x
            for k = 1, 3 do
                local px = { x = (pos.x - 2) + j, y = pos.y - i, z = (pos.z - 2) + k }
                local pz = { x = (pos.x - 2) + k, y = pos.y - i, z = (pos.z - 2) + j }
                local nx = core.get_node(px)
                local nz = core.get_node(pz)

                if nx.name ~= 'air' then
                    table.insert(nodes, {
                        pos = px,
                        node = nx
                    })
                end

                if nz.name ~= 'air' then
                    table.insert(nodes, {
                        pos = pz,
                        node = nz
                    })
                end

                core.swap_node(px, { name = 'air' })
                core.swap_node(pz, { name = 'air' })
            end
        end
    end

    local place_time_const = 0.1
    local place_time = 1

    for _, val in ipairs(nodes) do
        core.after(place_time, function(v_val)
            core.swap_node(v_val.pos, v_val.node)
        end, val)

        place_time = place_time + place_time_const
    end
end

XBows:register_arrow('arrow_rip', {
    description = S('Arrow R.I.P. Bury players or mobs underground'),
    short_description = S('Arrow R.I.P.'),
    inventory_image = 'x_bows_extras_arrow_rip.png',
    wield_image = 'x_bows_extras_arrow_rip.png',
    custom = {
        recipe = {
            { 'default:flint' },
            { 'group:stick' },
            { 'wool:black' }
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 1,
            damage_groups = { fleshy = 1 }
        },
        fuel_burntime = 2,
        mod_name = 'x_bows_extras',
        on_hit_player = bury,
        on_hit_entity = bury
    }
})
