--[[
    X Bows extras. Adds more bows/guns and arrows to Minetest using X Bows API.
    Copyright (C) 2025 SaKeL

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to juraj.vajda@gmail.com
--]]

local S = core.get_translator(core.get_current_modname())

XBows:register_arrow('arrow_cluster', {
    description = S('Arrow cluster. Arrow will split to multiple arrows in the air.'),
    short_description = S('Arrow cluster'),
    inventory_image = 'x_bows_extras_arrow_cluster.png',
    wield_image = 'x_bows_extras_arrow_cluster.png',
    custom = {
        recipe = {
            { 'x_bows:arrow_wood', 'default:flint', 'x_bows:arrow_wood' },
            { 'x_bows:arrow_wood', 'group:stick', 'x_bows:arrow_wood' },
            { 'x_bows:arrow_wood', 'farming:string', 'x_bows:arrow_wood' }
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 1,
            damage_groups = { fleshy = 2 }
        },
        fuel_burntime = 2,
        mod_name = 'x_bows_extras',
        on_after_activate = function(self)
            if self._arrow_name ~= 'x_bows_extras:arrow_cluster' then
                return
            end

            core.after(0.5, function(v_self)
                if v_self._attached then
                    return
                end

                local angle = math.random(0, math.pi * 2)
                local angle2 = math.random(0, math.pi * 2)
                local posadd
                local positions = {}

                ---@diagnostic disable-next-line: unused-local
                for i = 1, 8 do
                    posadd = { x = math.cos(angle), y = 0, z = math.sin(angle) }
                    posadd = vector.normalize(posadd)

                    table.insert(positions, {
                        added = false,
                        pos = vector.add(v_self._old_pos, posadd)
                    })

                    angle = angle + math.pi / 4
                end

                local newpostoadd = {}

                ---@diagnostic disable-next-line: unused-local
                for k, val in ipairs(positions) do
                    if val.added == false then
                        ---@diagnostic disable-next-line: unused-local
                        for l = 1, 8 do
                            posadd = { x = math.cos(angle2), y = 0, z = math.sin(angle2) }
                            posadd = vector.normalize(posadd)

                            table.insert(newpostoadd, {
                                added = false,
                                pos = vector.add(val.pos, posadd)
                            })

                            angle2 = angle2 + math.pi / 4
                        end
                        val.added = true
                    end
                end

                for q = 1, #newpostoadd do
                    table.insert(positions, newpostoadd[q])
                end

                for _, v in ipairs(positions) do
                    local arrow = core.add_entity(
                        v.pos,
                        'x_bows:arrow_entity',
                        core.serialize({
                            _arrow_name = 'x_bows:arrow_wood',
                            _bow_name = v_self._bow_name,
                            _user_name = v_self._user_name,
                            _is_critical_hit = v_self._is_critical_hit,
                            _tool_capabilities = {
                                full_punch_interval = 0.7,
                                max_drop_level = 0,
                                damage_groups = { fleshy = 2 }
                            },
                            _tflp = 1,
                            _add_damage = 0
                        }))

                    if arrow then
                        local parent_props = v_self.object:get_properties()
                        local parent_vel = v_self.object:get_velocity()
                        local parent_acc = v_self.object:get_acceleration()
                        local parent_yaw = v_self.object:get_yaw()

                        arrow:set_properties(parent_props)
                        arrow:set_velocity(parent_vel)
                        arrow:set_acceleration(parent_acc)
                        arrow:set_yaw(parent_yaw)
                    end
                end
            end, self)
        end
    }
})
