--[[
    X Bows extras. Adds more bows/guns and arrows to Minetest using X Bows API.
    Copyright (C) 2025 SaKeL

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to juraj.vajda@gmail.com
--]]

local S = core.get_translator(core.get_current_modname())

---Fly up
---@param self table
---@param pointed_thing PointedThingDef
local function fly_up(self, pointed_thing)
    local pos = pointed_thing.ref:get_pos()

    self.object:remove()
    pointed_thing.ref:move_to({ x = pos.x, y = pos.y + 10, z = pos.z })
end

XBows:register_arrow('arrow_flyup', {
    description = S('Arrow fly up. Fly players/mobs to the air and let them fall.'),
    short_description = S('Arrow fly up'),
    inventory_image = 'x_bows_extras_arrow_flyup.png',
    wield_image = 'x_bows_extras_arrow_flyup.png',
    custom = {
        recipe = {
            { 'default:flint' },
            { 'group:stick' },
            { 'wool:green' }
        },
        tool_capabilities = {
            full_punch_interval = 0.7,
            max_drop_level = 1,
            damage_groups = { fleshy = 2 }
        },
        fuel_burntime = 2,
        mod_name = 'x_bows_extras',
        on_hit_player = fly_up,
        on_hit_entity = fly_up
    }
})
