---https://github.com/sumneko/lua-language-server/wiki

---A native C++ format with many helper methods. Useful for converting between formats.
---An `ItemStack` is a stack of items.
---It can be created via `ItemStack(x)`, where x is an `ItemStack`, an itemstring, a table or `nil`.
---@class ItemStack
---@field is_empty fun(): boolean Returns `true` if stack is empty.
---@field get_name fun(): string returns item name (e.g. `"default:stone"`).
---@field set_name fun(self: ItemStack, item_name: string): boolean Returns a boolean indicating whether the item was cleared.
---@field get_count fun(): integer Returns number of items on the stack.
---@field set_count fun(self: ItemStack, count: integer): boolean Returns a boolean indicating whether the item was cleared
---@field get_wear fun(): integer Returns tool wear (`0`-`65535`), `0` for non-tools.
---@field set_wear fun(self: ItemStack, wear: integer): boolean Returns boolean indicating whether item was cleared
---@field get_meta fun(): ItemStackMetaRef Returns `ItemStackMetaRef`.
---@field get_description fun(): string Returns the description shown in inventory list tooltips. The engine uses this when showing item descriptions in tooltips. Fields for finding the description, in order: `description` in item metadata.
---@field get_short_description fun(): string|nil Returns the short description or nil. Unlike the description, this does not include new lines. Fields for finding the short description, in order: `short_description` in item metadata. Returns nil if none of the above are set.
---@field clear fun(): nil Removes all items from the stack, making it empty.
---@field replace fun(self: ItemStack, item: string|table)`: replace the contents of this stack. `item` can also be an itemstring or table.
---@field to_string fun(): string Returns the stack in itemstring form.
---@field to_table fun(): table Returns the stack in Lua table form.
---@field get_stack_max fun(): integer Returns the maximum size of the stack (depends on the item).
---@field get_free_space fun(): integer Returns `get_stack_max() - get_count()`.
---@field is_known fun(): boolean Returns `true` if the item name refers to a defined item type.
---@field get_definition fun(): table Returns the item definition table.
---@field get_tool_capabilities fun(): table Returns the digging properties of the item, or those of the hand if none are defined for this item type
---@field add_wear fun(self: ItemStack, amount: integer|number): nil Increases wear by `amount` if the item is a tool, otherwise does nothing. Valid `amount` range is [0,65536] `amount`: number, integer
---@field add_wear_by_uses fun(self: ItemStack, max_uses: integer|number): nil Increases wear in such a way that, if only this function is called, the item breaks after `max_uses` times. Valid `max_uses` range is [0,65536] Does nothing if item is not a tool or if `max_uses` is 0
---@field add_item fun(self: ItemStack, item: string|table): ItemStack Returns leftover `ItemStack` Put some item or stack onto this stack
---@field item_fits fun(self: ItemStack, item: string|table): boolean Returns `true` if item or stack can be fully added to this one.
---@field take_item fun(self: ItemStack, n: integer|number): ItemStack Returns taken `ItemStack` Take (and remove) up to `n` items from this stack `n`: number, default: `1`
---@field peek_item fun(self: ItemStack, n: integer|number): ItemStack Returns taken `ItemStack` Copy (don't remove) up to `n` items from this stack `n`: number, default: `1`
---@field name string
---@field count integer
---@field wear string
---@field metadata string
