---https://github.com/sumneko/lua-language-server/wiki

---Node Timers: a high resolution persistent per-node timer. Can be gotten via `minetest.get_node_timer(pos)`.
---@class NodeTimerRef
---@field set fun(self: NodeTimerRef, timeout: integer|number, elapsed: integer|number): nil Set a timer's state. `timeout` is in seconds, and supports fractional values (0.1 etc). `elapsed` is in seconds, and supports fractional values (0.1 etc). Will trigger the node's `on_timer` function after `(timeout - elapsed)` seconds.
---@field start fun(self: NodeTimerRef, timeout: integer|number): nil Start a timer. Equivalent to `set(timeout,0)`.
---@field stop fun(): nil Stops the timer
---@field get_timeout fun(): number|integer Returns current timeout in seconds.
---@field get_elapsed fun(): number|integer Returns current elapsed time in seconds.
---@field is_started fun(): boolean Returns boolean state of timer. Returns `true` if timer is started, otherwise `false`.
---@field get_meta fun(pos: Vector): MetaDataRef Get a `NodeMetaRef` at that position
