---https://github.com/sumneko/lua-language-server/wiki

---Minetest item definition. Used by `minetest.register_node`, `minetest.register_craftitem`, and `minetest.register_tool`.
---Add your own custom fields. By convention, all custom field names. Should start with `_` to avoid naming collisions with future engine usage.
---@class ItemDef
---@field description string Can contain new lines. "\n" has to be used as new line character.
---@field short_description string|nil Must not contain new lines. Defaults to nil.
---@field groups table<string, string|number|integer|boolean> key = name, value = rating; rating = <number>. If rating not applicable, use 1. e.g. `{wool = 1, fluffy = 3}` `{soil = 2, outerspace = 1, crumbly = 1}` `{bendy = 2, snappy = 1}` {hard = 1, metal = 1, spikes = 1}
---@field inventory_image string Texture shown in the inventory GUI. Defaults to a 3D rendering of the node if left empty.
---@field inventory_overlay string An overlay texture which is not affected by colorization
---@field wield_image string Texture shown when item is held in hand. Defaults to a 3D rendering of the node if left empty.
---@field wield_overlay string Like inventory_overlay but only used in the same situation as wield_image
---@field wield_scale table<string, number|integer> Scale for the item when held in hand
---@field palette string An image file containing the palette of a node. You can set the currently used color as the "palette_index" field of the item stack metadata. The palette is always stretched to fit indices between 0 and 255, to ensure compatibility with "colorfacedir" (and similar) nodes.
---@field color string Color the item is colorized with. The palette overrides this.
---@field stack_max integer|number Maximum amount of items that can be in a single stack.
---@field range integer|number Range of node and object pointing that is possible with this item held.
---@field liquids_pointable boolean If true, item can point to all liquid nodes (`liquidtype ~= "none"`), even those for which `pointable = false`
---@field light_source integer|number When used for nodes: Defines amount of light emitted by node. Otherwise: Defines texture glow when viewed as a dropped item. To set the maximum (14), use the value 'minetest.LIGHT_MAX'. A value outside the range 0 to minetest.LIGHT_MAX causes undefined behavior.
---@field tool_capabilities ToolCapabilitiesDef
---@field node_placement_prediction string|nil If nil and item is node, prediction is made automatically. If nil and item is not a node, no prediction is made. If "" and item is anything, no prediction is made. Otherwise should be name of node which the client immediately places on ground when the player places the item. Server will always update with actual result shortly.
---@field node_dig_prediction string if "", no prediction is made. if "air", node is removed. Otherwise should be name of node which the client immediately places upon digging. Server will always update with actual result shortly.
---@field sound ItemSoundDef
---@field on_place fun(itemstack: ItemStack, placer: ObjectRef|nil, pointed_thing: PointedThingDef): ItemStack|nil When the 'place' key was pressed with the item in hand and a node was pointed at. Shall place item and return the leftover itemstack or nil to not modify the inventory. The placer may be any ObjectRef or nil. default: minetest.item_place
---@field on_secondary_use fun(itemstack: ItemStack, user: ObjectRef|nil, pointed_thing: PointedThingDef): ItemStack|nil Same as on_place but called when not pointing at a node. Function must return either nil if inventory shall not be modified, or an itemstack to replace the original itemstack. The user may be any ObjectRef or nil. default: nil
---@field on_drop fun(itemstack: ItemStack, dropper: ObjectRef|nil, pos: Vector): ItemStack|nil Shall drop item and return the leftover itemstack. The dropper may be any ObjectRef or nil. default: minetest.item_drop
---@field on_pickup fun(itemstack: ItemStack, picker: ObjectRef|nil, pointed_thing?: PointedThingDef, time_from_last_punch?: number|integer, rest?: any): ItemStack|nil Called when a dropped item is punched by a player. Shall pick-up the item and return the leftover itemstack or nil to not modify the dropped item. `rest` are other parameters from `luaentity:on_punch`. default: `minetest.item_pickup`
---@field on_use fun(itemstack: ItemStack, user: ObjectRef|nil, pointed_thing: PointedThingDef): ItemStack|nil default: nil. When user pressed the 'punch/mine' key with the item in hand. Function must return either nil if inventory shall not be modified, or an itemstack to replace the original itemstack. e.g. itemstack:take_item(); return itemstack. Otherwise, the function is free to do what it wants. The user may be any ObjectRef or nil. The default functions handle regular use cases.
---@field after_use fun(itemstack: ItemStack, user: ObjectRef|nil, node: NodeDef, digparams: DigParamsDef): ItemStack|nil default: nil. If defined, should return an itemstack and will be called instead of wearing out the item (if tool). If returns nil, does nothing.

---Tool capabilities definition
---@class ToolCapabilitiesDef
---@field full_punch_interval number|integer
---@field max_drop_level number|integer
---@field groupcaps GroupCapsDef
---@field damage_groups table<string, number|integer> Damage values must be between -32768 and 32767 (2^15)
---@field punch_attack_uses number|integer|nil Amount of uses this tool has for attacking players and entities by punching them (0 = infinite uses). For compatibility, this is automatically set from the first suitable groupcap using the forumla "uses * 3^(maxlevel - 1)". It is recommend to set this explicitly instead of relying on the fallback behavior.

---Known damage and digging time defining groups
---@class GroupCapsDef
---@field crumbly number|GroupCapsItemDef dirt, sand
---@field cracky number|GroupCapsItemDef tough but crackable stuff like stone.
---@field snappy number|GroupCapsItemDef something that can be cut using things like scissors, shears, bolt cutters and the like, e.g. leaves, small plants, wire, sheets of metal
---@field choppy number|GroupCapsItemDef something that can be cut using force; e.g. trees, wooden planks
---@field fleshy number|GroupCapsItemDef Living things like animals and the player. This could imply some blood effects when hitting.
---@field explody number|GroupCapsItemDef Especially prone to explosions
---@field oddly_breakable_by_hand number|GroupCapsItemDef Can be added to nodes that shouldn't logically be breakable by the hand but are. Somewhat similar to `dig_immediate`, but times are more like `{[1]=3.50,[2]=2.00,[3]=0.70}` and this does not override the digging speed of an item if it can dig at a faster speed than this suggests for the hand.

---Known damage and digging time defining groups
---@class GroupCapsItemDef
---@field maxlevel number|integer Tells what is the maximum level of a node of this group that the item will be able to dig.
---@field uses number|integer Tools only. Determines how many uses the tool has when it is used for digging a node, of this group, of the maximum level. The maximum supported number of uses is 65535. The special number 0 is used for infinite uses. For lower leveled nodes, the use count is multiplied by `3^leveldiff`. `leveldiff` is the difference of the tool's `maxlevel` `groupcaps` and the node's `level` group. The node cannot be dug if `leveldiff` is less than zero.
---@field times table<number|integer, number|integer> List of digging times for different ratings of the group, for nodes of the maximum level. For example, as a Lua table, `times={[2]=2.00, [3]=0.70}`. This would result in the item to be able to dig nodes that have a rating of `2` or `3` for this group, and unable to dig the rating `1`, which is the toughest. Unless there is a matching group that enables digging otherwise. If the result digging time is 0, a delay of 0.15 seconds is added between digging nodes; If the player releases LMB after digging, this delay is set to 0, i.e. players can more quickly click the nodes away instead of holding LMB.
