---@diagnostic disable: codestyle-check
---https://github.com/sumneko/lua-language-server/wiki

--- ParticleSpawner definition
---@class ParticlespawnerDef
---@field amount number|integer Number of particles spawned over the time period `time`.
---@field time number|integer Lifespan of spawner in seconds. If time is 0 spawner has infinite lifespan and spawns the `amount` on a per-second basis.
---@field collisiondetection boolean If true collide with `walkable` nodes and, depending on the `object_collision` field, objects too.
---@field collision_removal boolean If true particles are removed when they collide. Requires collisiondetection = true to have any effect.
---@field object_collision boolean If true particles collide with objects that are defined as `physical = true,` and `collide_with_objects = true,`. Requires collisiondetection = true to have any effect.
---@field attached ObjectRef If defined, particle positions, velocities and accelerations are relative to this object's position and yaw
---@field vertical boolean If true face player using y axis only
---@field texture string The texture of the particle. e,g, `"image.png"`
---@field playername string Optional, if specified spawns particles only on the player's client
---@field animation TileAnimationDef Optional, specifies how to animate the particles' texture. v5.6.0 and later: set length to -1 to sychronize the length of the animation with the expiration time of individual particles. (-2 causes the animation to be played twice, and so on)
---@field glow number|integer Optional, specify particle self-luminescence in darkness. Values 0-14.
---@field node table<string, string|number|integer> e.g. `{name = "ignore", param2 = 0}`. Optional, if specified the particles will have the same appearance as node dig particles for the given node. Texture` and `animation` will be ignored if this is set.
---@field node_tile number|integer Optional, only valid in combination with `node`. If set to a valid number 1-6, specifies the tile from which the particle texture is picked. Otherwise, the default behavior is used. (currently: any random tile)
---@field minpos Vector Legacy definition field
---@field maxpos Vector Legacy definition field
---@field minvel Vector Legacy definition field
---@field maxvel Vector Legacy definition field
---@field minacc Vector Legacy definition field
---@field maxacc Vector Legacy definition field
---@field minexptime number|integer Legacy definition field
---@field maxexptime number|integer Legacy definition field
---@field minsize number|integer Legacy definition field
---@field maxsize number|integer Legacy definition field
---@field pos number|integer|Vector|ParticlespawnerPosDef As `number`: absolute value - all components of every particle's position vector will be set to this. As `Vector`: vec3 - all particles will appear at this exact position throughout the lifetime of the particlespawner. As `ParticlespawnerPosDef`: vec3 range - the particle will appear at a position that is picked at random from within a cubic range.

--- ParticleSpawner pos definition
---@class ParticlespawnerPosDef
---@field min Vector The minimum value this property will be set to in particles spawned by the generator.
---@field max Vector The maximum value this property will be set to in particles spawned by the generator.
---@field bias number|integer When `bias` is 0, all random values are exactly as likely as any other. When it is positive, the higher it is, the more likely values will appear towards the minimum end of the allowed spectrum. When it is negative, the lower it is, the more likely values will appear towards the maximum end of the allowed spectrum. The curve is exponential and there is no particular maximum or minimum value.
---@field pos_tween ParticlespawnerPosTweenDef A tween table should consist of a list of frames in the same form as the untweened pos property above, which the engine will interpolate between, and optionally a number of properties that control how the interpolation takes place. Currently **only two frames**, the first and the last, are used, but extra frames are accepted for the sake of forward compatibility. Any of the above definition styles can be used here as well in any combination supported by the property type.

--- ParticleSpawner pos_tween definition
---@class ParticlespawnerPosTweenDef
---@field style string e.g. "fwd":  linear animation from first to last frame (default), "rev": linear animation from last to first frame, "pulse": linear animation from first to last then back to first again, "flicker": like "pulse", but slightly randomized to add a bit of stutter
---@field reps number|integer Number of times the animation is played over the particle's lifespan
---@field start number|integer  Point in the spawner's lifespan at which the animation begins. 0 is the very beginning, 1 is the very end.
---@field frames number|integer|Vector|ParticlespawnerPosDef Frames can be defined in a number of different ways, depending on the underlying type of the property. For now, all but the first and last frame are ignored.

--- Tile animation definition
---@class TileAnimationDef
---@field type string e.g. "vertical_frames",  "sheet_2d"
---@field aspect_w number|integer Width of a frame in pixels
---@field aspect_h number|integer Height of a frame in pixels
---@field length number|integer e.g. 3.0 Full loop length, 0.5 Length of a single frame
