---@diagnostic disable: codestyle-check
---https://github.com/sumneko/lua-language-server/wiki

---Crafting recipes
---@class CraftRecipeDef
---@field type string (optional) specifies recipe type as shaped, e.g. "shaped", "shapeless", "toolrepair", "cooking", "fuel", default: "shaped"
---@field output string Itemstring of output itemstack (item counts >= 1 are allowed)
---@field recipe table<integer|number, string>[]|string A 2-dimensional matrix of items, with a width *w* and height *h*. *w* and *h* are chosen by you, they don't have to be equal but must be at least 1. The matrix is specified as a table containing tables containing itemnames. The inner tables are the rows. There must be *h* tables, specified from the top to the bottom row. Values inside of the inner table are the columns. Each inner table must contain a list of *w* items, specified from left to right. Empty slots *must* be filled with the empty string.
---@field replacements string[] (optional) Allows you to replace input items with some other items when something is crafted. Provided as a list of item pairs of the form `{ old_item, new_item }` where `old_item` is the input item to replace (same syntax as for a regular input slot; groups are allowed) and `new_item` is an itemstring for the item stack it will become. When the output is crafted, Minetest iterates through the list of input items if the crafting grid. For each input item stack, it checks if it matches with an `old_item` in the item pair list. If it matches, the item will be replaced. Also, this item pair will *not* be applied again for the remaining items. If it does not match, the item is consumed (reduced by 1) normally. The `new_item` will appear in one of 3 places:  Crafting grid, if the input stack size was exactly 1, Player inventory, if input stack size was larger, Drops as item entity, if it fits neither in craft grid or inventory.
---@field additional_wear number|integer For `{type = "toolrepair"}` only. Adds a shapeless recipe for *every* tool that doesn't have the `disable_repair=1` group. If this recipe is used, repairing is possible with any crafting grid with at least 2 slots. The player can put 2 equal tools in the craft grid to get one "repaired" tool back. The wear of the output is determined by the wear of both tools, plus a 'repair bonus' given by `additional_wear`. To reduce the wear (i.e. 'repair'), you want `additional_wear` to be negative. The formula used to calculate the resulting wear is: 65536 * (1 - ( (1 - tool_1_wear) + (1 - tool_2_wear) + additional_wear )) The result is rounded and can't be lower than 0. If the result is 65536 or higher, no crafting is possible.
---@field cooktime number|integer For `{type = "cooking"}` only. (optional) Time it takes to cook this item, in seconds. A floating-point number. (default: 3.0)
---@field burntime number|integer For `{type = "fuel"}` only. (optional) Burning time this item provides, in seconds. A floating-point number. (default: 1.0)
