--[[
    X Farming. Extends Minetest farming mod with new plants, crops and ice fishing.
    Copyright (C) 2023 SaKeL <juraj.vajda@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to juraj.vajda@gmail.com
--]]

stairs = stairs --[[@as MtgStairs]]

local S = minetest.get_translator(minetest.get_current_modname())

-- Donuts
local donut_def = {
    description = S('Donut') .. '\n' .. S('Compost chance') .. ': 85%\n'
        .. minetest.colorize(x_farming.colors.brown, S('Hunger') .. ': 3'),
    short_description = S('Donut'),
    drawtype = 'mesh',
    mesh = 'x_farming_donut.obj',
    tiles = { 'x_farming_donut_mesh.png' },
    use_texture_alpha = 'clip',
    inventory_image = 'x_farming_donut.png',
    wield_image = 'x_farming_donut.png',
    paramtype = 'light',
    is_ground_content = false,
    walkable = true,
    selection_box = {
        type = 'fixed',
        fixed = { -0.25, -0.5, -0.25, 0.25, -0.35, 0.25 }
    },
    collision_box = {
        type = 'fixed',
        fixed = { -0.25, -0.5, -0.25, 0.25, -0.35, 0.25 }
    },
    groups = {
        -- MTG
        dig_immediate = 3,
        compost = 85,
        -- MCL
        handy = 1,
        shearsy = 1,
        deco_block = 1,
        non_mycelium_plant = 1,
        fire_encouragement = 60,
        fire_flammability = 100,
        dig_by_water = 1,
        destroy_by_lava_flow = 1,
        compostability = 85,
        food = 2,
        eatable = 1,
        -- ALL
        flammable = 2,
        attached_node = 1,
    },
    _mcl_blast_resistance = 0,
    _mcl_hardness = 0,
    sounds = x_farming.node_sound_leaves_defaults(),
    on_use = minetest.item_eat(3),
    sunlight_propagates = true
}

if minetest.get_modpath('mcl_farming') then
    donut_def.on_secondary_use = minetest.item_eat(3)
end

minetest.register_node('x_farming:donut', donut_def)

local donut_chocolate_def = {
    description = S('Chocolate Donut') .. '\n' .. S('Compost chance') .. ': 85%\n'
        .. minetest.colorize(x_farming.colors.brown, S('Hunger') .. ': 4'),
    short_description = S('Chocolate Donut'),
    drawtype = 'mesh',
    mesh = 'x_farming_donut.obj',
    tiles = { 'x_farming_donut_chocolate_mesh.png' },
    use_texture_alpha = 'clip',
    inventory_image = 'x_farming_donut_chocolate.png',
    wield_image = 'x_farming_donut_chocolate.png',
    paramtype = 'light',
    is_ground_content = false,
    walkable = true,
    selection_box = {
        type = 'fixed',
        fixed = { -0.25, -0.5, -0.25, 0.25, -0.35, 0.25 }
    },
    collision_box = {
        type = 'fixed',
        fixed = { -0.25, -0.5, -0.25, 0.25, -0.35, 0.25 }
    },
    groups = {
        -- MTG
        dig_immediate = 3,
        compost = 85,
        -- MCL
        handy = 1,
        shearsy = 1,
        deco_block = 1,
        non_mycelium_plant = 1,
        fire_encouragement = 60,
        fire_flammability = 100,
        dig_by_water = 1,
        destroy_by_lava_flow = 1,
        compostability = 85,
        food = 2,
        eatable = 1,
        -- ALL
        flammable = 2,
        attached_node = 1,
    },
    _mcl_blast_resistance = 0,
    _mcl_hardness = 0,
    sounds = x_farming.node_sound_leaves_defaults(),
    on_use = minetest.item_eat(4),
    sunlight_propagates = true
}

if minetest.get_modpath('mcl_farming') then
    donut_chocolate_def.on_secondary_use = minetest.item_eat(4)
end

minetest.register_node('x_farming:donut_chocolate', donut_chocolate_def)

-- Fries
local fries_def = {
    description = S('Fries') .. '\n' .. S('Compost chance') .. ': 85%\n'
        .. minetest.colorize(x_farming.colors.brown, S('Hunger') .. ': 6'),
    short_description = S('Fries'),
    drawtype = 'mesh',
    mesh = 'x_farming_fries.obj',
    tiles = { 'x_farming_fries_mesh.png' },
    use_texture_alpha = 'clip',
    inventory_image = 'x_farming_fries.png',
    wield_image = 'x_farming_fries.png',
    paramtype = 'light',
    paramtype2 = 'facedir',
    is_ground_content = false,
    walkable = true,
    selection_box = {
        type = 'fixed',
        fixed = { -0.25, -0.5, -0.1, 0.25, 0.05, 0.1 }
    },
    collision_box = {
        type = 'fixed',
        fixed = { -0.25, -0.5, -0.1, 0.25, -0.2, 0.1 }
    },
    groups = {
        -- MTG
        dig_immediate = 3,
        compost = 85,
        -- MCL
        handy = 1,
        shearsy = 1,
        deco_block = 1,
        non_mycelium_plant = 1,
        fire_encouragement = 60,
        fire_flammability = 100,
        dig_by_water = 1,
        destroy_by_lava_flow = 1,
        compostability = 85,
        food = 2,
        eatable = 1,
        -- ALL
        flammable = 2,
        attached_node = 1,
    },
    _mcl_blast_resistance = 0,
    _mcl_hardness = 0,
    sounds = x_farming.node_sound_leaves_defaults(),
    on_use = minetest.item_eat(6),
    sunlight_propagates = true
}

if minetest.get_modpath('mcl_farming') then
    fries_def.on_secondary_use = minetest.item_eat(6)
end

minetest.register_node('x_farming:fries', fries_def)

-- Pumpkin pie
local pumpkin_pie_def = {
    description = S('Pumpkin Pie') .. '\n' .. S('Compost chance') .. ': 100%\n'
        .. minetest.colorize(x_farming.colors.brown, S('Hunger') .. ': 6'),
    short_description = S('Pumpkin Pie'),
    drawtype = 'mesh',
    mesh = 'x_farming_pumpkin_pie.obj',
    tiles = { 'x_farming_pumpkin_pie_mesh.png' },
    use_texture_alpha = 'clip',
    inventory_image = 'x_farming_pumpkin_pie.png',
    wield_image = 'x_farming_pumpkin_pie.png^[transformFXFYR180',
    paramtype = 'light',
    paramtype2 = 'facedir',
    is_ground_content = false,
    walkable = true,
    selection_box = {
        type = 'fixed',
        fixed = { -0.3, -0.5, -0.3, 0.3, -0.2, 0.3 }
    },
    collision_box = {
        type = 'fixed',
        fixed = { -0.3, -0.5, -0.3, 0.3, -0.3, 0.3 }
    },
    groups = {
        -- MTG
        dig_immediate = 3,
        compost = 100,
        -- MCL
        handy = 1,
        shearsy = 1,
        deco_block = 1,
        non_mycelium_plant = 1,
        fire_encouragement = 60,
        fire_flammability = 100,
        dig_by_water = 1,
        destroy_by_lava_flow = 1,
        compostability = 100,
        food = 2,
        eatable = 1,
        -- ALL
        flammable = 2,
        attached_node = 1,
    },
    _mcl_blast_resistance = 0,
    _mcl_hardness = 0,
    sounds = x_farming.node_sound_leaves_defaults(),
    on_use = minetest.item_eat(6),
    sunlight_propagates = true
}

if minetest.get_modpath('mcl_farming') then
    pumpkin_pie_def.on_secondary_use = minetest.item_eat(6)
end

minetest.register_node('x_farming:pumpkin_pie', pumpkin_pie_def)

-- Beetroot soup
local beetroot_soup_def = {
    description = S('Beetroot Soup') .. '\n' .. S('Compost chance') .. ': 100%\n'
        .. minetest.colorize(x_farming.colors.brown, S('Hunger') .. ': 6'),
    short_description = S('Beetroot Soup'),
    drawtype = 'mesh',
    mesh = 'x_farming_beetroot_soup.obj',
    tiles = { 'x_farming_beetroot_soup_mesh.png' },
    use_texture_alpha = 'clip',
    inventory_image = 'x_farming_beetroot_soup.png',
    wield_image = 'x_farming_beetroot_soup.png',
    paramtype = 'light',
    paramtype2 = 'facedir',
    is_ground_content = false,
    walkable = true,
    selection_box = {
        type = 'fixed',
        fixed = { -0.5, -0.5, -0.5, 0.5, 0.1, 0.5 }
    },
    collision_box = {
        type = 'fixed',
        fixed = { -0.5, -0.5, -0.5, 0.5, -0.1, 0.5 }
    },
    groups = {
        -- MTG
        vessel = 1,
        dig_immediate = 3,
        attached_node = 1,
        -- X Farming
        compost = 100,
        -- MCL
        food = 3,
        eatable = 6,
        compostability = 100,
        handy = 1,
        deco_block = 1,
        fire_encouragement = 60,
        fire_flammability = 100,
        dig_by_water = 1,
        destroy_by_lava_flow = 1,
    },
    sounds = x_farming.node_sound_wood_defaults(),
    sunlight_propagates = true,
    on_use = minetest.item_eat(6, 'x_farming:bowl'),
    -- MCL
    _mcl_saturation = 0.6,
    _mcl_blast_resistance = 0,
    _mcl_hardness = 0,
}

if minetest.get_modpath('mcl_farming') then
    beetroot_soup_def.on_secondary_use = minetest.item_eat(6, 'x_farming:bowl')
end

minetest.register_node('x_farming:beetroot_soup', beetroot_soup_def)

-- Fish Stew
local fish_stew_def = {
    description = S('Fish Stew') .. '\n' .. S('Compost chance') .. ': 100%\n'
        .. minetest.colorize(x_farming.colors.brown, S('Hunger') .. ': 8'),
    short_description = S('Fish Stew'),
    drawtype = 'mesh',
    mesh = 'x_farming_fish_stew.obj',
    tiles = { 'x_farming_fish_stew_mesh.png' },
    use_texture_alpha = 'clip',
    inventory_image = 'x_farming_fish_stew.png',
    wield_image = 'x_farming_fish_stew.png',
    paramtype = 'light',
    paramtype2 = 'facedir',
    is_ground_content = false,
    walkable = true,
    selection_box = {
        type = 'fixed',
        fixed = { -0.5, -0.5, -0.5, 0.5, 0.1, 0.5 }
    },
    collision_box = {
        type = 'fixed',
        fixed = { -0.5, -0.5, -0.5, 0.5, -0.1, 0.5 }
    },
    groups = {
        -- MTG
        vessel = 1,
        dig_immediate = 3,
        attached_node = 1,
        -- X Farming
        compost = 100,
        -- MCL
        food = 3,
        eatable = 6,
        compostability = 100,
        handy = 1,
        deco_block = 1,
        fire_encouragement = 60,
        fire_flammability = 100,
        dig_by_water = 1,
        destroy_by_lava_flow = 1,
    },
    on_use = minetest.item_eat(8, 'x_farming:bowl'),
    sounds = x_farming.node_sound_wood_defaults(),
    sunlight_propagates = true
}

if minetest.get_modpath('mcl_farming') then
    fish_stew_def.on_secondary_use = minetest.item_eat(8, 'x_farming:bowl')
end

minetest.register_node('x_farming:fish_stew', fish_stew_def)

-- Cactus brick
minetest.register_node('x_farming:cactus_brick', {
    description = S('Cactus Brick'),
    short_description = S('Cactus Brick'),
    paramtype2 = 'facedir',
    place_param2 = 0,
    tiles = {
        'x_farming_cactus_brick.png^[transformFX',
        'x_farming_cactus_brick.png',
    },
    is_ground_content = false,
    groups = {
        -- MTG
        cracky = 2,
        -- MCL
        pickaxey = 1,
        stonebrick = 1,
        building_block = 1
    },
    _mcl_blast_resistance = 6,
    _mcl_hardness = 3,
    sounds = x_farming.node_sound_stone_defaults()
})

if minetest.global_exists('stairs') and minetest.get_modpath('stairs') then
    stairs.register_stair_and_slab(
        'cactus_brick',
        'x_farming:cactus_brick',
        { cracky = 3 },
        { 'x_farming_cactus_brick.png' },
        S('Cactus Brick Stair'),
        S('Cactus Brick Slab'),
        x_farming.node_sound_stone_defaults(),
        false
    )
end

if minetest.get_modpath('mcl_stairs') then
    mcl_stairs.register_stair_and_slab(
        'cactus_brick',
        'x_farming:cactus_brick',
        { pickaxey = 1 },
        { 'x_farming_cactus_brick.png' },
        S('Cactus Brick Stair'),
        S('Cactus Brick Slab'),
        x_farming.node_sound_stone_defaults(),
        6,
        2,
        S('Double Cactus Brick Slab'),
        nil
    )
end

local function tick_scarecrow(pos)
    -- minetest.get_node_timer(pos):start(math.random(1, 2))
    minetest.get_node_timer(pos):start(math.random(83, 143))
end

-- Scarecrow
minetest.register_node('x_farming:scarecrow', {
    description = S('Scarecrow'),
    short_description = S('Scarecrow'),
    drawtype = 'mesh',
    mesh = 'x_farming_scarecrow.obj',
    tiles = { 'x_farming_scarecrow_1.png' },
    use_texture_alpha = 'clip',
    inventory_image = 'x_farming_scarecrow_1_item.png',
    wield_image = 'x_farming_scarecrow_1_item.png',
    paramtype = 'light',
    sunlight_propagates = true,
    paramtype2 = 'facedir',
    is_ground_content = false,
    walkable = true,
    selection_box = {
        type = 'fixed',
        fixed = { -0.4, -0.5, -0.4, 0.4, 1.5, 0.4 }
    },
    collision_box = {
        type = 'fixed',
        fixed = { -0.4, -0.5, -0.4, 0.4, 1.5, 0.4 }
    },
    groups = {
        -- MTG
        choppy = 1,
        oddly_breakable_by_hand = 1,
        flammable = 2,
        -- MCL
        handy = 1,
        axey = 1,
    },
    _mcl_blast_resistance = 1,
    _mcl_hardness = 1,
    sounds = x_farming.node_sound_wood_defaults(),
    on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        meta:set_string('x_farming_scarecrow_state', 'inactive')
        meta:set_string('infotext', 'Scarecrow - Activate with bonemeal.')
        meta:set_string('owner', '')
    end,
    after_place_node = function(pos, placer, itemstack, pointed_thing)
        if not placer then
            return
        end

        local meta = minetest.get_meta(pos)

        meta:set_string('owner', placer:get_player_name() or '')
        meta:set_string('infotext', S('Scarecrow (owned by @1) - Activate with bonemeal.', meta:get_string('owner')))
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        local player_name = clicker:get_player_name()

        if minetest.is_protected(pos, player_name)
            and not minetest.check_player_privs(player_name, 'protection_bypass')
        then
            minetest.record_protection_violation(pos, player_name)
            return itemstack
        end

        if itemstack:get_name() ~= 'x_farming:bonemeal' then
            return itemstack
        end

        local meta = minetest.get_meta(pos)
        local state = meta:get_string('x_farming_scarecrow_state')

        if state == 'inactive' then
            meta:set_string('x_farming_scarecrow_state', 'active')
            meta:set_string('infotext', S('Scarecrow (owned by @1) - Active', meta:get_string('owner')))
            minetest.swap_node(pos, { name = 'x_farming:scarecrow_2', param2 = node.param2 })
            meta:set_int('x_farming_scarecrow_fails', 0)
            tick_scarecrow(pos)
            itemstack:take_item()
        end

        return itemstack
    end,
})

minetest.register_node('x_farming:scarecrow_2', {
    description = S('Scarecrow 2'),
    short_description = S('Scarecrow 2'),
    drawtype = 'mesh',
    mesh = 'x_farming_scarecrow_2.obj',
    tiles = { 'x_farming_scarecrow_2.png' },
    use_texture_alpha = 'clip',
    inventory_image = 'x_farming_scarecrow_1_item.png',
    wield_image = 'x_farming_scarecrow_1_item.png',
    paramtype = 'light',
    sunlight_propagates = true,
    paramtype2 = 'facedir',
    is_ground_content = false,
    walkable = true,
    drop = 'x_farming:scarecrow',
    selection_box = {
        type = 'fixed',
        fixed = { -0.4, -0.5, -0.4, 0.4, 1.5, 0.4 }
    },
    collision_box = {
        type = 'fixed',
        fixed = { -0.4, -0.5, -0.4, 0.4, 1.5, 0.4 }
    },
    groups = {
        -- MTG
        choppy = 1,
        oddly_breakable_by_hand = 1,
        flammable = 2,
        not_in_creative_inventory = 1,
        -- MCL
        handy = 1,
        axey = 1,
    },
    _mcl_blast_resistance = 1,
    _mcl_hardness = 1,
    sounds = x_farming.node_sound_wood_defaults(),
    on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        meta:set_string('x_farming_scarecrow_state', 'active')
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        local player_name = clicker:get_player_name()

        if minetest.is_protected(pos, player_name)
            and not minetest.check_player_privs(player_name, 'protection_bypass')
        then
            minetest.record_protection_violation(pos, player_name)
            return itemstack
        end

        local meta = minetest.get_meta(pos)
        local state = meta:get_string('x_farming_scarecrow_state')

        if state == 'active' then
            meta:set_string('x_farming_scarecrow_state', 'inactive')
            meta:set_string('infotext', S('Scarecrow (owned by @1) - Activate with bonemeal.', meta:get_string('owner')))
            minetest.swap_node(pos, { name = 'x_farming:scarecrow', param2 = node.param2 })
        end

        return itemstack
    end,
    on_timer = function(pos, elapsed)
        local meta = minetest.get_meta(pos)
        local state = meta:get_string('x_farming_scarecrow_state')
        local fails = meta:get_int('x_farming_scarecrow_fails')
        local player_name = meta:get_string('owner')
        local player = minetest.get_player_by_name(player_name)
        local node = minetest.get_node(pos)

        if not player then
            return true
        end

        if minetest.is_protected(pos, player_name)
            and not minetest.check_player_privs(player_name, 'protection_bypass')
        then
            return true
        end

        if state ~= 'active' then
            return false
        end

        -- bonemeal it
        local positions_raw = minetest.find_nodes_in_area(
            vector.subtract(vector.new(pos), 5),
            vector.add(vector.new(pos), 5),
            {
                'group:sand',
                'group:soil',
                'group:seed',
                'group:plant'
            }
        )

        local positions = {}

        for _, p in ipairs(positions_raw) do
            local n = minetest.get_node(p)
            if minetest.get_item_group(n.name, 'field') == 0 then
                local n_above = minetest.get_node(vector.new(p.x, p.y + 1, p.z))

                if minetest.get_item_group(n.name, 'seed') > 0 or minetest.get_item_group(n.name, 'plant') > 0 then
                    local ndef = minetest.registered_nodes[n.name]

                    if ndef.next_plant
                        and ndef.next_plant ~= 'x_farming:pumpkin_fruit'
                        and ndef.next_plant ~= 'x_farming:melon_fruit'
                    then
                        table.insert(positions, p)
                    end
                elseif n_above.name == 'air' then
                    table.insert(positions, p)
                end
            end
        end

        if #positions == 0 then
            meta:set_string('x_farming_scarecrow_state', 'inactive')
            meta:set_string('infotext', S('Scarecrow (owned by @1) - Activate with bonemeal.', meta:get_string('owner')))
            minetest.swap_node(pos, { name = 'x_farming:scarecrow', param2 = node.param2 })

            return false
        end

        local pos_rand = positions[math.random(1, #positions)]

        local pointed_thing = {
            type = 'node',
            under = pos_rand,
            above = vector.new(pos_rand.x, pos_rand.y + 1, pos_rand.z),
        }

        local result = x_farming.x_bonemeal:on_use(ItemStack({ name = 'x_farming:bonemeal' }), player, pointed_thing)

        if not result.success then
            fails = fails + 1
            meta:set_int('x_farming_scarecrow_fails', fails)
        end

        if fails < 7 then
            tick_scarecrow(pos)
        else
            meta:set_string('x_farming_scarecrow_state', 'inactive')
            meta:set_string('infotext', S('Scarecrow (owned by @1) - Activate with bonemeal.', meta:get_string('owner')))
            minetest.swap_node(pos, { name = 'x_farming:scarecrow', param2 = node.param2 })

            return false
        end
    end,
})

-- Honey
minetest.register_node('x_farming:honey_block', {
    description = S('Honey Block'),
    short_description = S('Honey Block'),
    drawtype = 'mesh',
    mesh = 'x_farming_honey.obj',
    tiles = { 'x_farming_honey_block_mesh.png' },
    use_texture_alpha = 'blend',
    paramtype = 'light',
    sunlight_propagates = true,
    groups = {
        -- MTG
        snappy = 3,
        disable_jump = 1,
        -- MCL
        handy = 1,
        hoey = 1,
        swordy = 1,
        deco_block = 1,
        -- ALL
        fall_damage_add_percent = -80,
    },
    collision_box = {
        type = 'fixed',
        fixed = { -0.3, -0.3, -0.3, 0.3, 0.3, 0.3 }
    },
    _mcl_blast_resistance = 0,
    _mcl_hardness = 0,
    sounds = x_farming.node_sound_slime_defaults(),
    move_resistance = 7,
})

minetest.register_node('x_farming:honeycomb_block', {
    description = S('Honeycomb Block'),
    short_description = S('Honeeycomb Block'),
    tiles = { 'x_farming_honeycomb_block.png' },
    paramtype = 'light',
    groups = {
        -- MTG
        crumbly = 3,
        -- MCL
        handy = 1,
        deco_block = 1,
    },
    _mcl_blast_resistance = 0.6,
    _mcl_hardness = 0.6,
    sounds = x_farming.node_sound_dirt_defaults()
})

--
-- Convert farming soils - copy from MTG
--

if not minetest.get_modpath('farming') then
    minetest.register_abm({
        label = 'X Farming soil',
        nodenames = { 'group:field' },
        interval = 15,
        chance = 4,
        action = function(pos, node)
            local n_def = minetest.registered_nodes[node.name] or nil
            local wet = n_def.soil.wet or nil
            local base = n_def.soil.base or nil
            local dry = n_def.soil.dry or nil
            if not n_def or not n_def.soil or not wet or not base or not dry then
                return
            end

            pos.y = pos.y + 1
            local nn = minetest.get_node_or_nil(pos)
            if not nn or not nn.name then
                return
            end
            local nn_def = minetest.registered_nodes[nn.name] or nil
            pos.y = pos.y - 1

            if nn_def and nn_def.walkable and minetest.get_item_group(nn.name, 'plant') == 0 then
                minetest.set_node(pos, { name = base })
                return
            end
            -- check if there is water nearby
            local wet_lvl = minetest.get_item_group(node.name, 'wet')
            if minetest.find_node_near(pos, 3, { 'group:water' }) then
                -- if it is dry soil and not base node, turn it into wet soil
                if wet_lvl == 0 then
                    minetest.set_node(pos, { name = wet })
                end
            else
                -- only turn back if there are no unloaded blocks (and therefore
                -- possible water sources) nearby
                if not minetest.find_node_near(pos, 3, { 'ignore' }) then
                    -- turn it back into base if it is already dry
                    if wet_lvl == 0 then
                        -- only turn it back if there is no plant/seed on top of it
                        if minetest.get_item_group(nn.name, 'plant') == 0 and minetest.get_item_group(nn.name, 'seed') == 0 then
                            minetest.set_node(pos, { name = base })
                        end
                    elseif wet_lvl == 1 then
                        -- if its wet turn it back into dry soil
                        minetest.set_node(pos, { name = dry })
                    end
                end
            end
        end,
    })
end
