## Classes

<dl>
<dt><a href="#ApiComponent">ApiComponent</a></dt>
<dd><p>API - Exposed to 3rd party</p></dd>
</dl>

## Typedefs

<dl>
<dt><a href="#ApiDef">ApiDef</a> : <code>Object</code></dt>
<dd><p>Represents a single API definition.</p></dd>
<dt><a href="#ApiDefs">ApiDefs</a> : <code>Object.&lt;string, ApiDef&gt;</code></dt>
<dd><p>Represents a collection of API definitions.</p></dd>
</dl>

<a name="ApiComponent"></a>

## ApiComponent

<p>API - Exposed to 3rd party</p>

**Kind**: global class

- [ApiComponent](#ApiComponent)
    - [new ApiComponent()](#new_ApiComponent_new)
    - [.initSpawner([defs])](#ApiComponent+initSpawner) ⇒ <code>SpawnerComponent</code>
    - [.initSpawnerEnv([defs])](#ApiComponent+initSpawnerEnv) ⇒ <code>SpawnerComponent</code>
    - [.registerCraft(recipe)](#ApiComponent+registerCraft)
    - [.addDefs(defs)](#ApiComponent+addDefs)
    - [.getDefByMobName(mobName)](#ApiComponent+getDefByMobName) ⇒ [<code>ApiDef</code>](#ApiDef) \| <code>undefined</code>
    - [.getEnvDefsData()](#ApiComponent+getEnvDefsData) ⇒ [<code>Array.&lt;ApiDef&gt;</code>](#ApiDef)

<a name="new_ApiComponent_new"></a>

### new ApiComponent()

<p>Creates an instance of ApiComponent.
Implements a singleton pattern.</p>

<a name="ApiComponent+initSpawner"></a>

### apiComponent.initSpawner([defs]) ⇒ <code>SpawnerComponent</code>

<p>Initializes a spawner component.</p>

**Kind**: instance method of [<code>ApiComponent</code>](#ApiComponent)  
**Returns**: <code>SpawnerComponent</code> - <p>The initialized spawner component.</p>

| Param  | Type                             | Description                                                 |
| ------ | -------------------------------- | ----------------------------------------------------------- |
| [defs] | [<code>ApiDefs</code>](#ApiDefs) | <p>Optional definitions to initialize the spawner with.</p> |

<a name="ApiComponent+initSpawnerEnv"></a>

### apiComponent.initSpawnerEnv([defs]) ⇒ <code>SpawnerComponent</code>

<p>Initializes a spawner environment component.</p>

**Kind**: instance method of [<code>ApiComponent</code>](#ApiComponent)  
**Returns**: <code>SpawnerComponent</code> - <p>The initialized spawner environment component.</p>

| Param  | Type                             | Description                                                             |
| ------ | -------------------------------- | ----------------------------------------------------------------------- |
| [defs] | [<code>ApiDefs</code>](#ApiDefs) | <p>Optional definitions to initialize the spawner environment with.</p> |

<a name="ApiComponent+registerCraft"></a>

### apiComponent.registerCraft(recipe)

<p>Registers a crafting recipe.</p>

**Kind**: instance method of [<code>ApiComponent</code>](#ApiComponent)

| Param  | Type             | Description                             |
| ------ | ---------------- | --------------------------------------- |
| recipe | <code>any</code> | <p>The crafting recipe to register.</p> |

<a name="ApiComponent+addDefs"></a>

### apiComponent.addDefs(defs)

<p>Merges and adds new definitions to the existing ones.</p>

**Kind**: instance method of [<code>ApiComponent</code>](#ApiComponent)

| Param | Type                             | Description                    |
| ----- | -------------------------------- | ------------------------------ |
| defs  | [<code>ApiDefs</code>](#ApiDefs) | <p>The definitions to add.</p> |

<a name="ApiComponent+getDefByMobName"></a>

### apiComponent.getDefByMobName(mobName) ⇒ [<code>ApiDef</code>](#ApiDef) \| <code>undefined</code>

<p>Finds a definition based on the mob name.</p>

**Kind**: instance method of [<code>ApiComponent</code>](#ApiComponent)  
**Returns**: [<code>ApiDef</code>](#ApiDef) \| <code>undefined</code> - <p>The definition for the mob, or undefined if not found.</p>

| Param   | Type                | Description                               |
| ------- | ------------------- | ----------------------------------------- |
| mobName | <code>string</code> | <p>The name of the mob to search for.</p> |

<a name="ApiComponent+getEnvDefsData"></a>

### apiComponent.getEnvDefsData() ⇒ [<code>Array.&lt;ApiDef&gt;</code>](#ApiDef)

<p>Retrieves environment definitions with additional node data.</p>

**Kind**: instance method of [<code>ApiComponent</code>](#ApiComponent)  
**Returns**: [<code>Array.&lt;ApiDef&gt;</code>](#ApiDef) - <p>An array of environment definitions with merged node data.</p>  
<a name="ApiDef"></a>

## ApiDef : <code>Object</code>

<p>Represents a single API definition.</p>

**Kind**: global typedef  
**Properties**

| Name       | Type                | Description                                       |
| ---------- | ------------------- | ------------------------------------------------- |
| [mob]      | <code>Object</code> | <p>The mob-related data.</p>                      |
| [mob.name] | <code>string</code> | <p>The name of the mob.</p>                       |
| [node]     | <code>Object</code> | <p>The node-related data.</p>                     |
| [nodeEnv]  | <code>Object</code> | <p>Additional environment-specific node data.</p> |

<a name="ApiDefs"></a>

## ApiDefs : <code>Object.&lt;string, ApiDef&gt;</code>

<p>Represents a collection of API definitions.</p>

**Kind**: global typedef
