## Classes

<dl>
<dt><a href="#ApiComponent">ApiComponent</a></dt>
<dd><p>API - Exposed to 3rd party</p></dd>
</dl>

## Typedefs

<dl>
<dt><a href="#ApiDef">ApiDef</a> : <code>Object</code></dt>
<dd><p>Represents a single API definition.</p></dd>
<dt><a href="#ApiDefNode">ApiDefNode</a> : <code>Object</code></dt>
<dd><p>Represents the node-related data for an API definition.</p></dd>
<dt><a href="#ApiDefs">ApiDefs</a> : <code>Object.&lt;string, ApiDef&gt;</code></dt>
<dd><p>Represents a collection of API definitions.</p></dd>
</dl>

<a name="ApiComponent"></a>

## ApiComponent

<p>API - Exposed to 3rd party</p>

**Kind**: global class

- [ApiComponent](#ApiComponent)
    - [new ApiComponent()](#new_ApiComponent_new)
    - [.initSpawner([defs])](#ApiComponent+initSpawner) ⇒ <code>SpawnerComponent</code>
    - [.initSpawnerEnv([defs])](#ApiComponent+initSpawnerEnv) ⇒ <code>SpawnerComponent</code>
    - [.registerCraft(recipe)](#ApiComponent+registerCraft)
    - [.addDefs(defs)](#ApiComponent+addDefs)
    - [.getDefByMobName(mobName)](#ApiComponent+getDefByMobName) ⇒ [<code>ApiDef</code>](#ApiDef) \| <code>undefined</code>
    - [.setEnvDefsData()](#ApiComponent+setEnvDefsData) ⇒ [<code>Array.&lt;ApiDef&gt;</code>](#ApiDef)

<a name="new_ApiComponent_new"></a>

### new ApiComponent()

<p>Creates an instance of ApiComponent.
Implements a singleton pattern.</p>

<a name="ApiComponent+initSpawner"></a>

### apiComponent.initSpawner([defs]) ⇒ <code>SpawnerComponent</code>

<p>Initializes a spawner component.</p>

**Kind**: instance method of [<code>ApiComponent</code>](#ApiComponent)  
**Returns**: <code>SpawnerComponent</code> - <p>The initialized spawner component.</p>

| Param  | Type                             | Description                                                 |
| ------ | -------------------------------- | ----------------------------------------------------------- |
| [defs] | [<code>ApiDefs</code>](#ApiDefs) | <p>Optional definitions to initialize the spawner with.</p> |

<a name="ApiComponent+initSpawnerEnv"></a>

### apiComponent.initSpawnerEnv([defs]) ⇒ <code>SpawnerComponent</code>

<p>Initializes a spawner environment component.</p>

**Kind**: instance method of [<code>ApiComponent</code>](#ApiComponent)  
**Returns**: <code>SpawnerComponent</code> - <p>The initialized spawner environment component.</p>

| Param  | Type                             | Description                                                             |
| ------ | -------------------------------- | ----------------------------------------------------------------------- |
| [defs] | [<code>ApiDefs</code>](#ApiDefs) | <p>Optional definitions to initialize the spawner environment with.</p> |

<a name="ApiComponent+registerCraft"></a>

### apiComponent.registerCraft(recipe)

<p>Registers a crafting recipe.</p>

**Kind**: instance method of [<code>ApiComponent</code>](#ApiComponent)

| Param  | Type             | Description                             |
| ------ | ---------------- | --------------------------------------- |
| recipe | <code>any</code> | <p>The crafting recipe to register.</p> |

<a name="ApiComponent+addDefs"></a>

### apiComponent.addDefs(defs)

<p>Merges and adds new definitions to the existing ones.</p>

**Kind**: instance method of [<code>ApiComponent</code>](#ApiComponent)

| Param | Type                             | Description                    |
| ----- | -------------------------------- | ------------------------------ |
| defs  | [<code>ApiDefs</code>](#ApiDefs) | <p>The definitions to add.</p> |

<a name="ApiComponent+getDefByMobName"></a>

### apiComponent.getDefByMobName(mobName) ⇒ [<code>ApiDef</code>](#ApiDef) \| <code>undefined</code>

<p>Finds a definition based on the mob name.</p>

**Kind**: instance method of [<code>ApiComponent</code>](#ApiComponent)  
**Returns**: [<code>ApiDef</code>](#ApiDef) \| <code>undefined</code> - <p>The definition for the mob, or undefined if not found.</p>

| Param   | Type                | Description                               |
| ------- | ------------------- | ----------------------------------------- |
| mobName | <code>string</code> | <p>The name of the mob to search for.</p> |

<a name="ApiComponent+setEnvDefsData"></a>

### apiComponent.setEnvDefsData() ⇒ [<code>Array.&lt;ApiDef&gt;</code>](#ApiDef)

<p>Retrieves environment definitions with additional node data.</p>

**Kind**: instance method of [<code>ApiComponent</code>](#ApiComponent)  
**Returns**: [<code>Array.&lt;ApiDef&gt;</code>](#ApiDef) - <p>An array of environment definitions with merged node data.</p>  
<a name="ApiDef"></a>

## ApiDef : <code>Object</code>

<p>Represents a single API definition.</p>

**Kind**: global typedef  
**Properties**

| Name                   | Type                                                     | Description                                                         |
| ---------------------- | -------------------------------------------------------- | ------------------------------------------------------------------- |
| node                   | [<code>ApiDefNode</code>](#ApiDefNode)                   | <p>The primary node-related data.</p>                               |
| [nodeEnv]              | [<code>Partial.&lt;ApiDefNode&gt;</code>](#ApiDefNode)   | <p>Additional environment-specific node data.</p>                   |
| entity                 | <code>Object</code>                                      | <p>The entity-related data.</p>                                     |
| [entity.mesh]          | <code>string</code>                                      | <p>The mesh used for the entity.</p>                                |
| [entity.visualSize]    | <code>Vector</code>                                      | <p>The visual size of the entity.</p>                               |
| [entity.textures]      | <code>string</code> \| <code>Array.&lt;string&gt;</code> | <p>The textures applied to the entity.</p>                          |
| [entity.sounds]        | <code>Object</code> \| <code>Array.&lt;Object&gt;</code> | <p>The sounds associated with the entity.</p>                       |
| [entity.sounds.simple] | <code>any</code>                                         | <p>Simple sound data.</p>                                           |
| [entity.sounds.params] | <code>any</code>                                         | <p>Parameters for the sound.</p>                                    |
| [entity.offset]        | <code>Vector</code>                                      | <p>The offset for the entity's position.</p>                        |
| mob                    | <code>Object</code>                                      | <p>The mob-related data.</p>                                        |
| [mob.name]             | <code>string</code>                                      | <p>The name of the mob.</p>                                         |
| [mob.mobHeight]        | <code>number</code>                                      | <p>The height of the mob. (used only internally)</p>                |
| [mob.getStaticdata]    | <code>function</code>                                    | <p>A function to retrieve static data for the mob.</p>              |
| [getDefFromStack]      | <code>function</code>                                    | <p>A function to retrieve an API definition from an item stack.</p> |

<a name="ApiDefNode"></a>

## ApiDefNode : <code>Object</code>

<p>Represents the node-related data for an API definition.</p>

**Kind**: global typedef  
**Properties**

| Name        | Type                              | Description                                                      |
| ----------- | --------------------------------- | ---------------------------------------------------------------- |
| [nightOnly] | <code>boolean</code>              | <p>Whether the node is active only at night.</p>                 |
| [dayOnly]   | <code>boolean</code>              | <p>Whether the node is active only during the day.</p>           |
| [minLight]  | <code>number</code>               | <p>The minimum light level required for the node. (not used)</p> |
| [maxLight]  | <code>number</code>               | <p>The maximum light level allowed for the node. (not used)</p>  |
| [nodes]     | <code>Array.&lt;string&gt;</code> | <p>A list of node names associated with this definition.</p>     |

<a name="ApiDefs"></a>

## ApiDefs : <code>Object.&lt;string, ApiDef&gt;</code>

<p>Represents a collection of API definitions.</p>

**Kind**: global typedef
