--[[ Generated with https://github.com/TypeScriptToLua/TypeScriptToLua ]]

local ____modules = {}
local ____moduleCache = {}
local ____originalRequire = require
local function require(file, ...)
    if ____moduleCache[file] then
        return ____moduleCache[file].value
    end
    if ____modules[file] then
        local module = ____modules[file]
        local value = nil
        if (select("#", ...) > 0) then value = module(...) else value = module(file) end
        ____moduleCache[file] = { value = value }
        return value
    else
        if ____originalRequire then
            return ____originalRequire(file)
        else
            error("module '" .. file .. "' not found")
        end
    end
end
____modules = {
["lualib_bundle"] = function(...) 
local function __TS__Class(self)
    local c = {prototype = {}}
    c.prototype.__index = c.prototype
    c.prototype.constructor = c
    return c
end

local function __TS__ObjectAssign(target, ...)
    local sources = {...}
    for i = 1, #sources do
        local source = sources[i]
        for key in pairs(source) do
            target[key] = source[key]
        end
    end
    return target
end

local function __TS__ArrayFind(self, predicate, thisArg)
    for i = 1, #self do
        local elem = self[i]
        if predicate(thisArg, elem, i - 1, self) then
            return elem
        end
    end
    return nil
end

local function __TS__ArrayForEach(self, callbackFn, thisArg)
    for i = 1, #self do
        callbackFn(thisArg, self[i], i - 1, self)
    end
end

local function __TS__ArrayFilter(self, callbackfn, thisArg)
    local result = {}
    local len = 0
    for i = 1, #self do
        if callbackfn(thisArg, self[i], i - 1, self) then
            len = len + 1
            result[len] = self[i]
        end
    end
    return result
end

local __TS__Symbol, Symbol
do
    local symbolMetatable = {__tostring = function(self)
        return ("Symbol(" .. (self.description or "")) .. ")"
    end}
    function __TS__Symbol(description)
        return setmetatable({description = description}, symbolMetatable)
    end
    Symbol = {
        asyncDispose = __TS__Symbol("Symbol.asyncDispose"),
        dispose = __TS__Symbol("Symbol.dispose"),
        iterator = __TS__Symbol("Symbol.iterator"),
        hasInstance = __TS__Symbol("Symbol.hasInstance"),
        species = __TS__Symbol("Symbol.species"),
        toStringTag = __TS__Symbol("Symbol.toStringTag")
    }
end

local __TS__Iterator
do
    local function iteratorGeneratorStep(self)
        local co = self.____coroutine
        local status, value = coroutine.resume(co)
        if not status then
            error(value, 0)
        end
        if coroutine.status(co) == "dead" then
            return
        end
        return true, value
    end
    local function iteratorIteratorStep(self)
        local result = self:next()
        if result.done then
            return
        end
        return true, result.value
    end
    local function iteratorStringStep(self, index)
        index = index + 1
        if index > #self then
            return
        end
        return index, string.sub(self, index, index)
    end
    function __TS__Iterator(iterable)
        if type(iterable) == "string" then
            return iteratorStringStep, iterable, 0
        elseif iterable.____coroutine ~= nil then
            return iteratorGeneratorStep, iterable
        elseif iterable[Symbol.iterator] then
            local iterator = iterable[Symbol.iterator](iterable)
            return iteratorIteratorStep, iterator
        else
            return ipairs(iterable)
        end
    end
end

local Map
do
    Map = __TS__Class()
    Map.name = "Map"
    function Map.prototype.____constructor(self, entries)
        self[Symbol.toStringTag] = "Map"
        self.items = {}
        self.size = 0
        self.nextKey = {}
        self.previousKey = {}
        if entries == nil then
            return
        end
        local iterable = entries
        if iterable[Symbol.iterator] then
            local iterator = iterable[Symbol.iterator](iterable)
            while true do
                local result = iterator:next()
                if result.done then
                    break
                end
                local value = result.value
                self:set(value[1], value[2])
            end
        else
            local array = entries
            for ____, kvp in ipairs(array) do
                self:set(kvp[1], kvp[2])
            end
        end
    end
    function Map.prototype.clear(self)
        self.items = {}
        self.nextKey = {}
        self.previousKey = {}
        self.firstKey = nil
        self.lastKey = nil
        self.size = 0
    end
    function Map.prototype.delete(self, key)
        local contains = self:has(key)
        if contains then
            self.size = self.size - 1
            local next = self.nextKey[key]
            local previous = self.previousKey[key]
            if next ~= nil and previous ~= nil then
                self.nextKey[previous] = next
                self.previousKey[next] = previous
            elseif next ~= nil then
                self.firstKey = next
                self.previousKey[next] = nil
            elseif previous ~= nil then
                self.lastKey = previous
                self.nextKey[previous] = nil
            else
                self.firstKey = nil
                self.lastKey = nil
            end
            self.nextKey[key] = nil
            self.previousKey[key] = nil
        end
        self.items[key] = nil
        return contains
    end
    function Map.prototype.forEach(self, callback)
        for ____, key in __TS__Iterator(self:keys()) do
            callback(nil, self.items[key], key, self)
        end
    end
    function Map.prototype.get(self, key)
        return self.items[key]
    end
    function Map.prototype.has(self, key)
        return self.nextKey[key] ~= nil or self.lastKey == key
    end
    function Map.prototype.set(self, key, value)
        local isNewValue = not self:has(key)
        if isNewValue then
            self.size = self.size + 1
        end
        self.items[key] = value
        if self.firstKey == nil then
            self.firstKey = key
            self.lastKey = key
        elseif isNewValue then
            self.nextKey[self.lastKey] = key
            self.previousKey[key] = self.lastKey
            self.lastKey = key
        end
        return self
    end
    Map.prototype[Symbol.iterator] = function(self)
        return self:entries()
    end
    function Map.prototype.entries(self)
        local items = self.items
        local nextKey = self.nextKey
        local key = self.firstKey
        return {
            [Symbol.iterator] = function(self)
                return self
            end,
            next = function(self)
                local result = {done = not key, value = {key, items[key]}}
                key = nextKey[key]
                return result
            end
        }
    end
    function Map.prototype.keys(self)
        local nextKey = self.nextKey
        local key = self.firstKey
        return {
            [Symbol.iterator] = function(self)
                return self
            end,
            next = function(self)
                local result = {done = not key, value = key}
                key = nextKey[key]
                return result
            end
        }
    end
    function Map.prototype.values(self)
        local items = self.items
        local nextKey = self.nextKey
        local key = self.firstKey
        return {
            [Symbol.iterator] = function(self)
                return self
            end,
            next = function(self)
                local result = {done = not key, value = items[key]}
                key = nextKey[key]
                return result
            end
        }
    end
    Map[Symbol.species] = Map
end

local function __TS__New(target, ...)
    local instance = setmetatable({}, target.prototype)
    instance:____constructor(...)
    return instance
end

local function __TS__ArraySome(self, callbackfn, thisArg)
    for i = 1, #self do
        if callbackfn(thisArg, self[i], i - 1, self) then
            return true
        end
    end
    return false
end

local __TS__StringSplit
do
    local sub = string.sub
    local find = string.find
    function __TS__StringSplit(source, separator, limit)
        if limit == nil then
            limit = 4294967295
        end
        if limit == 0 then
            return {}
        end
        local result = {}
        local resultIndex = 1
        if separator == nil or separator == "" then
            for i = 1, #source do
                result[resultIndex] = sub(source, i, i)
                resultIndex = resultIndex + 1
            end
        else
            local currentPos = 1
            while resultIndex <= limit do
                local startPos, endPos = find(source, separator, currentPos, true)
                if not startPos then
                    break
                end
                result[resultIndex] = sub(source, currentPos, startPos - 1)
                resultIndex = resultIndex + 1
                currentPos = endPos + 1
            end
            if resultIndex <= limit then
                result[resultIndex] = sub(source, currentPos)
            end
        end
        return result
    end
end

local function __TS__StringIncludes(self, searchString, position)
    if not position then
        position = 1
    else
        position = position + 1
    end
    local index = string.find(self, searchString, position, true)
    return index ~= nil
end

local function __TS__ArrayMap(self, callbackfn, thisArg)
    local result = {}
    for i = 1, #self do
        result[i] = callbackfn(thisArg, self[i], i - 1, self)
    end
    return result
end

local function __TS__ArrayIncludes(self, searchElement, fromIndex)
    if fromIndex == nil then
        fromIndex = 0
    end
    local len = #self
    local k = fromIndex
    if fromIndex < 0 then
        k = len + fromIndex
    end
    if k < 0 then
        k = 0
    end
    for i = k + 1, len do
        if self[i] == searchElement then
            return true
        end
    end
    return false
end

local function __TS__ArrayIsArray(value)
    return type(value) == "table" and (value[1] ~= nil or next(value) == nil)
end

local function __TS__CountVarargs(...)
    return select("#", ...)
end

local function __TS__SparseArrayNew(...)
    local sparseArray = {...}
    sparseArray.sparseLength = __TS__CountVarargs(...)
    return sparseArray
end

local function __TS__SparseArrayPush(sparseArray, ...)
    local args = {...}
    local argsLen = __TS__CountVarargs(...)
    local listLen = sparseArray.sparseLength
    for i = 1, argsLen do
        sparseArray[listLen + i] = args[i]
    end
    sparseArray.sparseLength = listLen + argsLen
end

local function __TS__SparseArraySpread(sparseArray)
    local _unpack = unpack or table.unpack
    return _unpack(sparseArray, 1, sparseArray.sparseLength)
end

local function __TS__ArrayEvery(self, callbackfn, thisArg)
    for i = 1, #self do
        if not callbackfn(thisArg, self[i], i - 1, self) then
            return false
        end
    end
    return true
end

local function __TS__CloneDescriptor(____bindingPattern0)
    local value
    local writable
    local set
    local get
    local configurable
    local enumerable
    enumerable = ____bindingPattern0.enumerable
    configurable = ____bindingPattern0.configurable
    get = ____bindingPattern0.get
    set = ____bindingPattern0.set
    writable = ____bindingPattern0.writable
    value = ____bindingPattern0.value
    local descriptor = {enumerable = enumerable == true, configurable = configurable == true}
    local hasGetterOrSetter = get ~= nil or set ~= nil
    local hasValueOrWritableAttribute = writable ~= nil or value ~= nil
    if hasGetterOrSetter and hasValueOrWritableAttribute then
        error("Invalid property descriptor. Cannot both specify accessors and a value or writable attribute.", 0)
    end
    if get or set then
        descriptor.get = get
        descriptor.set = set
    else
        descriptor.value = value
        descriptor.writable = writable == true
    end
    return descriptor
end

local __TS__DescriptorGet
do
    local getmetatable = _G.getmetatable
    local ____rawget = _G.rawget
    function __TS__DescriptorGet(self, metatable, key)
        while metatable do
            local rawResult = ____rawget(metatable, key)
            if rawResult ~= nil then
                return rawResult
            end
            local descriptors = ____rawget(metatable, "_descriptors")
            if descriptors then
                local descriptor = descriptors[key]
                if descriptor ~= nil then
                    if descriptor.get then
                        return descriptor.get(self)
                    end
                    return descriptor.value
                end
            end
            metatable = getmetatable(metatable)
        end
    end
end

local __TS__DescriptorSet
do
    local getmetatable = _G.getmetatable
    local ____rawget = _G.rawget
    local rawset = _G.rawset
    function __TS__DescriptorSet(self, metatable, key, value)
        while metatable do
            local descriptors = ____rawget(metatable, "_descriptors")
            if descriptors then
                local descriptor = descriptors[key]
                if descriptor ~= nil then
                    if descriptor.set then
                        descriptor.set(self, value)
                    else
                        if descriptor.writable == false then
                            error(
                                ((("Cannot assign to read only property '" .. key) .. "' of object '") .. tostring(self)) .. "'",
                                0
                            )
                        end
                        descriptor.value = value
                    end
                    return
                end
            end
            metatable = getmetatable(metatable)
        end
        rawset(self, key, value)
    end
end

local __TS__SetDescriptor
do
    local getmetatable = _G.getmetatable
    local function descriptorIndex(self, key)
        return __TS__DescriptorGet(
            self,
            getmetatable(self),
            key
        )
    end
    local function descriptorNewIndex(self, key, value)
        return __TS__DescriptorSet(
            self,
            getmetatable(self),
            key,
            value
        )
    end
    function __TS__SetDescriptor(target, key, desc, isPrototype)
        if isPrototype == nil then
            isPrototype = false
        end
        local ____isPrototype_0
        if isPrototype then
            ____isPrototype_0 = target
        else
            ____isPrototype_0 = getmetatable(target)
        end
        local metatable = ____isPrototype_0
        if not metatable then
            metatable = {}
            setmetatable(target, metatable)
        end
        local value = rawget(target, key)
        if value ~= nil then
            rawset(target, key, nil)
        end
        if not rawget(metatable, "_descriptors") then
            metatable._descriptors = {}
        end
        metatable._descriptors[key] = __TS__CloneDescriptor(desc)
        metatable.__index = descriptorIndex
        metatable.__newindex = descriptorNewIndex
    end
end

local function __TS__Number(value)
    local valueType = type(value)
    if valueType == "number" then
        return value
    elseif valueType == "string" then
        local numberValue = tonumber(value)
        if numberValue then
            return numberValue
        end
        if value == "Infinity" then
            return math.huge
        end
        if value == "-Infinity" then
            return -math.huge
        end
        local stringWithoutSpaces = string.gsub(value, "%s", "")
        if stringWithoutSpaces == "" then
            return 0
        end
        return 0 / 0
    elseif valueType == "boolean" then
        return value and 1 or 0
    else
        return 0 / 0
    end
end

local Set
do
    Set = __TS__Class()
    Set.name = "Set"
    function Set.prototype.____constructor(self, values)
        self[Symbol.toStringTag] = "Set"
        self.size = 0
        self.nextKey = {}
        self.previousKey = {}
        if values == nil then
            return
        end
        local iterable = values
        if iterable[Symbol.iterator] then
            local iterator = iterable[Symbol.iterator](iterable)
            while true do
                local result = iterator:next()
                if result.done then
                    break
                end
                self:add(result.value)
            end
        else
            local array = values
            for ____, value in ipairs(array) do
                self:add(value)
            end
        end
    end
    function Set.prototype.add(self, value)
        local isNewValue = not self:has(value)
        if isNewValue then
            self.size = self.size + 1
        end
        if self.firstKey == nil then
            self.firstKey = value
            self.lastKey = value
        elseif isNewValue then
            self.nextKey[self.lastKey] = value
            self.previousKey[value] = self.lastKey
            self.lastKey = value
        end
        return self
    end
    function Set.prototype.clear(self)
        self.nextKey = {}
        self.previousKey = {}
        self.firstKey = nil
        self.lastKey = nil
        self.size = 0
    end
    function Set.prototype.delete(self, value)
        local contains = self:has(value)
        if contains then
            self.size = self.size - 1
            local next = self.nextKey[value]
            local previous = self.previousKey[value]
            if next ~= nil and previous ~= nil then
                self.nextKey[previous] = next
                self.previousKey[next] = previous
            elseif next ~= nil then
                self.firstKey = next
                self.previousKey[next] = nil
            elseif previous ~= nil then
                self.lastKey = previous
                self.nextKey[previous] = nil
            else
                self.firstKey = nil
                self.lastKey = nil
            end
            self.nextKey[value] = nil
            self.previousKey[value] = nil
        end
        return contains
    end
    function Set.prototype.forEach(self, callback)
        for ____, key in __TS__Iterator(self:keys()) do
            callback(nil, key, key, self)
        end
    end
    function Set.prototype.has(self, value)
        return self.nextKey[value] ~= nil or self.lastKey == value
    end
    Set.prototype[Symbol.iterator] = function(self)
        return self:values()
    end
    function Set.prototype.entries(self)
        local nextKey = self.nextKey
        local key = self.firstKey
        return {
            [Symbol.iterator] = function(self)
                return self
            end,
            next = function(self)
                local result = {done = not key, value = {key, key}}
                key = nextKey[key]
                return result
            end
        }
    end
    function Set.prototype.keys(self)
        local nextKey = self.nextKey
        local key = self.firstKey
        return {
            [Symbol.iterator] = function(self)
                return self
            end,
            next = function(self)
                local result = {done = not key, value = key}
                key = nextKey[key]
                return result
            end
        }
    end
    function Set.prototype.values(self)
        local nextKey = self.nextKey
        local key = self.firstKey
        return {
            [Symbol.iterator] = function(self)
                return self
            end,
            next = function(self)
                local result = {done = not key, value = key}
                key = nextKey[key]
                return result
            end
        }
    end
    function Set.prototype.union(self, other)
        local result = __TS__New(Set, self)
        for ____, item in __TS__Iterator(other) do
            result:add(item)
        end
        return result
    end
    function Set.prototype.intersection(self, other)
        local result = __TS__New(Set)
        for ____, item in __TS__Iterator(self) do
            if other:has(item) then
                result:add(item)
            end
        end
        return result
    end
    function Set.prototype.difference(self, other)
        local result = __TS__New(Set, self)
        for ____, item in __TS__Iterator(other) do
            result:delete(item)
        end
        return result
    end
    function Set.prototype.symmetricDifference(self, other)
        local result = __TS__New(Set, self)
        for ____, item in __TS__Iterator(other) do
            if self:has(item) then
                result:delete(item)
            else
                result:add(item)
            end
        end
        return result
    end
    function Set.prototype.isSubsetOf(self, other)
        for ____, item in __TS__Iterator(self) do
            if not other:has(item) then
                return false
            end
        end
        return true
    end
    function Set.prototype.isSupersetOf(self, other)
        for ____, item in __TS__Iterator(other) do
            if not self:has(item) then
                return false
            end
        end
        return true
    end
    function Set.prototype.isDisjointFrom(self, other)
        for ____, item in __TS__Iterator(self) do
            if other:has(item) then
                return false
            end
        end
        return true
    end
    Set[Symbol.species] = Set
end

local function __TS__StringAccess(self, index)
    if index >= 0 and index < #self then
        return string.sub(self, index + 1, index + 1)
    end
end

local __TS__Unpack = table.unpack or unpack

local function __TS__Spread(iterable)
    local arr = {}
    if type(iterable) == "string" then
        for i = 0, #iterable - 1 do
            arr[i + 1] = __TS__StringAccess(iterable, i)
        end
    else
        local len = 0
        for ____, item in __TS__Iterator(iterable) do
            len = len + 1
            arr[len] = item
        end
    end
    return __TS__Unpack(arr)
end

local function __TS__ObjectKeys(obj)
    local result = {}
    local len = 0
    for key in pairs(obj) do
        len = len + 1
        result[len] = key
    end
    return result
end

local function __TS__ArrayReduce(self, callbackFn, ...)
    local len = #self
    local k = 0
    local accumulator = nil
    if __TS__CountVarargs(...) ~= 0 then
        accumulator = ...
    elseif len > 0 then
        accumulator = self[1]
        k = 1
    else
        error("Reduce of empty array with no initial value", 0)
    end
    for i = k + 1, len do
        accumulator = callbackFn(
            nil,
            accumulator,
            self[i],
            i - 1,
            self
        )
    end
    return accumulator
end

local function __TS__ObjectValues(obj)
    local result = {}
    local len = 0
    for key in pairs(obj) do
        len = len + 1
        result[len] = obj[key]
    end
    return result
end

return {
  __TS__Class = __TS__Class,
  __TS__ObjectAssign = __TS__ObjectAssign,
  __TS__ArrayFind = __TS__ArrayFind,
  __TS__ArrayForEach = __TS__ArrayForEach,
  __TS__ArrayFilter = __TS__ArrayFilter,
  Map = Map,
  __TS__New = __TS__New,
  __TS__ArraySome = __TS__ArraySome,
  __TS__StringSplit = __TS__StringSplit,
  __TS__StringIncludes = __TS__StringIncludes,
  __TS__ArrayMap = __TS__ArrayMap,
  __TS__ArrayIncludes = __TS__ArrayIncludes,
  __TS__ArrayIsArray = __TS__ArrayIsArray,
  __TS__SparseArrayNew = __TS__SparseArrayNew,
  __TS__SparseArrayPush = __TS__SparseArrayPush,
  __TS__SparseArraySpread = __TS__SparseArraySpread,
  __TS__ArrayEvery = __TS__ArrayEvery,
  __TS__SetDescriptor = __TS__SetDescriptor,
  __TS__Number = __TS__Number,
  Set = Set,
  __TS__Spread = __TS__Spread,
  __TS__ObjectKeys = __TS__ObjectKeys,
  __TS__ArrayReduce = __TS__ArrayReduce,
  __TS__ObjectValues = __TS__ObjectValues
}
 end,
["src.components.sounds.component"] = function(...) 
local ____lualib = require("lualib_bundle")
local __TS__Class = ____lualib.__TS__Class
local __TS__ObjectAssign = ____lualib.__TS__ObjectAssign
local ____exports = {}
____exports.default = __TS__Class()
local Sounds = ____exports.default
Sounds.name = "Sounds"
function Sounds.prototype.____constructor(self)
end
function Sounds.prototype.getNodeSoundMetal(self, config)
    if config == nil then
        config = {}
    end
    local _config = {footstep = {name = "x_spawners_api_metal_footstep", gain = 0.1}, dig = {name = "x_spawners_api_metal_hit", gain = 0.5}, dug = {name = "x_spawners_api_metal_dug", gain = 0.1}, place = {name = "x_spawners_api_metal_place", gain = 0.15}}
    return __TS__ObjectAssign({}, _config, config)
end
return ____exports
 end,
["src.models.particlespawner.model"] = function(...) 
local ____lualib = require("lualib_bundle")
local __TS__Class = ____lualib.__TS__Class
local ____exports = {}
____exports.default = __TS__Class()
local ParticleSpawnerModel = ____exports.default
ParticleSpawnerModel.name = "ParticleSpawnerModel"
function ParticleSpawnerModel.prototype.____constructor(self)
    self.flame = self.getFlameDef
    self.smoke = self.getSmokeDef
    self.smokePuff = self.getSmokePuffDef
    self.flamePuff = self.getFlamePuffDef
    self.isInWater = false
end
function ParticleSpawnerModel.prototype.getFlameDef(self, pos)
    local texture = "x_spawners_api_flame.png"
    if self.isInWater then
        texture = "x_spawners_api_bubble.png"
    end
    return {
        amount = 20,
        time = 0,
        pos = pos,
        vel = {
            min = vector.new(-0.05, -0.05, -0.05),
            max = vector.new(0.05, 0.05, 0.05)
        },
        acc = {
            min = vector.new(0.05, 0.05, 0.05),
            max = vector.new(0.1, 0.1, 0.1)
        },
        jitter = {
            min = vector.new(-0.05, -0.05, -0.05),
            max = vector.new(0.05, 0.05, 0.05),
            bias = -1
        },
        exptime = {min = 1.5, max = 2},
        size = {min = 2, max = 3},
        texture = {name = texture, alpha_tween = {0, 1}, scale_tween = {1, 0.33}},
        radius = {
            min = vector.new(-0.4, -0.4, -0.4),
            max = vector.new(0.4, 0.4, 0.4),
            bias = 1
        },
        attract = {kind = "point", strength = -1, origin = pos},
        glow = 7
    }
end
function ParticleSpawnerModel.prototype.getSmokeDef(self, pos)
    local texture = "x_spawners_api_smoke_animated.png"
    if self.isInWater then
        texture = "x_spawners_api_bubble_animated.png"
    end
    local def = {
        amount = 3,
        time = 0,
        pos = {
            min = vector.subtract(pos, 0.4),
            max = vector.add(pos, 0.4)
        },
        vel = {
            min = vector.new(-0.1, 1, -0.1),
            max = vector.new(0.1, 1.5, 0.1)
        },
        acc = {
            min = vector.new(-0.1, 0.5, -0.1),
            max = vector.new(0.1, 1, 0.1)
        },
        jitter = {
            min = vector.new(-1, 0, -1),
            max = vector.new(1, 0, 1)
        },
        exptime = {min = 1, max = 2},
        size = {min = 4, max = 8},
        texture = {name = texture, alpha_tween = {0.75, 1}, scale_tween = {1.25, 0.75}},
        attract = {kind = "plane", strength = -2, origin = pos},
        animation = {type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = -1}
    }
    return def
end
function ParticleSpawnerModel.prototype.getSmokePuffDef(self, pos)
    local texture = "x_spawners_api_smoke_2.png"
    if self.isInWater then
        texture = "x_spawners_api_bubble_animated.png"
    end
    return {
        amount = 5,
        time = 1,
        pos = {
            min = vector.subtract(
                vector.new(pos.x - 0.3, pos.y, pos.z - 0.3),
                0.3
            ),
            max = vector.add(
                vector.new(pos.x + 0.3, pos.y, pos.z + 0.3),
                0.3
            )
        },
        vel = {
            min = vector.new(0.1, 0.1, 0.1),
            max = vector.new(0.2, 0.2, 0.2)
        },
        acc = {
            min = vector.new(-0.1, 0.3, -0.1),
            max = vector.new(0.1, 0.6, 0.1)
        },
        jitter = {
            min = vector.new(-1, 0, -1),
            max = vector.new(1, 0, 1)
        },
        exptime = {min = 2, max = 3},
        size = {min = 16, max = 24},
        texture = {name = texture, alpha_tween = {1, 0.75}, scale_tween = {0.75, 1.25}},
        animation = {type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = -1}
    }
end
function ParticleSpawnerModel.prototype.getFlamePuffDef(self, pos)
    local texture = "x_spawners_api_flame.png"
    if self.isInWater then
        texture = "x_spawners_api_bubble.png"
    end
    return {
        amount = 100,
        time = 0.1,
        pos = pos,
        jitter = {
            min = vector.new(-1, -1, -1),
            max = vector.new(1, 1, 1)
        },
        exptime = {min = 2, max = 3},
        size = {min = 0.5, max = 2.5},
        texture = {name = texture, alpha_tween = {1, 0}, scale_tween = {1, 0.5}},
        radius = {
            min = vector.new(-1.5, -1.5, -1.5),
            max = vector.new(1.5, 1.5, 1.5)
        },
        glow = 7
    }
end
function ParticleSpawnerModel.prototype.getDef(self, particleID, pos)
    if not self[particleID] then
        return {}
    end
    return self[particleID](self, pos)
end
function ParticleSpawnerModel.prototype.add(self, particleIDs, pos, isInWater)
    if isInWater == nil then
        isInWater = false
    end
    self.isInWater = isInWater
    local _particleIDs = type(particleIDs) == "string" and ({particleIDs}) or particleIDs
    local resIDs = {}
    for ____, particleID in ipairs(_particleIDs) do
        local id = particleID
        resIDs[id] = core.add_particlespawner(self:getDef(id, pos))
    end
    return resIDs
end
function ParticleSpawnerModel.prototype.delete(self, ids)
    local _ids = type(ids) == "number" and ({ids}) or ids
    for ____, id in ipairs(_ids) do
        core.delete_particlespawner(id)
    end
end
return ____exports
 end,
["src.utils.string.utils"] = function(...) 
--[[ Generated with https://github.com/TypeScriptToLua/TypeScriptToLua ]]
local ____exports = {}
____exports.capitalizeFirstLetter = function(____, val)
    return string.upper(string.sub(val, 1, 1)) .. string.sub(val, 2)
end
return ____exports
 end,
["src.utils.math.utils"] = function(...) 
--[[ Generated with https://github.com/TypeScriptToLua/TypeScriptToLua ]]
local ____exports = {}
local MathUtils = {getRandomIntInclusive = function(____, min, max)
    local minCeiled = math.ceil(min)
    local maxFloored = math.floor(max)
    return math.floor(math.random() * (maxFloored - minCeiled + 1) + minCeiled)
end}
____exports.default = MathUtils
return ____exports
 end,
["src.utils.array.utils"] = function(...) 
--[[ Generated with https://github.com/TypeScriptToLua/TypeScriptToLua ]]
local ____exports = {}
____exports.shuffleArray = function(____, array)
    do
        local i = #array - 1
        while i > 0 do
            local j = math.floor(math.random() * (i + 1))
            local ____temp_0 = {array[j + 1], array[i + 1]}
            array[i + 1] = ____temp_0[1]
            array[j + 1] = ____temp_0[2]
            i = i - 1
        end
    end
    return array
end
return ____exports
 end,
["src.models.entity-def.model"] = function(...) 
local ____lualib = require("lualib_bundle")
local __TS__Class = ____lualib.__TS__Class
local __TS__ArrayFind = ____lualib.__TS__ArrayFind
local __TS__ArrayForEach = ____lualib.__TS__ArrayForEach
local __TS__ArrayFilter = ____lualib.__TS__ArrayFilter
local ____exports = {}
local ____math_2Eutils = require("src.utils.math.utils")
local MathUtils = ____math_2Eutils.default
____exports.default = __TS__Class()
local EntityDefModel = ____exports.default
EntityDefModel.name = "EntityDefModel"
function EntityDefModel.prototype.____constructor(self)
    self.entity = {initial_properties = {
        hp_max = 1,
        visual = "mesh",
        visual_size = vector.new(0.45, 0.45, 0.45),
        collisionbox = {
            0,
            0,
            0,
            0,
            0,
            0
        },
        selectionbox = {
            0,
            0,
            0,
            0,
            0,
            0
        },
        textures = "",
        physical = false,
        makes_footstep_sound = false,
        automatic_rotate = math.pi * 3,
        static_save = true
    }}
    self.custom = {}
    self.name = "x_spawners_api:spawner_entity"
    self.entity.get_staticdata = function(____, ...)
        return self:getStaticData(____)
    end
    self.entity.on_activate = function(____, ...)
        self:onActivate(____, ...)
    end
end
function EntityDefModel.prototype.getStaticData(self, selfObj)
    local props = selfObj.object:get_properties()
    local obj = {node = {}, mob = {}, entity = {mesh = props and props.mesh, visualSize = props and props.visual_size, textures = props and props.textures}}
    return core.serialize(obj)
end
function EntityDefModel.prototype.onActivate(self, selfObj, staticdata, dtime_s)
    do
        local function ____catch(____error)
            print(
                "[onActivate] error",
                dump(____error)
            )
            selfObj.object:remove()
            return true
        end
        local ____try, ____hasReturned, ____returnValue = pcall(function()
            local data = core.deserialize(staticdata)
            selfObj.object:set_velocity(vector.zero())
            selfObj.object:set_acceleration(vector.zero())
            selfObj.object:set_armor_groups({immortal = 1})
            selfObj.object:set_rotation(vector.new(22.5 * math.pi / 180, 0, 0))
            local ____opt_6 = data and data.entity
            local ____temp_28 = ____opt_6 and ____opt_6.mesh
            local ____opt_20 = data and data.entity
            local ____opt_10 = ____opt_20 and ____opt_20.textures
            if ____opt_10 ~= nil then
                local ____MathUtils_17 = MathUtils
                local ____MathUtils_getRandomIntInclusive_18 = MathUtils.getRandomIntInclusive
                local ____opt_13 = data and data.entity
                local ____opt_11 = ____opt_13 and ____opt_13.textures
                ____opt_10 = ____opt_10[____MathUtils_getRandomIntInclusive_18(____MathUtils_17, 0, (____opt_11 and #____opt_11) - 1) + 1]
            end
            local ____temp_29 = {____opt_10}
            local ____opt_24 = data and data.entity
            local properties = {mesh = ____temp_28, textures = ____temp_29, visual_size = ____opt_24 and ____opt_24.visualSize}
            selfObj.object:set_properties(properties)
        end)
        if not ____try then
            ____hasReturned, ____returnValue = ____catch(____hasReturned)
        end
        if ____hasReturned then
            return ____returnValue
        end
    end
end
function EntityDefModel.prototype.add(self, pos, ____bindingPattern0)
    local offset
    offset = ____bindingPattern0.offset
    if offset == nil then
        offset = vector.zero()
    end
    local meta = core.get_meta(pos)
    local p = vector.new(pos.x, pos.y - 4 / 16, pos.z + 8 / 16 / 100 * 22.5)
    return core.add_entity(
        vector.offset(p, offset.x, offset.y, offset.z),
        self.name,
        meta:get_string("x_spawners")
    )
end
function EntityDefModel.prototype.exists(self, pos)
    return __TS__ArrayFind(
        core.get_objects_inside_radius(pos, 0.6),
        function(____, obj)
            if obj ~= nil and obj:is_valid() and obj:get_luaentity() and obj:get_luaentity().name == self.name then
                return true
            end
            return false
        end
    )
end
function EntityDefModel.prototype.remove(self, pos)
    __TS__ArrayForEach(
        core.get_objects_inside_radius(pos, 0.6),
        function(____, obj)
            if obj ~= nil and obj:is_valid() and obj:get_luaentity() and obj:get_luaentity().name == self.name then
                obj:remove()
            end
        end
    )
end
function EntityDefModel.prototype.getMobsInsideArea(self, pmin, pmax, mobName)
    return __TS__ArrayFilter(
        core.get_objects_in_area(pmin, pmax),
        function(____, obj) return obj ~= nil and obj:is_valid() and obj:get_luaentity() and obj:get_luaentity().name == (mobName or obj:get_luaentity().name) end
    )
end
return ____exports
 end,
["src.utils.constants"] = function(...) 
local ____lualib = require("lualib_bundle")
local Map = ____lualib.Map
local __TS__New = ____lualib.__TS__New
local ____exports = {}
____exports.SPAWNER_VARIANT_MAP = __TS__New(Map, {{"ACTIVE", "active"}, {"WAITING", "waiting"}, {"RUSTY", "rusty"}})
____exports.SPAWNER_VARIANT_MAP_ENV = __TS__New(Map, {{"ACTIVE", "active"}, {"WAITING", "waiting"}})
return ____exports
 end,
["src.models.node-def.model"] = function(...) 
local ____lualib = require("lualib_bundle")
local __TS__New = ____lualib.__TS__New
local __TS__Class = ____lualib.__TS__Class
local __TS__ArraySome = ____lualib.__TS__ArraySome
local __TS__StringSplit = ____lualib.__TS__StringSplit
local __TS__StringIncludes = ____lualib.__TS__StringIncludes
local __TS__ArrayFilter = ____lualib.__TS__ArrayFilter
local __TS__ArrayMap = ____lualib.__TS__ArrayMap
local __TS__ArrayIncludes = ____lualib.__TS__ArrayIncludes
local __TS__ArrayIsArray = ____lualib.__TS__ArrayIsArray
local __TS__ObjectAssign = ____lualib.__TS__ObjectAssign
local __TS__SparseArrayNew = ____lualib.__TS__SparseArrayNew
local __TS__SparseArrayPush = ____lualib.__TS__SparseArrayPush
local __TS__SparseArraySpread = ____lualib.__TS__SparseArraySpread
local __TS__ArrayForEach = ____lualib.__TS__ArrayForEach
local __TS__ArrayEvery = ____lualib.__TS__ArrayEvery
local __TS__SetDescriptor = ____lualib.__TS__SetDescriptor
local ____exports = {}
local ____sounds_2Ecomponent = require("src.components.sounds.component")
local Sounds = ____sounds_2Ecomponent.default
local ____particlespawner_2Emodel = require("src.models.particlespawner.model")
local ParticleSpawnerModel = ____particlespawner_2Emodel.default
local ____string_2Eutils = require("src.utils.string.utils")
local capitalizeFirstLetter = ____string_2Eutils.capitalizeFirstLetter
local ____math_2Eutils = require("src.utils.math.utils")
local MathUtils = ____math_2Eutils.default
local ____array_2Eutils = require("src.utils.array.utils")
local shuffleArray = ____array_2Eutils.shuffleArray
local sounds = __TS__New(Sounds)
____exports.default = __TS__Class()
local NodeDefModel = ____exports.default
NodeDefModel.name = "NodeDefModel"
function NodeDefModel.prototype.____constructor(self, ____bindingPattern0)
    local postfix
    local groups
    local variantsMap
    local drop
    local api
    local defs
    local entityModel
    local maxObjPerMapblock
    local tickShortMax
    local tickMax
    local variant
    variant = ____bindingPattern0.variant
    tickMax = ____bindingPattern0.tickMax
    tickShortMax = ____bindingPattern0.tickShortMax
    maxObjPerMapblock = ____bindingPattern0.maxObjPerMapblock
    entityModel = ____bindingPattern0.entityModel
    defs = ____bindingPattern0.defs
    api = ____bindingPattern0.api
    drop = ____bindingPattern0.drop
    variantsMap = ____bindingPattern0.variantsMap
    groups = ____bindingPattern0.groups
    postfix = ____bindingPattern0.postfix
    self.node = {}
    self.custom = {entityName = "", nameActive = "", nameWaiting = "", nameRusty = ""}
    self.variantsMap = variantsMap
    self._name = "x_spawners_api:spawner"
    self.postfix = postfix
    self._groups = groups
    self.name = self:getNameWithVariant(variant)
    self.defs = defs
    self.api = api
    self.variant = variant
    self.tickMax = tickMax
    self.tickShortMax = tickShortMax
    self.maxObjPerMapblock = maxObjPerMapblock
    self.entityModel = entityModel
    self.particleSpawnerModel = __TS__New(ParticleSpawnerModel)
    self.custom.entityName = self.name .. "_entity"
    self.custom.nameActive = self:getNameWithVariant(self.variantsMap:get("ACTIVE"))
    self.custom.nameWaiting = self:getNameWithVariant(self.variantsMap:get("WAITING"))
    if self.variantsMap:has("RUSTY") then
        self.custom.nameRusty = self:getNameWithVariant(self.variantsMap:get("RUSTY"))
    end
    self.node.description = capitalizeFirstLetter(nil, variant) .. " Spawner"
    self.node.short_description = capitalizeFirstLetter(nil, variant) .. " Spawner"
    self.node.paramtype = "light"
    self.node.paramtype2 = "none"
    self.node.drawtype = "mesh"
    self.node.mesh = "x_spawners_api_spawner.obj"
    self.node.use_texture_alpha = "clip"
    self.node.walkable = true
    self.node.sounds = sounds:getNodeSoundMetal()
    self.node.sunlight_propagates = true
    self.node.tiles = self.tiles
    self.node.is_ground_content = false
    self.node.groups = self.groups
    self.node.stack_max = 1
    self.node.light_source = self.light_source
    self.node.drop = drop or self.custom.nameActive
    self.node.on_rightclick = function(...)
        return self:onRightClick(...)
    end
    self.node.on_blast = function(pos, intensity)
    end
    if variant == self.variantsMap:get("ACTIVE") then
        self.node.after_place_node = function(...)
            self:afterPlaceNode(...)
        end
        self.node.on_destruct = function(...)
            self:onDestruct(...)
        end
        self.node.on_timer = function(...)
            self:onTimer(...)
        end
    elseif variant == self.variantsMap:get("WAITING") then
        self.node.on_timer = function(...)
            self:onTimer(...)
        end
    end
end
function NodeDefModel.prototype.getNameWithVariant(self, variant)
    local n = self._name
    if variant ~= self.variantsMap:get("ACTIVE") then
        n = (n .. "_") .. variant
    end
    return n .. self.postfix
end
function NodeDefModel.prototype.nodeTick(self, pos)
    local meta = core.get_meta(pos)
    local tickCounter = meta:get_int("tick")
    local owner = meta:get_string("owner")
    local privs = core.get_player_privs(owner)
    if not privs.privs and self.variantsMap:has("RUSTY") then
        tickCounter = tickCounter + 1
        meta:set_int("tick", tickCounter)
    end
    if self.variantsMap:has("RUSTY") and tickCounter >= self.tickMax then
        self:setStatus(
            pos,
            self.variantsMap:get("RUSTY")
        )
        return
    end
    core.get_node_timer(pos):start(MathUtils:getRandomIntInclusive(10, 40))
end
function NodeDefModel.prototype.nodeTickShort(self, pos)
    local meta = core.get_meta(pos)
    local tickShortCounter = meta:get_int("tick_short")
    if tickShortCounter >= self.tickShortMax then
        self:nodeTick(pos)
        return
    elseif self.variantsMap:has("RUSTY") then
        tickShortCounter = tickShortCounter + 1
        meta:set_int("tick_short", tickShortCounter)
    end
    core.get_node_timer(pos):start(MathUtils:getRandomIntInclusive(5, 10))
end
function NodeDefModel.prototype.setStatus(self, pos, variant, ____bindingPattern0)
    if ____bindingPattern0 == nil then
        ____bindingPattern0 = {}
    end
    local offset
    local swapEntity
    swapEntity = ____bindingPattern0.swapEntity
    offset = ____bindingPattern0.offset
    if offset == nil then
        offset = vector.zero()
    end
    local meta = core.get_meta(pos)
    local owner = meta:get_string("owner")
    local metaStatus = meta:get_string("variant")
    local idFlame = meta:get_int("id_flame")
    local idSmoke = meta:get_int("id_smoke")
    if variant == self.variantsMap:get("ACTIVE") then
        if idFlame ~= -1 and idSmoke ~= -1 then
            self.particleSpawnerModel:delete({idFlame, idSmoke})
            meta:set_int("id_flame", -1)
            meta:set_int("id_smoke", -1)
        end
        local isInWater = self:isInWater(pos)
        local ____temp_0 = self.particleSpawnerModel:add({"flame", "smoke"}, pos, isInWater)
        local flame = ____temp_0.flame
        local smoke = ____temp_0.smoke
        meta:set_int("id_flame", flame)
        meta:set_int("id_smoke", smoke)
        if swapEntity then
            self.entityModel:remove(pos)
            self.entityModel:add(pos, {offset = offset})
        end
        if metaStatus ~= variant then
            if not self.entityModel:exists(pos) then
                self.entityModel:add(pos, {offset = offset})
            end
            meta:set_string(
                "variant",
                self.variantsMap:get("ACTIVE")
            )
            core.swap_node(pos, {name = self.custom.nameActive})
        end
    elseif variant == self.variantsMap:get("WAITING") and metaStatus ~= variant then
        if idFlame ~= -1 and idSmoke ~= -1 then
            self.particleSpawnerModel:delete({idFlame, idSmoke})
            meta:set_int("id_flame", -1)
            meta:set_int("id_smoke", -1)
        end
        self.entityModel:remove(pos)
        meta:set_string(
            "variant",
            self.variantsMap:get("WAITING")
        )
        core.swap_node(pos, {name = self.custom.nameWaiting})
    elseif variant == self.variantsMap:get("RUSTY") and metaStatus ~= variant then
        if idFlame ~= -1 and idSmoke ~= -1 then
            self.particleSpawnerModel:delete({idFlame, idSmoke})
            meta:set_int("id_flame", -1)
            meta:set_int("id_smoke", -1)
        end
        self.entityModel:remove(pos)
        meta:set_string(
            "variant",
            self.variantsMap:get("RUSTY")
        )
        core.swap_node(pos, {name = self.custom.nameRusty})
        meta:set_string("infotext", ("Owner: " .. owner) .. "\nSpawner was searching for too long and got rusted! Dig up the spawner and place it again.")
        return
    end
end
function NodeDefModel.prototype.afterPlaceNode(self, pos, placer, itemstack, pointed_thing)
    local meta = core.get_meta(pos)
    local pname = placer and placer:get_player_name() or ""
    meta:set_string("owner", pname)
    meta:set_string("infotext", "Spawner\nOwner: " .. pname)
end
function NodeDefModel.prototype.onRightClick(self, pos, node, clicker, itemstack, pointed_thing)
    local stackName = itemstack:get_name()
    local stackDef = core.registered_items[stackName]
    if not stackDef then
        return itemstack
    end
    local def = self.api.defs[stackName]
    if def and def.getDefFromStack and type(def and def.getDefFromStack) == "function" then
        def = def:getDefFromStack(itemstack, self.api.mobKeyDefs)
    end
    if not def then
        return itemstack
    end
    local ____core_registered_entities_9 = core.registered_entities
    local ____opt_7 = def.mob
    local entityDef = ____core_registered_entities_9[____opt_7 and ____opt_7.name or ""]
    def.mob.mobHeight = self:getMobHeight(entityDef.collisionbox)
    local meta = core.get_meta(pos)
    meta:set_int("tick", 0)
    meta:set_int("tick_short", 0)
    meta:set_string(
        "x_spawners",
        core.serialize(def)
    )
    local ____self_setStatus_14 = self.setStatus
    local ____pos_12 = pos
    local ____temp_13 = self.variantsMap:get("ACTIVE")
    local ____opt_10 = def.entity
    ____self_setStatus_14(self, ____pos_12, ____temp_13, {swapEntity = true, offset = ____opt_10 and ____opt_10.offset})
    self:nodeTickShort(pos)
    if not core.is_creative_enabled(clicker:get_player_name()) then
        itemstack:take_item()
    end
    return itemstack
end
function NodeDefModel.prototype.onDestruct(self, pos)
    local meta = core.get_meta(pos)
    local idFlame = meta:get_int("id_flame")
    local idSmoke = meta:get_int("id_smoke")
    core.get_node_timer(pos):stop()
    self.particleSpawnerModel:delete({idFlame, idSmoke})
    self.entityModel:remove(pos)
    meta:set_int("id_flame", -1)
    meta:set_int("id_smoke", -1)
end
function NodeDefModel.prototype.onTimer(self, pos, elapsed)
    do
        local function ____catch(____error)
            print(
                "[onTimer] error",
                dump(____error)
            )
            return true
        end
        local ____try, ____hasReturned, ____returnValue = pcall(function()
            local meta = core.get_meta(pos)
            local metaStatus = meta:get_string("variant")
            local owner = meta:get_string("owner")
            local entityProps = core.deserialize(meta:get_string("x_spawners"))
            if not self.entityModel:exists(pos) and metaStatus == self.variantsMap:get("ACTIVE") then
                local ____self_18 = self.entityModel
                local ____self_18_add_19 = ____self_18.add
                local ____pos_17 = pos
                local ____opt_15 = entityProps.entity
                ____self_18_add_19(____self_18, ____pos_17, {offset = ____opt_15 and ____opt_15.offset})
            end
            local timeOfDay = core.get_timeofday()
            local dayMin = 1 / 24 * 6
            local dayMax = 1 / 24 * 18
            local isDay = timeOfDay >= dayMin and timeOfDay <= dayMax
            local isNight = not isDay
            local ____opt_20 = entityProps.node
            local ____temp_22 = ____opt_20 and ____opt_20.nightOnly
            if ____temp_22 == nil then
                ____temp_22 = false
            end
            local isNightOnly = ____temp_22
            local ____opt_23 = entityProps.node
            local ____temp_25 = ____opt_23 and ____opt_23.dayOnly
            if ____temp_25 == nil then
                ____temp_25 = false
            end
            local isDayOnly = ____temp_25
            if isDay and isNightOnly then
                self:setStatus(
                    pos,
                    self.variantsMap:get("WAITING")
                )
                local ____meta_set_string_28 = meta.set_string
                local ____opt_26 = entityProps.mob
                ____meta_set_string_28(
                    meta,
                    "infotext",
                    ((tostring(____opt_26 and ____opt_26.name) .. " Spawner\nOwner: ") .. owner) .. "\nOnly active at night."
                )
                self:nodeTickShort(pos)
                return true
            end
            if isNight and isDayOnly then
                self:setStatus(
                    pos,
                    self.variantsMap:get("WAITING")
                )
                local ____meta_set_string_31 = meta.set_string
                local ____opt_29 = entityProps.mob
                ____meta_set_string_31(
                    meta,
                    "infotext",
                    ((tostring(____opt_29 and ____opt_29.name) .. " Spawner\nOwner: ") .. owner) .. "\nOnly active at day."
                )
                self:nodeTickShort(pos)
                return true
            end
            local nodeAbove = core.get_node(vector.new(pos.x, pos.y + 1, pos.z))
            if core.get_item_group(nodeAbove.name, "torch") ~= 0 then
                self:setStatus(
                    pos,
                    self.variantsMap:get("WAITING")
                )
                local ____meta_set_string_34 = meta.set_string
                local ____opt_32 = entityProps.mob
                ____meta_set_string_34(
                    meta,
                    "infotext",
                    ((tostring(____opt_32 and ____opt_32.name) .. " Spawner\nOwner: ") .. owner) .. "\nBlocked by Torch."
                )
                self:nodeTickShort(pos)
                return true
            end
            local playerNear = __TS__ArraySome(
                core.get_objects_inside_radius(pos, 16),
                function(____, obj) return obj ~= nil and obj:is_valid() and obj:is_player() end
            )
            if not playerNear then
                self:setStatus(
                    pos,
                    self.variantsMap:get("WAITING")
                )
                self:nodeTickShort(pos)
                return true
            end
            local isBlockedByNode = self:isBlockedByNode(pos)
            if isBlockedByNode then
                self:setStatus(
                    pos,
                    self.variantsMap:get("WAITING")
                )
                local ____meta_set_string_37 = meta.set_string
                local ____opt_35 = entityProps.mob
                ____meta_set_string_37(
                    meta,
                    "infotext",
                    ((tostring(____opt_35 and ____opt_35.name) .. " Spawner\nOwner: ") .. owner) .. "\nIs blocked by another node."
                )
                self:nodeTickShort(pos)
                return true
            end
            local ____self_42 = self.entityModel
            local ____self_42_getMobsInsideArea_43 = ____self_42.getMobsInsideArea
            local ____vector_subtract_result_40 = vector.subtract(pos, 4)
            local ____vector_add_result_41 = vector.add(pos, 5)
            local ____opt_38 = entityProps.mob
            local mobsInCapArea = ____self_42_getMobsInsideArea_43(____self_42, ____vector_subtract_result_40, ____vector_add_result_41, ____opt_38 and ____opt_38.name)
            if #mobsInCapArea > 5 then
                self:setStatus(
                    pos,
                    self.variantsMap:get("WAITING")
                )
                local ____meta_set_string_49 = meta.set_string
                local ____opt_44 = entityProps.mob
                local ____temp_48 = ____opt_44 and ____opt_44.name
                local ____opt_46 = entityProps.mob
                ____meta_set_string_49(
                    meta,
                    "infotext",
                    ((((tostring(____temp_48) .. " Spawner\nOwner: ") .. owner) .. "\nToo many ") .. tostring(____opt_46 and ____opt_46.name)) .. " around spawner."
                )
                self:nodeTickShort(pos)
                return true
            end
            local mobsInMapBlock = self.entityModel:getMobsInsideArea(
                vector.subtract(pos, 8),
                vector.add(pos, 8)
            )
            if #mobsInMapBlock > self.maxObjPerMapblock then
                self:setStatus(
                    pos,
                    self.variantsMap:get("WAITING")
                )
                local ____meta_set_string_55 = meta.set_string
                local ____opt_50 = entityProps.mob
                local ____temp_54 = ____opt_50 and ____opt_50.name
                local ____opt_52 = entityProps.mob
                ____meta_set_string_55(
                    meta,
                    "infotext",
                    ((((tostring(____temp_54) .. " Spawner\nOwner: ") .. owner) .. "\nToo many ") .. tostring(____opt_52 and ____opt_52.name)) .. " in the map block. Clean-up dropped objects or mobs."
                )
                self:nodeTickShort(pos)
                return true
            end
            local nodesToSearch = entityProps.node.nodes or ({"air"})
            if type(nodesToSearch) == "string" then
                nodesToSearch = {nodesToSearch}
            end
            local groupsToSearch = {}
            if #nodesToSearch > 0 then
                groupsToSearch = __TS__ArrayMap(
                    __TS__ArrayFilter(
                        nodesToSearch,
                        function(____, str) return __TS__StringIncludes(str, "group:") end
                    ),
                    function(____, str) return __TS__StringSplit(str, ":")[2] end
                )
            end
            local mobsSpawnPositions = core.find_nodes_in_area(
                vector.new(pos.x - 3, pos.y - 1, pos.z - 3),
                vector.new(pos.x + 4, pos.y + 1, pos.z + 4),
                nodesToSearch
            )
            mobsSpawnPositions = shuffleArray(nil, mobsSpawnPositions)
            local mobCount = MathUtils:getRandomIntInclusive(1, 4)
            local mobSpawnPositionsValid = {}
            local spawningInWater = __TS__ArrayIncludes(groupsToSearch, "water") or __TS__ArraySome(
                nodesToSearch,
                function(____, name) return core.get_item_group(name, "water") > 0 end
            )
            do
                local i = 0
                while i < #mobsSpawnPositions do
                    local p = mobsSpawnPositions[i + 1]
                    local ____core_get_node_61 = core.get_node
                    local ____vector_new_60 = vector.new
                    local ____p_x_59 = p.x
                    local ____p_y_58 = p.y
                    local ____opt_56 = entityProps.mob
                    local posAbove = ____core_get_node_61(____vector_new_60(____p_x_59, ____p_y_58 + (____opt_56 and ____opt_56.mobHeight or 0), p.z))
                    if posAbove ~= nil and (__TS__ArrayIncludes(nodesToSearch, posAbove.name) or __TS__ArraySome(
                        groupsToSearch,
                        function(____, group) return core.get_item_group(posAbove.name, group) > 0 end
                    )) and not core.is_protected(p, owner) then
                        mobSpawnPositionsValid[#mobSpawnPositionsValid + 1] = p
                    end
                    if #mobSpawnPositionsValid >= mobCount then
                        break
                    end
                    i = i + 1
                end
            end
            if #mobSpawnPositionsValid == 0 then
                self:setStatus(
                    pos,
                    self.variantsMap:get("WAITING")
                )
                local ____meta_set_string_64 = meta.set_string
                local ____opt_62 = entityProps.mob
                ____meta_set_string_64(
                    meta,
                    "infotext",
                    ((tostring(____opt_62 and ____opt_62.name) .. " Spawner\nOwner: ") .. owner) .. "\nNot enough place to spawn mob. Find more space!"
                )
                self:nodeTick(pos)
                return true
            end
            meta:set_string(
                "x_spawners",
                core.serialize(entityProps)
            )
            local isInWater = self:isInWater(pos)
            local ____self_setStatus_69 = self.setStatus
            local ____pos_67 = pos
            local ____temp_68 = self.variantsMap:get("ACTIVE")
            local ____opt_65 = entityProps.entity
            ____self_setStatus_69(self, ____pos_67, ____temp_68, {offset = ____opt_65 and ____opt_65.offset})
            self.particleSpawnerModel:add("flamePuff", pos, isInWater)
            local ____self_72 = self.api
            local ____self_72_getDefByMobName_73 = ____self_72.getDefByMobName
            local ____opt_70 = entityProps.mob
            local def = ____self_72_getDefByMobName_73(____self_72, ____opt_70 and ____opt_70.name or "")
            __TS__ArrayForEach(
                mobSpawnPositionsValid,
                function(____, p, i)
                    core.after(
                        i,
                        function(_p, _particleSpawnerModel, _spawningInWater)
                            local ____particleSpawnerModel_78 = _particleSpawnerModel
                            local ____particleSpawnerModel_add_79 = _particleSpawnerModel.add
                            local ____vector_offset_77 = vector.offset
                            local ____p_76 = _p
                            local ____opt_74 = entityProps.mob
                            ____particleSpawnerModel_add_79(
                                ____particleSpawnerModel_78,
                                "smokePuff",
                                ____vector_offset_77(____p_76, 0, ____opt_74 and ____opt_74.mobHeight or 0, 0),
                                _spawningInWater
                            )
                        end,
                        p,
                        self.particleSpawnerModel,
                        spawningInWater
                    )
                    local ____core_after_104 = core.after
                    local ____array_103 = __TS__SparseArrayNew(
                        i + 1,
                        function(_p, _getStaticdata, _entityProps, _getRandomIntInclusive)
                            local staticdata = nil
                            if _getStaticdata then
                                staticdata = core.serialize(_getStaticdata(nil))
                            end
                            local ____core_add_entity_87 = core.add_entity
                            local ____vector_offset_83 = vector.offset
                            local ____p_82 = _p
                            local ____opt_80 = _entityProps.mob
                            local ____vector_offset_83_result_86 = ____vector_offset_83(____p_82, 0, ____opt_80 and ____opt_80.mobHeight or 0, 0)
                            local ____opt_84 = _entityProps.mob
                            local obj = ____core_add_entity_87(____vector_offset_83_result_86, ____opt_84 and ____opt_84.name, staticdata)
                            if obj ~= nil and _entityProps.entity.sounds ~= nil then
                                if __TS__ArrayIsArray(_entityProps.entity.sounds) then
                                    _entityProps.entity.sounds = _entityProps.entity.sounds[_getRandomIntInclusive(nil, 0, #_entityProps.entity.sounds - 1) + 1]
                                end
                                local ____entityProps_entity_92 = _entityProps.entity
                                local ____entityProps_entity_sounds_91 = _entityProps.entity.sounds
                                local ____opt_88 = _entityProps.entity.sounds
                                local ____temp_90 = ____opt_88 and ____opt_88.params
                                if ____temp_90 == nil then
                                    ____temp_90 = {}
                                end
                                ____entityProps_entity_92.sounds = __TS__ObjectAssign(
                                    {},
                                    ____entityProps_entity_sounds_91,
                                    {params = __TS__ObjectAssign({}, ____temp_90, {object = obj})}
                                )
                                local ____core_sound_play_98 = core.sound_play
                                local ____opt_93 = _entityProps.entity.sounds
                                local ____temp_97 = ____opt_93 and ____opt_93.simple
                                local ____opt_95 = _entityProps.entity.sounds
                                ____core_sound_play_98(____temp_97, ____opt_95 and ____opt_95.params)
                            end
                        end,
                        p
                    )
                    local ____opt_99 = def and def.mob
                    __TS__SparseArrayPush(____array_103, ____opt_99 and ____opt_99.getStaticdata, entityProps, MathUtils.getRandomIntInclusive)
                    ____core_after_104(__TS__SparseArraySpread(____array_103))
                end
            )
            local ____meta_set_string_107 = meta.set_string
            local ____opt_105 = entityProps.mob
            ____meta_set_string_107(
                meta,
                "infotext",
                ((tostring(____opt_105 and ____opt_105.name) .. " Spawner\nOwner: ") .. owner) .. "\nSpawner is Active."
            )
            meta:set_int("tick", 0)
            meta:set_int("tick_short", 0)
            self:nodeTick(pos)
        end)
        if not ____try then
            ____hasReturned, ____returnValue = ____catch(____hasReturned)
        end
        if ____hasReturned then
            return ____returnValue
        end
    end
end
function NodeDefModel.prototype.getMobHeight(self, collisionbox)
    if not collisionbox then
        return 1
    end
    local yMin = collisionbox[2]
    local yMax = collisionbox[5]
    if yMin < 0 then
        yMin = yMin * -1
    end
    return yMin + yMax
end
function NodeDefModel.prototype.isInWater(self, pos)
    return __TS__ArrayEvery(
        {
            vector.offset(pos, 1, 0, 0),
            vector.offset(pos, 0, 0, 1),
            vector.offset(pos, -1, 0, 0),
            vector.offset(pos, 0, 0, -1)
        },
        function(____, p)
            local ____core_get_item_group_110 = core.get_item_group
            local ____opt_108 = core.get_node(p)
            return ____core_get_item_group_110(____opt_108 and ____opt_108.name, "water") > 0
        end
    )
end
function NodeDefModel.prototype.isBlockedByNode(self, pos)
    return __TS__ArrayEvery(
        {
            vector.offset(pos, 1, 0, 0),
            vector.offset(pos, 0, 1, 0),
            vector.offset(pos, 0, 0, 1),
            vector.offset(pos, -1, 0, 0),
            vector.offset(pos, 0, -1, 0),
            vector.offset(pos, 0, 0, -1)
        },
        function(____, p)
            local ____core_registered_nodes_115 = core.registered_nodes
            local ____opt_113 = core.get_node(p)
            local ____opt_111 = ____core_registered_nodes_115[____opt_113 and ____opt_113.name]
            return ____opt_111 and ____opt_111.walkable
        end
    )
end
__TS__SetDescriptor(
    NodeDefModel.prototype,
    "tiles",
    {get = function(self)
        repeat
            local ____switch73 = self.variant
            local ____cond73 = ____switch73 == self.variantsMap:get("WAITING")
            if ____cond73 then
                return {{name = "x_spawners_api_spawner_mesh_waiting_animated.png", animation = {type = "vertical_frames", aspect_w = 48, aspect_h = 64, length = 2}}}
            end
            ____cond73 = ____cond73 or ____switch73 == self.variantsMap:get("RUSTY")
            if ____cond73 then
                return {"x_spawners_api_spawner_mesh_rusted.png"}
            end
            do
                return {"x_spawners_api_spawner_mesh.png"}
            end
        until true
    end},
    true
)
__TS__SetDescriptor(
    NodeDefModel.prototype,
    "groups",
    {get = function(self)
        local groups = __TS__ObjectAssign({cracky = 1, level = 2, x_spawner = 1}, self._groups)
        repeat
            local ____switch75 = self.variant
            local ____cond75 = ____switch75 == self.variantsMap:get("WAITING") or ____switch75 == self.variantsMap:get("RUSTY")
            if ____cond75 then
                groups = __TS__ObjectAssign({}, groups, {not_in_creative_inventory = 1, no_silktouch = 1})
                return groups
            end
            do
                return groups
            end
        until true
    end},
    true
)
__TS__SetDescriptor(
    NodeDefModel.prototype,
    "light_source",
    {get = function(self)
        repeat
            local ____switch77 = self.variant
            local ____cond77 = ____switch77 == self.variantsMap:get("ACTIVE")
            if ____cond77 then
                return 6
            end
            ____cond77 = ____cond77 or ____switch77 == self.variantsMap:get("WAITING")
            if ____cond77 then
                return 4
            end
            do
                return 0
            end
        until true
    end},
    true
)
return ____exports
 end,
["src.components.storage.component"] = function(...) 
local ____lualib = require("lualib_bundle")
local __TS__Class = ____lualib.__TS__Class
local __TS__ObjectAssign = ____lualib.__TS__ObjectAssign
local __TS__New = ____lualib.__TS__New
local ____exports = {}
local StorageComponent = __TS__Class()
StorageComponent.name = "StorageComponent"
function StorageComponent.prototype.____constructor(self)
    self.store = {registeredSpawners = {}, registeredEntities = {}}
    if self._instance then
        return self._instance
    end
    self._instance = self
end
function StorageComponent.prototype.get(self, key)
    return self.store[key]
end
function StorageComponent.prototype.set(self, key, value)
    self.store = __TS__ObjectAssign({}, self.store, {[key] = value})
end
local storageComponent = __TS__New(StorageComponent)
____exports.default = storageComponent
return ____exports
 end,
["src.components.spawner.component"] = function(...) 
local ____lualib = require("lualib_bundle")
local Map = ____lualib.Map
local __TS__Class = ____lualib.__TS__Class
local __TS__Number = ____lualib.__TS__Number
local __TS__New = ____lualib.__TS__New
local __TS__ObjectAssign = ____lualib.__TS__ObjectAssign
local ____exports = {}
local ____storage_2Ecomponent = require("src.components.storage.component")
local storageComponent = ____storage_2Ecomponent.default
local ____node_2Ddef_2Emodel = require("src.models.node-def.model")
local NodeDefModel = ____node_2Ddef_2Emodel.default
local ____entity_2Ddef_2Emodel = require("src.models.entity-def.model")
local EntityDefModel = ____entity_2Ddef_2Emodel.default
local ____constants = require("src.utils.constants")
local SPAWNER_VARIANT_MAP = ____constants.SPAWNER_VARIANT_MAP
____exports.default = __TS__Class()
local SpawnerComponent = ____exports.default
SpawnerComponent.name = "SpawnerComponent"
function SpawnerComponent.prototype.____constructor(self, ____bindingPattern0)
    local drop
    local postfix
    local groups
    local variantsMap
    local api
    local defs
    local maxObjPerMapblock
    local tickShortMax
    local tickMax
    tickMax = ____bindingPattern0.tickMax
    tickShortMax = ____bindingPattern0.tickShortMax
    maxObjPerMapblock = ____bindingPattern0.maxObjPerMapblock
    defs = ____bindingPattern0.defs
    api = ____bindingPattern0.api
    variantsMap = ____bindingPattern0.variantsMap
    groups = ____bindingPattern0.groups
    postfix = ____bindingPattern0.postfix
    drop = ____bindingPattern0.drop
    self.tickMax = tickMax or 160
    self.tickShortMax = tickShortMax or 80
    self.maxObjPerMapblock = maxObjPerMapblock or __TS__Number(core.settings:get("max_objects_per_block"))
    self.storage = storageComponent
    self.defs = defs
    self.api = api
    self.variantsMap = variantsMap or SPAWNER_VARIANT_MAP
    self.groups = groups or ({})
    self.postfix = postfix or ""
    self.drop = drop
    self:registerSpawner()
end
function SpawnerComponent.prototype.registerSpawner(self)
    local entityModel = self:registerEntity()
    local nodeDefModels = {}
    self.variantsMap:forEach(function(____, variant)
        local nodeDefModel = __TS__New(NodeDefModel, {
            variant = variant,
            tickMax = self.tickMax,
            tickShortMax = self.tickShortMax,
            maxObjPerMapblock = self.maxObjPerMapblock,
            entityModel = entityModel,
            defs = self.defs,
            api = self.api,
            variantsMap = self.variantsMap,
            groups = self.groups,
            postfix = self.postfix,
            drop = self.drop
        })
        nodeDefModels[variant] = nodeDefModel
        core.register_node(nodeDefModel.name, nodeDefModel.node)
        local registeredSpawners = self.storage:get("registeredSpawners")
        registeredSpawners = __TS__ObjectAssign({}, registeredSpawners, {[nodeDefModel.name] = nodeDefModel})
        self.storage:set("registeredSpawners", registeredSpawners)
    end)
end
function SpawnerComponent.prototype.registerEntity(self)
    local registeredEntities = self.storage:get("registeredEntities")
    local entityDefModel = __TS__New(EntityDefModel)
    if registeredEntities[entityDefModel.name] then
        return registeredEntities[entityDefModel.name]
    end
    core.register_entity(entityDefModel.name, entityDefModel.entity)
    registeredEntities = __TS__ObjectAssign({}, registeredEntities, {[entityDefModel.name] = entityDefModel})
    self.storage:set("registeredEntities", registeredEntities)
    return entityDefModel
end
return ____exports
 end,
["src.utils.object.utils"] = function(...) 
local ____lualib = require("lualib_bundle")
local __TS__ArrayIsArray = ____lualib.__TS__ArrayIsArray
local __TS__SparseArrayNew = ____lualib.__TS__SparseArrayNew
local __TS__SparseArrayPush = ____lualib.__TS__SparseArrayPush
local __TS__SparseArraySpread = ____lualib.__TS__SparseArraySpread
local Set = ____lualib.Set
local __TS__New = ____lualib.__TS__New
local __TS__Spread = ____lualib.__TS__Spread
local __TS__ObjectKeys = ____lualib.__TS__ObjectKeys
local __TS__ArrayForEach = ____lualib.__TS__ArrayForEach
local __TS__ArrayReduce = ____lualib.__TS__ArrayReduce
local ____exports = {}
____exports.mergeDeep = function(____, ...)
    local objects = {...}
    local function isObject(____, obj)
        return obj and type(obj) == "table"
    end
    return __TS__ArrayReduce(
        objects,
        function(____, prev, obj)
            __TS__ArrayForEach(
                __TS__ObjectKeys(obj),
                function(____, key)
                    local pVal = prev[key]
                    local oVal = obj[key]
                    if __TS__ArrayIsArray(pVal) and __TS__ArrayIsArray(oVal) then
                        local ____prev_2 = prev
                        local ____key_3 = key
                        local ____Set_1 = Set
                        local ____array_0 = __TS__SparseArrayNew(unpack(oVal))
                        __TS__SparseArrayPush(
                            ____array_0,
                            unpack(pVal)
                        )
                        ____prev_2[____key_3] = {__TS__Spread(__TS__New(
                            ____Set_1,
                            {__TS__SparseArraySpread(____array_0)}
                        ))}
                    elseif isObject(nil, pVal) and isObject(nil, oVal) then
                        prev[key] = ____exports.mergeDeep(nil, pVal, oVal)
                    else
                        prev[key] = oVal
                    end
                end
            )
            return prev
        end,
        {}
    )
end
return ____exports
 end,
["src.components.api.component"] = function(...) 
local ____lualib = require("lualib_bundle")
local __TS__Class = ____lualib.__TS__Class
local __TS__New = ____lualib.__TS__New
local Map = ____lualib.Map
local __TS__ObjectValues = ____lualib.__TS__ObjectValues
local __TS__ArrayFind = ____lualib.__TS__ArrayFind
local __TS__ObjectAssign = ____lualib.__TS__ObjectAssign
local __TS__ArrayFilter = ____lualib.__TS__ArrayFilter
local __TS__ArrayMap = ____lualib.__TS__ArrayMap
local ____exports = {}
local ____spawner_2Ecomponent = require("src.components.spawner.component")
local SpawnerComponent = ____spawner_2Ecomponent.default
local ____object_2Eutils = require("src.utils.object.utils")
local mergeDeep = ____object_2Eutils.mergeDeep
____exports.default = __TS__Class()
local ApiComponent = ____exports.default
ApiComponent.name = "ApiComponent"
function ApiComponent.prototype.____constructor(self)
    self.defs = {}
    self.defsEnv = {}
    self.mobKeyDefs = {}
    if self._instance then
        return self._instance
    end
    self._instance = self
end
function ApiComponent.prototype.initSpawner(self, defs)
    local spawnerComponent = __TS__New(SpawnerComponent, {defs = defs or self.defs, api = self._instance})
    return spawnerComponent
end
function ApiComponent.prototype.initSpawnerEnv(self, defs)
    local spawnerComponentEnv = __TS__New(
        SpawnerComponent,
        {
            defs = defs or self.defs,
            api = self._instance,
            variantsMap = __TS__New(Map, {{"ACTIVE", "active"}, {"WAITING", "waiting"}}),
            groups = {x_spawner_env = 1, not_in_creative_inventory = 1},
            postfix = "_env",
            drop = ""
        }
    )
    return spawnerComponentEnv
end
function ApiComponent.prototype.registerCraft(self, recipe)
    core.register_craft({output = "x_spawners_api:spawner", recipe = recipe})
end
function ApiComponent.prototype.addDefs(self, defs)
    self.defs = mergeDeep(nil, self.defs, defs)
    for key in pairs(self.defs) do
        local def = self.defs[key]
        if not def.node then
            self.defs[key].node = {}
        end
        if not def.entity then
            self.defs[key].entity = {}
        end
        if not def.mob then
            self.defs[key].mob = {}
        end
    end
    self.mobKeyDefs = {}
    for key in pairs(self.defs) do
        local def = self.defs[key]
        local ____opt_0 = def.mob
        local ____temp_5 = ____opt_0 and ____opt_0.name
        if ____temp_5 then
            local ____self_mobKeyDefs_4 = self.mobKeyDefs
            local ____opt_2 = def.mob
            ____temp_5 = not ____self_mobKeyDefs_4[____opt_2 and ____opt_2.name]
        end
        if ____temp_5 then
            local ____self_mobKeyDefs_8 = self.mobKeyDefs
            local ____opt_6 = def.mob
            ____self_mobKeyDefs_8[____opt_6 and ____opt_6.name] = def
        end
    end
    self:setEnvDefsData()
end
function ApiComponent.prototype.getDefByMobName(self, mobName)
    if not mobName or mobName == "" then
        return nil
    end
    return __TS__ArrayFind(
        __TS__ObjectValues(self.defs),
        function(____, v)
            local ____opt_9 = v.mob
            return (____opt_9 and ____opt_9.name) == mobName
        end
    )
end
function ApiComponent.prototype.setEnvDefsData(self)
    self.defsEnv = __TS__ArrayMap(
        __TS__ArrayFilter(
            __TS__ObjectValues(self.defs),
            function(____, v) return v.nodeEnv ~= nil end
        ),
        function(____, v) return __TS__ObjectAssign(
            {},
            v,
            {node = __TS__ObjectAssign({}, v.node, v.nodeEnv or ({}))}
        ) end
    )
end
return ____exports
 end,
["src.components.mapgen.component"] = function(...) 
local ____lualib = require("lualib_bundle")
local __TS__Class = ____lualib.__TS__Class
local __TS__SparseArrayNew = ____lualib.__TS__SparseArrayNew
local __TS__SparseArrayPush = ____lualib.__TS__SparseArrayPush
local __TS__SparseArraySpread = ____lualib.__TS__SparseArraySpread
local ____exports = {}
local ____array_2Eutils = require("src.utils.array.utils")
local shuffleArray = ____array_2Eutils.shuffleArray
____exports.default = __TS__Class()
local MapgenComponent = ____exports.default
MapgenComponent.name = "MapgenComponent"
function MapgenComponent.prototype.____constructor(self)
end
function MapgenComponent.prototype.registerOnGenerated(minp, maxp, blockseed, api)
    local ____temp_2 = not api.defsEnv
    if not ____temp_2 then
        local ____opt_0 = api.defsEnv
        ____temp_2 = (____opt_0 and #____opt_0) == 0
    end
    if ____temp_2 then
        return
    end
    local gennotify = core.get_mapgen_object("gennotify")
    if gennotify.dungeon and #gennotify.dungeon > 0 or gennotify.large_cave_end and #gennotify.large_cave_end > 0 then
        local ____shuffleArray_4 = shuffleArray
        local ____array_3 = __TS__SparseArrayNew(unpack(gennotify.dungeon or ({})))
        __TS__SparseArrayPush(
            ____array_3,
            unpack(gennotify.large_cave_end or ({}))
        )
        local positions = ____shuffleArray_4(
            nil,
            {__TS__SparseArraySpread(____array_3)}
        )
        local noise = core.get_perlin(10115, 4, 0.5, 1)
        local rand = PcgRandom(____exports.default:noise3dInteger(noise, positions[1]))
        local candidates = {}
        local numProcess = math.min(#positions, 8)
        do
            local i = 0
            while i < numProcess do
                local room = ____exports.default:findWalls(positions[i + 1])
                if room.isCave then
                    candidates[#candidates + 1] = room
                elseif math.min(room.size.x, room.size.z) >= 4 and #room.walls >= 3 then
                    candidates[#candidates + 1] = room
                end
                i = i + 1
            end
        end
        local numSpawners = math.min(#candidates, 2)
        local rooms = ____exports.default:randomSample(candidates, numSpawners)
        for ____, room in ipairs(rooms) do
            local spawnerPos = room.cpos
            if core.get_node(spawnerPos).name == "air" then
                local def = api.defsEnv[rand:next(0, #api.defsEnv - 1)]
                if not def then
                    core.log("warning", "[x_spawners_api] No spawner defintion found")
                    return
                end
                core.add_node(spawnerPos, {name = "x_spawners_api:spawner_env"})
                core.log(
                    "action",
                    (("[x_spawners_api] Spawner placed in " .. (room.isCave and "cave" or "dungeon")) .. " at ") .. tostring(spawnerPos:to_string())
                )
                local meta = core.get_meta(spawnerPos)
                meta:set_string(
                    "x_spawners",
                    core.serialize(def)
                )
                core.get_node_timer(spawnerPos):start(1)
            end
        end
    end
end
function MapgenComponent.noise3dInteger(self, noise, pos)
    return math.abs(math.floor(noise:get_3d(pos) * 2147483647))
end
function MapgenComponent.randomSample(self, list, count)
    local listShuffled = shuffleArray(nil, list)
    local ret = {}
    do
        local i = 0
        while i < count do
            ret[#ret + 1] = listShuffled[i + 1]
            i = i + 1
        end
    end
    return ret
end
function MapgenComponent.findWalls(self, cpos)
    local function is_wall(____, node)
        return node.name ~= "air" and node.name ~= "ignore"
    end
    local dirs = {{x = 1, z = 0}, {x = -1, z = 0}, {x = 0, z = 1}, {x = 0, z = -1}}
    local get_node = core.get_node
    local ret = {}
    local mindist = {x = 0, z = 0}
    local function min(____, a, b)
        return a ~= 0 and math.min(a, b) or b
    end
    for ____, dir in ipairs(dirs) do
        do
            local i = 1
            while i < 9 do
                local pos = vector.add(
                    cpos,
                    vector.new(dir.x * i, 0, dir.z * i)
                )
                local node = get_node(pos)
                if is_wall(nil, node) then
                    local frontBelow = vector.subtract(
                        pos,
                        vector.new(dir.x, 1, dir.z)
                    )
                    local above = vector.add(
                        pos,
                        vector.new(0, 1, 0)
                    )
                    if is_wall(
                        nil,
                        get_node(frontBelow)
                    ) and is_wall(
                        nil,
                        get_node(above)
                    ) then
                        ret[#ret + 1] = {
                            pos = pos,
                            facing = vector.new(-dir.x, 0, -dir.z)
                        }
                        if dir.z == 0 then
                            mindist.x = min(nil, mindist.x, i - 1)
                        else
                            mindist.z = min(nil, mindist.z, i - 1)
                        end
                    end
                    break
                end
                i = i + 1
            end
        end
    end
    local isCave = false
    if not is_wall(
        nil,
        get_node(vector.offset(cpos, 0, -1, 0))
    ) then
        do
            local i = 1
            while i < 9 do
                local pos = vector.offset(cpos, 0, -1 * i, 0)
                local node = get_node(pos)
                if is_wall(nil, node) then
                    cpos = vector.offset(pos, 0, 1, 0)
                    isCave = true
                    break
                end
                i = i + 1
            end
        end
    end
    local biome = core.get_biome_data(cpos)
    local ____biome_5
    if biome then
        ____biome_5 = core.get_biome_name(biome.biome)
    else
        ____biome_5 = ""
    end
    local biomeName = ____biome_5
    return {
        walls = ret,
        size = {x = mindist.x * 2, z = mindist.z * 2},
        biome = biomeName,
        cpos = cpos,
        isCave = isCave
    }
end
return ____exports
 end,
["api"] = function(...) 
local ____lualib = require("lualib_bundle")
local __TS__New = ____lualib.__TS__New
local ____exports = {}
local ____api_2Ecomponent = require("src.components.api.component")
local ApiComponent = ____api_2Ecomponent.default
local ____mapgen_2Ecomponent = require("src.components.mapgen.component")
local MapgenComponent = ____mapgen_2Ecomponent.default
local apiComponent = __TS__New(ApiComponent)
local mapgenComponent = __TS__New(MapgenComponent)
apiComponent:initSpawner()
apiComponent:initSpawnerEnv()
core.set_gen_notify({dungeon = true, large_cave_end = true})
core.register_on_generated(function(____, minp, maxp, blockseed)
    mapgenComponent.registerOnGenerated(minp, maxp, blockseed, apiComponent)
end)
x_spawners_api = {api = apiComponent}
return ____exports
 end,
}
return require("api", ...)
