# X Spawners API [x_spawners_api]

Primarily adds an API for registering spawner blocks for other mods to use.

![screenshot](screenshot.png)

## Features

- Activations area - radius 16 blocks - when player is inside this aread the spawner will activate
- Placing torch (`group:torch`) on top of the spawner will disable the spawner
- Spawner will not work if all adjacent sides are blocked
- Some mobs can spawn only during night/day only (or both)
- Some mobs can spawn in water (e.g. `group:water`) or any other defined `node` in cofiguration
- Spawner will stop spawning if there are too many mobs of the same type in the aread (9x9x9 nodes)
- Spawner will stop spawning if there are too many entities in MapBlock area (16x16x16 nodes)
- Mobs will spawn around spawner randomly in 9x9x3 area - mob height (collisionbox) is being accounted
- Spawner will not spawn in protected areas
- Spawner can spawn up to four mobs at the same time
- If the spawner is not spawning (in 'waiting' state) for too long, it will get rusted and will not work anymore - only digging and placing the spwaner again will activate it
- If admin (or someone with `privs` priviledge) will place the spawner, this spawner will never rust
- If spawner has environmental configuration it will generate spawners during mapgen
- Environmental can be found in dungeons and caves
- Environmental spawners are not rusting
- Environmental will not drop spawner when dug
- Wrote in TypeScript

## Usage

- right click (secondary action) on spawner with egg item - works with animalia crates and net (assuming you have animal inside)

## Install

- If you are have `nvm` installed make sure to use `nvm use` to switch to the correct node version
- Do `npm i`

## Build

- build: `npm run build`
- watch: `npm run watch`

## API

see included [API.md](API.md) file for more info

## Report Bugs/Suggestions

https://bitbucket.org/minetest_gamers/x_spawners_api/issues

## License

see included [LICENSE.txt](LICENSE.txt) file for more info

## Installation

see: https://docs.luanti.org/for-players/installing-mods
