# MT-Channels -- By Elysian

This mod adds channels. These are private messages that can be sent to multiple players.## Config

## Config
`mt_channels.priv`: Use "channels" for custom privilege or other privilege name for existing privilege
`mt_channels.colors`: Use "custom" for custom colors or "basic" for basic colors

Note: If you are using custom colors, you can add additional colors in `colors.lua`. (View [here](https://github.com/Elysian-dev/Mt-Channels?tab=readme-ov-file#register-color))

# Commands

- `/cp`: Open the panel to manage your channel (if you are the owner). If you aren't the owner, you can invite players
- `/c`: Send a message in the channel.
- `/ca`: Accept the invitation if there is an invitation pending.
- `/cd`: Decline the invitation if there is an invitation pending.

- `/channel <del> <channel> or <add | rm | show> <player_name> or <list> [<channel>]` (Admin Command with privilege `channels_admin`)
    - `<del | edit> <channel>`: You can delete or edit a channel 
        - Examples: 
            - `/channel del Channel-Elysian` - Delete the channel named "Channel-Elysian"
    - `<add | rm | show> <player_name> [<channel_name>]`: You can add, remove player from a channel or show player's channel
        - Examples:
            - `/channel add Elysian Channel-Elysian` - Add Elysian to "Channel-Elysian"
            - `/channel rm Elysian Channel-Elysian` - Remove Elysian to "Channel-Elysian"
            - `/channel show Elysian` - Show which channel Elysian is in
    - `<list> [<channel>]`: You can view the list of all channels that exist or the list of members of a specific channel
        - Examples:
            - `/channel list` - View all channels that exist on the server
            - `/channel list Channel-Elysian` - View players in the channel "Channel-Elysian"

## API
- [Basics functions](https://github.com/Elysian-dev/Mt-Channels?tab=readme-ov-file#basics)
- [Colors functions](https://github.com/Elysian-dev/Mt-Channels?tab=readme-ov-file#colors)
- [Players functions](https://github.com/Elysian-dev/Mt-Channels?tab=readme-ov-file#players)
   - [Owners functions](https://github.com/Elysian-dev/Mt-Channels?tab=readme-ov-file#owners)
- [Invites functions](https://github.com/Elysian-dev/Mt-Channels?tab=readme-ov-file#invites)

### Basics
- `mt_channels.create(channel_name, owner, color)`: Register a new channel
    - Example: `mt_channels.create("Channel-Elysian","Elysian","red")`
- `mt_channels.delete(channel_name)`: Delete the channel
    - Example: `mt_channels.delete("Channel-Elysian")`
- `mt_channels.edit(channel_name, owner, color)`: Edit the channel (name and owner name and color)
    - Example: `mt_channels.edit("Channel-Elysian", "Elysian", "yellow")`
- `mt_channels.exists(channel_name)`: Check if the channel exists --> returns True if the channel exists, else returns False
    - Examples: 
        - `mt_channels.exists("Channel-Elysian")` --> returns True
        - `mt_channels.exists("Channel-Salzar")` --> returns False
- `mt_channels.send_message(channel_name, author, message, type)`: Send a message in the channel (All players in a channel can see the message)
    - Examples: 
        - `mt_channels.send_message("Channel-Elysian", "Elysian", "Hello, how are you?")` - In the channel, you can see "(Channel-Elysian) <Elysian> Hello, how are you?"
        - `mt_channels.send_message("Channel-Elysian", "Elysian", " joined the channel.", "info")` - In the channel, you can see  "(Channel-Elysian) Elysian joined the channel.
- `mt_channels.get_channel(channel_name)`: Get table of the channel specified --> return table
    - Example:
        - `mt_channels.get_channel(channel_name)` --> {owner="Elysian", color="red", players={"Elysian"}}
- `mt_channels.get_all_channels()`: Get all channel exists on the server but only use this solution if you cannot do otherwise.
    - Example:
        - `mt_channels.get_all_channels()` --> {"Channel-Elysian"={owner="Elysian", color="red", players={"Elysian"}}}

### Colors
- `mt_channels.register_color(color_name, color_code)`: Register new custom color <a id="register-color"></a>
    - Example: `mt_channels.register_color("red", "#FF2C00")`
- `mt_channels.get_color_by_colorname(colorname)`: Get custom color by color name (registered in `colors.lua`)
    - Example: `mt_channels.get_color_by_colorname("red")` --> returns "#FF2C00"
- `mt_channels.get_custom_colors()`: Get all custom color (registered in `colors.lua`) --> returns the list of custom colors or returns nil if `mt_channels.colors` == "basic"
    - Example: `mt_channels.get_custom_colors()` --> "red,yellow,green,blue,purple,orange,pink,cyan,white,gray,brown"
- `mt_channels.get_color(channel_name)`: Get color of an channel --> returns color of the channel if it exist, else returns false
    - Example: `mt_channels.get_color("Channel-Elysian")` --> "red"

### Players
- `mt_channels.add_player(player_name, channel_name)`: Add a player to a channel
    - Example: `mt_channels.add_player("Salzar", "Channel-Elysian")`
- `mt_channels.remove_player(player_name, channel_name)`: --> Remove a player from a channel
    - Example: `mt_channels.remove_player("Salzar", "Channel-Elysian")`
- `mt_channels.get_players(channel_name)`: Get the list of all players in a channel --> returns players list in a channel
    - Example: `mt_channels.get_players("Channel-Elysian")` --> returns "Elysian, Salzar"
- `mt_channels.player_in_channel(player_name, channel_name)`: Check if a player is in a channel --> returns True if a player is in the channel, else returns False
    - Examples: 
        - `mt_channels.player_in_channel("Elysian", "Channel-Elysian")` --> returns True
        - `mt_channels.player_in_channel("Salzar", "Channel-Elysian")` --> returns False

### Owners
- `mt_channels.is_owner(player_name, channel_name)`: Check if a player is the owner's channel --> returns True or False
    - Examples: 
        - `mt_channels.is_owner("Elysian", "Channel-Elysian")` --> returns True
        - `mt_channels.is_owner("Salzar", "Channel-Elysian")` --> returns False

- `mt_channels.get_channel_by_owner(owner)`: Get channel name by the owner name --> returns channel name and returns False if the owner isn't the owner of this channel
    - Examples: 
        - `mt_channels.get_channel_by_owner("Elysian")` --> returns "Channel-Elysian"
        - `mt_channels.get_channel_by_owner("Salzar")` --> returns False
- `mt_channels.get_owner(channel_name)`: Get the owner's channel --> returns owner name or False if the channel doesn't exists
    - Examples: 
        - `mt_channels.get_owner("Channel-Elysian")` --> returns "Elysian"
        - `mt_channels.get_owner("Channel-Salzar")` --> returns False
- `mt_channels.get_player_channel(player_name)`: Get the channel with player name --> returns channel name if player is in a channel, else returns nil
    - Examples: 
        - `mt_channels.get_player_channel("Elysian")` --> returns "Channel-Elysian"
        - `mt_channels.get_player_channel("Salzar")` --> returns nil

### Invites
- `mt_channels.send_invite(channel_name, inviter, invitee)`: Invite a player to join your channel
    - Example: `mt_channels.send_invite("Channel-Elysian", "Elysian", "Salzar")`
- `mt_channels.accept_invite(name)`: Accept the invite if you have a pending invite
    - Example: `mt_channels.accept_invite("Salzar")` - Salzar accept the invite to join your channel
- `mt_channels.decline_invite(name)`: Decline the invite if you have a pending invite
    - Example: `mt_channels.decline_invite("Salzar")` - Salzar decline the invite to join your channel
- `mt_channels.get_invite_pending(name)`: Get the invite pending --> returns invite pending of the name (a table: `{channel = channel_name, inviter = inviter_name}`)
    - Example: `mt_channels.get_invite_pending("Salzar")` --> .channel = "Channel-Elysian" and .inviter = "Elysian"