mt_channels = {}
dofile(minetest.get_modpath("mt_channels") .. "/config.lua")
dofile(minetest.get_modpath("mt_channels") .. "/api.lua")

if mt_channels.priv == nil or mt_channels.priv == "default" then
    mt_channels.priv = "shout"
elseif mt_channels.priv == "channels" then
    core.register_privilege("channels", {
        description = "Can create channels"
    })
end

if mt_channels.colors == "custom" then
    dofile(minetest.get_modpath("mt_channels") .. "/colors.lua")
end


local function formspec_manage(player_name)
    local manage_players = ""
    local channel_name = mt_channels.get_player_channel(player_name)
    if mt_channels.get_owner(channel_name) == player_name and #mt_channels.get_players(channel_name) > 1 then
        manage_players = "image_button_exit[8.5,1.7;0.5,0.5;mt-channels_bin.png;delete_player1;;false;false]" 
        if #mt_channels.get_players(channel_name) > 2 then
            manage_players = manage_players ..
            "image_button_exit[8.5,2.2;0.5,0.5;mt-channels_bin.png;delete_player2;;false;false]"
        end
        if #mt_channels.get_players(channel_name) > 3 then
            manage_players = manage_players ..
            "image_button_exit[8.5,2.7;0.5,0.5;mt-channels_bin.png;delete_player3;;false;false]"
        end
        if #mt_channels.get_players(channel_name) > 4 then
            manage_players = manage_players ..
            "image_button_exit[8.5,3.2;0.5,0.5;mt-channels_bin.png;delete_player4;;false;false]"
        end
    end
    local formspec = "formspec_version[6]" ..
        "size[10.5,6]" ..
        "background[0,0;10.5,6;mt-channels_background.png;true]" ..
        "label[3.9,0.6;Manage Players]" ..
        "textlist[1.4,1.2;7,2.5;;" .. table.concat(mt_channels.get_players(channel_name), ",") .. ";1;false]" ..
        manage_players ..
        "image_button[3.1,4.2;4,1;mt-channels_button.png;invite;Invite a player;false;false;mt-channels_button_pressed.png]"
    return formspec
end

core.register_chatcommand("cp", {
    description = "Open the channels panel to manage your channel.",
    privs = {[mt_channels.priv]=true},
    func = function(name, param)
        local channel_name = mt_channels.get_player_channel(name)
        if channel_name and name ~= mt_channels.get_owner(channel_name) then
            core.show_formspec(name, "mt_channels:manage_players", formspec_manage(name))
            return true
        end
        local text = "You don't have a channel."
        if channel_name then
            text = "You're in the channel: " .. channel_name
        end
        local color = ""
        if mt_channels.get_color(channel_name) then
            color = "label[2.8,2.1;Color: " .. core.colorize(mt_channels.get_color(channel_name), mt_channels.get_color(channel_name)) .. "]"
        end
        local manage_players = ""
        if mt_channels.exists(channel_name) then
            manage_players = "image_button_exit[2.25,5.8;3.5,1;mt-channels_button.png;manage;Manage Players;false;false;mt-channels_button_pressed.png]"
        end
        if not channel_name then
            channel_name = "Channel-" .. name
        end
        local formspec = "formspec_version[6]" ..
                        "size[8,7]" ..
                        "background[0,0;8,7;mt-channels_background.png;true]" ..
                        --"label[2.46,0.5;MT-Channels]" ..
                        "hypertext[0,0.5;8,1;;<center>MT-Channels</center>]" ..
                        --"label[2,1.7;" .. text .. "]" ..
                        "hypertext[0,1.5;8,1;;<center>" .. text .. "</center>]" ..
                        color ..
                        "textarea[1,3.2;3,1;name;Channel Name;".. channel_name .. "]" ..
                        "label[4.5,3;Choose color]" ..
                        "dropdown[4.6,3.2;1.9,1;color;".. (mt_channels.get_custom_colors() or "red,yellow,blue,green,grey,cyan,pink,magenta") ..";1]" ..
                        "image_button_exit[2.25,4.6;3.5,1;mt-channels_button.png;save;Save Changes;false;false;mt-channels_button_pressed.png]" ..
                        manage_players
        core.show_formspec(name, "mt_channels:panel", formspec)
    end
})

core.register_on_leaveplayer(function(player, timed_out)
    local name = player:get_player_name()
    if mt_channels.get_invite_pending(name) then
        mt_channels.decline_invite(name)
    end
    if mt_channels.get_player_channel(name) then
        local channel_name = mt_channels.get_player_channel(name)
        mt_channels.remove_player(name, channel_name)
        mt_channels.send_message(channel_name, name, name .. " left the channel.", "info")
    end
end)

local function get_connected_player_names(not_players)
    local players = minetest.get_connected_players()
    local names = {}
    for _, player in ipairs(players) do
        local name = player:get_player_name()
        local not_player = false
        if not_players then
            for _, not_player_name in ipairs(not_players) do
                if name == not_player_name then
                    not_player = true
                    break
                end
            end
        end
        if not not_player then
            table.insert(names, name)
        end
    end
    return table.concat(names, ","), #names
end

core.register_on_player_receive_fields(function(player, formname, fields)
    local player_name = player:get_player_name()
    local channel = mt_channels.get_player_channel(player_name)
    if formname == "mt_channels:panel" then
        local channel_name = fields.name
        if fields.save then
            if mt_channels.exists(channel) then
                mt_channels.edit(channel_name, player_name, fields.color)
                core.chat_send_player(player_name, "Channel " .. channel_name .. " updated.")
                return true
            end
            mt_channels.create(channel_name, player_name, fields.color)
            core.chat_send_player(player_name, "Channel " .. channel_name .. " created.")
        elseif fields.manage then
            core.show_formspec(player_name, "mt_channels:manage_players", formspec_manage(player_name))
        end
    elseif formname == "mt_channels:manage_players" then
        if fields.invite then
            local players, nb_player_connected = get_connected_player_names(mt_channels.get_players(channel))
            if nb_player_connected == 0 then
                core.chat_send_player(player_name, "All players who are currently logged in are already in the channel.")
                return true
            end
            local formspec = "formspec_version[6]" ..
                "size[8,5]" ..
                "background[0,0;8,5;mt-channels_background.png;true]" ..
                "dropdown[2.3,1.5;3,0.8;selected_player;" .. players .. ";1;false]" ..
                "image_button_exit[1.9,2.7;4,1;mt-channels_button.png;invite_send;Invite the player;false;false;mt-channels_button_pressed.png]"
            core.show_formspec(player_name, "mt_channels:invite", formspec)
        elseif fields.delete_player1 then
            if not mt_channels.get_players(channel)[1] then
                return
            end
            mt_channels.send_message(channel, player_name, player_name .. " kicked " .. mt_channels.get_players(channel)[2] .. " from the channel.", "info")
            mt_channels.remove_player(mt_channels.get_players(channel)[2], channel)
            core.show_formspec(player_name, "mt_channels:manage_players", formspec_manage(player_name))
        elseif fields.delete_player2 then
            mt_channels.send_message(channel, player_name, player_name .. " kicked " .. mt_channels.get_players(channel)[3] .. " from the channel.", "info")
            mt_channels.remove_player(mt_channels.get_players(channel)[3], channel)
            core.show_formspec(player_name, "mt_channels:manage_players", formspec_manage(player_name))
        elseif fields.delete_player3 then
            mt_channels.send_message(channel, player_name, player_name .. " kicked " .. mt_channels.get_players(channel)[4] .. " from the channel.", "info")
            mt_channels.remove_player(mt_channels.get_players(channel)[4], channel)
            core.show_formspec(player_name, "mt_channels:manage_players", formspec_manage(player_name))
        elseif fields.delete_player4 then
            mt_channels.send_message(channel, player_name, player_name .. " kicked " .. mt_channels.get_players(channel)[5] .. " from the channel.", "info")
            mt_channels.remove_player(mt_channels.get_players(channel)[5], channel)
            core.show_formspec(player_name, "mt_channels:manage_players", formspec_manage(player_name))
        end
    elseif formname == "mt_channels:invite" then
        if fields.invite_send then
            if #mt_channels.get_players(channel) >= 5 then
                core.chat_send_player(player_name, "Your channel is full. You cannot invite more players.")
                return true
            end
            local name = fields.selected_player
            local channel_name = mt_channels.get_player_channel(player_name)
            mt_channels.send_invite(channel_name, player_name, name)
            core.chat_send_player(name, player_name .. " invites you to join his channel: " .. channel_name .. " (Use /ca to accept or /cd to decline). This invitation will expire in 60 seconds.")
            core.chat_send_player(player_name, "You invited " .. name .. ". This invitation will expire in 60 seconds.")
        end
    end
end)

core.register_chatcommand("c", {
    description = "Send a message to your channel.",
    param = "<message>",
    privs = {[mt_channels.priv]=true},
    func = function(name, param)
        if param == " " or param == "" then
            return true, "You must enter a message."
        end
        local channel_name = mt_channels.get_player_channel(name)
        if not channel_name then
            return true, "You don't in a channel. Use /cp for create one."
        end
        mt_channels.send_message(channel_name, name, param)
    end
})

core.register_chatcommand("ca", {
    description = "Accept an invite to join a channel",
    privs = {[mt_channels.priv]=true},
    func = function(name, param)
        if not mt_channels.get_invite_pending(name) then
            return true, "You do not have a pending channel invitation."
        end
        mt_channels.accept_invite(name)
    end
})

core.register_chatcommand("cd", {
    description = "Decline an invite to join a channel",
    privs = {[mt_channels.priv]=true},
    func = function(name, param)
        if not mt_channels.get_invite_pending(name) then
            return true, "You do not have a pending channel invitation."
        end
        mt_channels.decline_invite(name)
    end
})

core.register_privilege("channels_admin",{
    description = "Can manage all channels."
})

core.register_chatcommand("channel", {
    description = "Admin manage channels\n<del> <channel> for delete channel\n<add | rm | show> <player> [<channel>] for add/rm a player to a channel\n<list> [<channel>] for list all channels or spécific channel.",
    param = "<del | add | rm | show | list> <player/channel> [<channel>]",
    privs = {channels_admin=true},
    func = function(name, param)
        local params = param:split(" ")
        local param1, param2, param3 = params[1], params[2], param[3]
        if not param1 then
            return true, "Invalid parameters. Use '/help channel' for more information."
        end
        if param1 == "del" then
            if not param2 or not mt_channels.exists(param2) then
                return true, "Channel does not exist."
            end
            mt_channels.delete(param2)
            return true, "Channel " .. param2 .. " deleted."
        elseif param1 == "add" then
            if not param2 or not core.player_exists(param2) then
                return true, "Player does not exist."
            end
            if not param3 or not mt_channels.exists(param3) then
                return true, "Channel does not exist."
            end
            mt_channels.add_player(param2, param3)
            return true, "Player " .. param2 .. " added to channel " .. param3 .. "."
        elseif param1 == "rm" then
            if not param2 or not core.player_exists(param2) then
                return true, "Player does not exist."
            end
            if not param3 or not mt_channels.exists(param3) then
                return true, "Channel does not exist."
            end
            if mt_channels.get_owner(param3) == param2 then
                return true, "You cannot remove the owner from the channel. Use /channel del <channel> to delete the channel."
            end
            mt_channels.remove_player(param2, param3)
            return true, "Player " .. param2 .. " removed from channel " .. param3 .. "."
        elseif param1 == "show" then
            if not param2 or not core.player_exists(param2) then
                return true, "Player does not exist."
            end
            local channel = mt_channels.get_player_channel(param2)
            return true, param2 .. " is in channel: " .. (channel or "No channel")
        elseif param1 == "list" then
            local list = {}
            if param2 and mt_channels.exists(param2) then
                local channel = mt_channels.get_channel(param2)
                table.insert(list, "Channel: " .. param2 .. " (Owner: " .. channel.owner .. ") | Players: " .. table.concat(channel.players, ", "))
                return true, table.concat(list, "\n")
            else
                for channel_name, channel in pairs(mt_channels.get_all_channels()) do
                    table.insert(list, channel_name .. " (Owner: " .. channel.owner .. ")")
                end
                return true, "All Channels (" .. #list .. "): " .. table.concat(list, ", ")
            end
        end
    end
})