Warp Potions
===

Fair teleport system mod for Minetest survival servers by Shara RedCat.


Features
--------

This mod adds eight warp potions which can be placed as decorative items. Smashing a warp potion (right click) after it has been placed sets a warp point for that player. There are eight warp points, one for each potion, which can be independently set and are unique to each player. Using a warp potion in the potion inventory will return the player to the warp point for that potion. You can only travel to a warp point if the correct potion type is in the potion inventory.

The potion inventory auto-sorts potions into the correct slots and cannot contain anything other than a maximum of 99 potions of each type. It currently supports use with:
- sfinv
- unified_inventory
- inventory_plus


Why are these potions fair?
---------------------------

The ability to instantly travel from one location to another is a massive benefit which should not come without a cost on a serious survival server. This mod has been designed to meet the following goals to encourage fairness and game balance:
- Limits PVP abuse: You cannot set a warp point to another player's protected area.
- Does not remove the need to travel: You must reach a location the first time without using warp potions before you can teleport there.
- No short-cuts for new players: Your warp points are unique to you, so another player cannot use your warp points to instantly access deep mines or other desirable areas without doing their own work. 
- Per use cost: Potions are consumed both to set and to move to warp points.
- Progression earned over time: Some potions are much more expensive than others, so the full number of warp points can be unlocked one by one as the player progresses.
- Strategy gives rewards: The differing costs of warp potions means players should think about which potions to use for which warp points in order to minimise costs. 


Licenses and Attribution 
-----------------------

Code for this mod is by Shara RedCat and shivajiva and is released under MIT (https://opensource.org/licenses/MIT).

Textures for this mod, unless otherwise listed in the license file, are released under CC BY-SA 4.0 (https://creativecommons.org/licenses/by-sa/4.0/), attribution: Shara RedCat.
